/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.BufferUtils;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.DynamicInsetsComponent;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.InsetsComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.Direction;
import java.nio.ByteBuffer;
import java.util.Objects;
import mythruna.fabric.ClothingPainter;
import mythruna.fabric.FabricPaintTarget;
import mythruna.fabric.FabricType;
import mythruna.fabric.SwatchShape;
import mythruna.fabric.SwatchShapeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchShapeSelector
extends Container {
    static Logger log = LoggerFactory.getLogger(SwatchShapeSelector.class);
    private VersionedList<String> types = new VersionedList();
    private VersionedList<String> variations = new VersionedList();
    private Selector<String> type;
    private VersionedReference<String> typeRef;
    private Selector<String> variant;
    private VersionedReference<String> variantRef;
    private int selectedShapeIndex = -1;
    private VersionedHolder<SwatchShape> selectedSwatchShape = new VersionedHolder();
    private int availableEdges = 0;
    private int edgeMask = 0;
    private Mask[] masks;
    private Label example;
    private VersionedReference<FabricType> fabricTypeRef;
    private ClothingPainter oneCell = new PackedNormalsTarget(32, 32, true);
    private Texture shapeTexture;
    private Image shapeImage;
    private ImageRaster shapeRaster;

    public SwatchShapeSelector(VersionedReference<FabricType> fabricTypeRef) {
        this.fabricTypeRef = fabricTypeRef;
        if (this.selectedShapeIndex == -1) {
            this.selectedShapeIndex = SwatchShapeIndex.findBaseShape((String)"square", (String)"full");
        }
        this.selectedSwatchShape.updateObject((Object)SwatchShapeIndex.get((int)this.selectedShapeIndex));
        ElementId parentId = new ElementId("block.popup");
        Container selectors = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Last)), new Object[0]);
        selectors.addChild((Node)new Label("Shape:", parentId.child("label")), new Object[0]);
        this.type = (Selector)selectors.addChild((Node)new Selector(this.types, parentId.child("selector")), new Object[]{1});
        this.typeRef = this.type.createSelectedItemReference();
        selectors.addChild((Node)new Label("Orient.", parentId.child("label")), new Object[0]);
        this.variant = (Selector)selectors.addChild((Node)new Selector(this.variations, parentId.child("selector")), new Object[]{1});
        this.variantRef = this.variant.createSelectedItemReference();
        this.shapeTexture = this.oneCell.getDiffuseTexture();
        this.shapeImage = this.shapeTexture.getImage();
        this.shapeRaster = ImageRaster.create((Image)this.shapeImage);
        this.updateExample();
        this.masks = new Mask[]{new Mask(Direction.North), new Mask(Direction.East), new Mask(Direction.South), new Mask(Direction.West)};
        Container toggles = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
        toggles.setInsetsComponent((InsetsComponent)new DynamicInsetsComponent(0.5f, 0.5f, 0.5f, 0.5f));
        int column = 0;
        Label label = (Label)toggles.addChild((Node)new Label("Hard\nEdges ", parentId.child("label")), new Object[]{column, 1});
        label.setTextVAlignment(VAlignment.Center);
        toggles.addChild((Node)this.masks[3].check, new Object[]{++column, 1});
        toggles.addChild((Node)this.masks[0].check, new Object[]{++column, 0});
        this.example = (Label)toggles.addChild((Node)new Label(""), new Object[]{column, 1});
        toggles.addChild((Node)this.masks[2].check, new Object[]{column, 2});
        toggles.addChild((Node)this.masks[1].check, new Object[]{++column, 1});
        this.example.setBackground((GuiComponent)new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.25f)));
        this.example.setIcon((GuiComponent)new IconComponent(this.shapeTexture, new Vector2f(2.0f, 2.0f), 4.0f, 4.0f, 0.01f, false));
        this.types.addAll(SwatchShapeIndex.getTypes());
        this.resetFields();
        this.resetSelectedType();
    }

    public static Image createImage(int width, int height) {
        int size = width * height * 4;
        ByteBuffer data = BufferUtils.createByteBuffer((int)size);
        return new Image(Image.Format.BGRA8, width, height, data, ColorSpace.Linear);
    }

    public void setSelectedShapeIndex(int selectedShapeIndex) {
        if (this.selectedShapeIndex == selectedShapeIndex) {
            return;
        }
        this.selectedShapeIndex = selectedShapeIndex;
        this.resetFields();
    }

    public int getSelectedShapeIndex() {
        return this.selectedShapeIndex;
    }

    public VersionedReference<SwatchShape> createSelectedTypeRef() {
        return this.selectedSwatchShape.createReference();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        boolean changed = false;
        if (this.typeRef.update()) {
            this.resetVariations((String)this.typeRef.get());
            changed = true;
        }
        if (this.variantRef.update()) {
            changed = true;
        }
        if (changed) {
            this.resetAvailableMasks();
        }
        for (Mask mask : this.masks) {
            if (!mask.update()) continue;
            changed = true;
        }
        if (changed) {
            this.resetSelectedType();
        }
        if (changed || this.fabricTypeRef.update()) {
            this.updateExample();
        }
    }

    protected void toggleMask(int dirMask, boolean on) {
        int newMask = on ? this.edgeMask | dirMask : this.edgeMask & ~dirMask;
        if (this.edgeMask != newMask) {
            log.info("Mask has changed from:" + Integer.toBinaryString(this.edgeMask) + " to:" + Integer.toBinaryString(newMask));
            this.edgeMask = newMask;
        }
    }

    protected void updateExample() {
        SwatchShape selected = SwatchShapeIndex.get((int)this.selectedShapeIndex);
        FabricType fabric = (FabricType)this.fabricTypeRef.get();
        ColorRGBA clear = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.shapeRaster.setPixel(i, j, clear);
            }
        }
        fabric.paint((FabricPaintTarget)this.oneCell, 0, 0, selected);
    }

    protected void resetVariations(String baseType) {
        String original = (String)this.variant.getSelectedItem();
        this.variations.clear();
        this.variations.addAll(SwatchShapeIndex.getVariations((String)baseType));
        if (this.variations.contains((Object)original)) {
            this.variant.setSelectedItem((Object)original);
        } else if (!this.variations.isEmpty()) {
            this.variant.setSelectedItem((Object)((String)this.variations.get(0)));
        }
    }

    protected void resetFields() {
        SwatchShape selected = SwatchShapeIndex.get((int)this.selectedShapeIndex);
        if (selected == null) {
            return;
        }
        this.type.setSelectedItem((Object)selected.getType());
        this.typeRef.update();
        this.resetVariations(selected.getType());
        this.variant.setSelectedItem((Object)selected.getVariation());
        int edgeMask = selected.getEdgeMask();
        for (Mask mask : this.masks) {
            mask.resetChecked(edgeMask);
        }
        this.resetAvailableMasks();
    }

    protected int calculateAvailableMasks() {
        String t = (String)this.type.getSelectedItem();
        String v = (String)this.variant.getSelectedItem();
        int mask = 0;
        for (SwatchShape shape : SwatchShapeIndex.getEdgeMasks((String)t, (String)v)) {
            mask |= shape.getEdgeMask();
        }
        return mask;
    }

    protected void resetAvailableMasks() {
        this.availableEdges = this.calculateAvailableMasks();
        for (Mask mask : this.masks) {
            mask.resetAvailable(this.availableEdges);
        }
    }

    protected void resetSelectedType() {
        log.info("resetSelectedType()");
        String t = (String)this.type.getSelectedItem();
        String v = (String)this.variant.getSelectedItem();
        int foundType = -1;
        SwatchShape foundShape = null;
        for (int i = 0; i < SwatchShapeIndex.getShapeCount(); ++i) {
            SwatchShape shape = SwatchShapeIndex.get((int)i);
            if (shape == null || !Objects.equals(t, shape.getType()) || !Objects.equals(v, shape.getVariation())) continue;
            log.info("    checking:" + Integer.toBinaryString(shape.getEdgeMask()) + " against:" + Integer.toBinaryString(this.edgeMask));
            if (shape.getEdgeMask() != this.edgeMask) continue;
            foundType = i;
            foundShape = shape;
            break;
        }
        if (foundType == -1) {
            log.warn("  No type found for:" + t + ", " + v + ", " + Integer.toBinaryString(this.edgeMask));
            return;
        }
        if (foundType == this.selectedShapeIndex) {
            log.info("  Type already set to:" + foundType);
            return;
        }
        log.info("  New selected shape index:" + foundType);
        this.selectedShapeIndex = foundType;
        this.selectedSwatchShape.updateObject(foundShape);
    }

    private class PackedNormalsTarget
    extends ClothingPainter {
        private Vector3f lightDir;

        public PackedNormalsTarget(int width, int height, boolean supportAlpha) {
            super(width, height, supportAlpha);
            this.lightDir = new Vector3f(1.0f, -1.0f, -0.25f).normalizeLocal();
        }

        public void paint(int x, int y, ColorRGBA diffuse, ColorRGBA normal, ColorRGBA specular, float alpha) {
            Vector3f norm = new Vector3f(normal.r * 2.0f - 1.0f, normal.g * 2.0f - 1.0f, normal.b * 2.0f - 1.0f);
            float dot = norm.dot(this.lightDir);
            float scale = -dot + 1.0f;
            diffuse.r *= scale;
            diffuse.g *= scale;
            diffuse.b *= scale;
            y = 31 - y;
            super.paint(x, y, diffuse, normal, specular, alpha);
        }
    }

    private class Mask {
        private int dirMask;
        private Checkbox check;
        private VersionedReference<Boolean> checkRef;

        public Mask(Direction dir) {
            this.dirMask = dir.getBitMask();
            this.check = new Checkbox("");
            this.checkRef = this.check.getModel().createReference();
            this.check.setInsetsComponent((InsetsComponent)new DynamicInsetsComponent(0.5f, 0.5f, 0.5f, 0.5f));
        }

        public void resetChecked(int mask) {
            this.check.setChecked((mask & this.dirMask) == this.dirMask);
        }

        public boolean update() {
            if (this.checkRef.update()) {
                SwatchShapeSelector.this.toggleMask(this.dirMask, (Boolean)this.checkRef.get());
                return true;
            }
            return false;
        }

        public void resetAvailable(int edgeMask) {
            if ((edgeMask & this.dirMask) == this.dirMask) {
                this.check.setEnabled(true);
                this.check.setCullHint(Spatial.CullHint.Inherit);
                SwatchShapeSelector.this.toggleMask(this.dirMask, (Boolean)this.checkRef.get());
            } else {
                this.check.setEnabled(false);
                this.check.setCullHint(Spatial.CullHint.Always);
                SwatchShapeSelector.this.toggleMask(this.dirMask, false);
            }
        }
    }
}

