/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Objects;
import mythruna.fabric.SwatchShape;
import mythruna.fabric.io.SwatchShapeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchShapeIndex {
    static Logger log = LoggerFactory.getLogger(SwatchShapeIndex.class);
    private static SwatchShape[] shapes;
    private static int shapeCount;
    private static SwatchShape badShape;
    private static int badShapeIndex;
    private static Multimap<String, String> variationIndex;
    private static Multimap<String, SwatchShape> edgeIndex;

    private SwatchShapeIndex() {
    }

    public static void initialize(SwatchShapeData data) {
        SwatchShapeIndex.initialize(data.shapes, data.badShapeIndex);
    }

    public static void initialize(SwatchShape[] shapes, int badShapeIndex) {
        log.info("initialize(size:" + shapes.length + ")");
        if (SwatchShapeIndex.shapes != null) {
            throw new IllegalStateException("ShapeIndex is already initialized");
        }
        SwatchShapeIndex.shapes = shapes;
        shapeCount = shapes.length;
        SwatchShapeIndex.badShapeIndex = badShapeIndex;
        badShape = shapes[badShapeIndex];
        for (SwatchShape shape : shapes) {
            if (shape == null) continue;
            variationIndex.put((Object)shape.getType(), (Object)shape.getVariation());
            edgeIndex.put((Object)SwatchShapeIndex.toKey(shape.getType(), shape.getVariation()), (Object)shape);
        }
    }

    public static void reset() {
        shapes = null;
        shapeCount = 0;
        badShapeIndex = 0;
        badShape = null;
        variationIndex.clear();
    }

    public static String toKey(String type, String variation) {
        return type + "." + variation;
    }

    public static Collection<String> getTypes() {
        return variationIndex.keySet();
    }

    public static Collection<String> getVariations(String type) {
        return variationIndex.get((Object)type);
    }

    public static Collection<SwatchShape> getEdgeMasks(String type, String variation) {
        return edgeIndex.get((Object)SwatchShapeIndex.toKey(type, variation));
    }

    public static SwatchShape get(int shape) {
        if (shape >= 0 && shape < shapeCount) {
            return shapes[shape];
        }
        return badShape;
    }

    public static void setBadShapeIndex(int index) {
        badShapeIndex = index;
    }

    public static int getBadShapeIndex() {
        return badShapeIndex;
    }

    public static void override(int index, SwatchShape shape) {
        SwatchShapeIndex.shapes[index] = shape;
    }

    public static boolean isInitialized() {
        return shapes != null;
    }

    public static int getShapeCount() {
        return shapeCount;
    }

    public static SwatchShape[] getShapes() {
        return shapes;
    }

    public static int findBaseShape(String type, String variant) {
        return SwatchShapeIndex.findBaseShape(type, variant, -1);
    }

    public static int findBaseShape(String type, String variant, int defaultValue) {
        for (int i = 0; i < shapes.length; ++i) {
            SwatchShape shape = shapes[i];
            if (shape == null || !Objects.equals(shape.getType(), type) || !Objects.equals(shape.getVariation(), variant)) continue;
            return i;
        }
        return defaultValue;
    }

    public static int findShape(String fullName) {
        return SwatchShapeIndex.findShape(fullName, -1);
    }

    public static int findShape(String fullName, int defaultValue) {
        for (int i = 0; i < shapes.length; ++i) {
            SwatchShape shape = shapes[i];
            if (shape == null || !Objects.equals(shape.getFullName(), fullName)) continue;
            return i;
        }
        return -1;
    }

    static {
        variationIndex = MultimapBuilder.treeKeys().treeSetValues().build();
        edgeIndex = MultimapBuilder.treeKeys().arrayListValues().build();
    }
}

