/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.crig.AttachmentInfo;
import com.simsilica.crig.AttachmentPoint;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentPointImpl
implements AttachmentPoint {
    static Logger log = LoggerFactory.getLogger(AttachmentPointImpl.class);
    static final long serialVersionUID = 42L;
    private AttachmentInfo info;
    private Spatial source;
    private Vec3d translation = new Vec3d();
    private Quatd rotation = new Quatd();

    public AttachmentPointImpl(AttachmentInfo info, Spatial source) {
        this.info = info;
        this.source = source;
    }

    protected AttachmentInfo getInfo() {
        return this.info;
    }

    protected Spatial getSource() {
        return this.source;
    }

    @Override
    public Vec3d getTranslation() {
        return this.translation;
    }

    @Override
    public Quatd getRotation() {
        return this.rotation;
    }

    public void update() {
        Vec3d offset = this.info.getOffset();
        Quatd orient = this.info.getOrientation();
        offset = offset.divide(new Vec3d(this.source.getWorldScale()));
        Vector3f local = this.source.localToWorld(offset.toVector3f(), null);
        Quaternion localRot = this.source.getWorldRotation().mult(orient.toQuaternion());
        this.translation.set(local);
        this.rotation.set(localRot);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[info:" + this.info + ", translation:" + this.translation + ", rotation:" + this.rotation + "]";
    }
}

