/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.GridBasedId;
import com.simsilica.mworld.WorldGrids;
import java.util.Objects;

public class LeafId
implements GridBasedId {
    public static final int SIZE = 32;
    public static final int CELL_COUNT = 32768;
    public static final Grid GRID = WorldGrids.LEAF_GRID;
    private long leafId;

    public LeafId(long leafId) {
        this.leafId = leafId;
    }

    public static LeafId fromWorld(Vec3i world) {
        return LeafId.fromWorld(world.x, world.y, world.z);
    }

    public static LeafId fromWorld(Vec3d world) {
        return LeafId.fromWorld(world.x, world.y, world.z);
    }

    public static LeafId fromWorld(double x, double y, double z) {
        long id = GRID.worldToId(x, y, z);
        return new LeafId(id);
    }

    public static LeafId fromWorld(int x, int y, int z) {
        long id = GRID.worldToId((double)x, (double)y, (double)z);
        return new LeafId(id);
    }

    @Override
    public long getId() {
        return this.leafId;
    }

    @Override
    public Vec3i getWorld(Vec3i store) {
        Vec3i loc = GRID.idToCell(this.leafId, store);
        loc = GRID.cellToWorld(loc, loc);
        return loc;
    }

    @Override
    public GridCell getGridCell() {
        return this.getGrid().getContainingCell(this.getWorld(null));
    }

    public ColumnId getColumnId() {
        Vec3i world = this.getWorld(null);
        return ColumnId.fromWorld(world);
    }

    @Override
    public Grid getGrid() {
        return GRID;
    }

    @Override
    public Grid getParentGrid() {
        return ColumnId.GRID;
    }

    public int hashCode() {
        return Objects.hash(this.leafId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        LeafId other = (LeafId)o;
        return other.leafId == this.leafId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.leafId + "]";
    }
}

