/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnStates {
    static Logger log = LoggerFactory.getLogger(ColumnStates.class);
    private TileId tileId;
    private Set<Short> dirty = new ConcurrentSkipListSet<Short>();

    public ColumnStates(TileId tileId) {
        this.tileId = tileId;
    }

    public TileId getTileId() {
        return this.tileId;
    }

    public boolean isValid() {
        return this.dirty.isEmpty();
    }

    public boolean markDirty(ColumnId col) {
        return this.markDirty(col.getTileLocalIndexId());
    }

    public boolean markDirty(short tileLocalColumnId) {
        if (log.isTraceEnabled()) {
            log.trace(this.tileId + ".markDirty(" + tileLocalColumnId + ")");
        }
        return this.dirty.add(tileLocalColumnId);
    }

    public Set<Short> getTileLocalColumnIds() {
        return this.dirty;
    }

    public int size() {
        return this.dirty.size();
    }

    public Iterable<ColumnId> getDirtyColumns() {
        return Iterables.transform(this.dirty, (Function)new ToColumnId(this.tileId));
    }

    public boolean markAll(ColumnStates other) {
        return this.dirty.addAll(other.dirty);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id:" + this.tileId + ", dirty:" + this.dirty + "]";
    }

    private static class ToColumnId
    implements Function<Short, ColumnId> {
        private TileId tileId;

        public ToColumnId(TileId tileId) {
            this.tileId = tileId;
        }

        public ColumnId apply(Short s) {
            return ColumnId.fromTileLocalIndexId(this.tileId, s);
        }
    }
}

