/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.google.common.base.MoreObjects;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImageType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainImageId {
    static Logger log = LoggerFactory.getLogger(TerrainImageId.class);
    private TileId tileId;
    private TerrainImageType type;
    private Resolution resolution;

    public TerrainImageId(TileId tileId, TerrainImageType type, Resolution resolution) {
        this.tileId = tileId;
        this.type = type;
        this.resolution = resolution;
    }

    public TileId getTileId() {
        return this.tileId;
    }

    public TerrainImageType getType() {
        return this.type;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public SedectileId getParentId() {
        return this.tileId.getSedectileId();
    }

    public TerrainImageId getLowerResolution() {
        Resolution lower = this.resolution.getLowerResolution();
        return lower == null ? null : new TerrainImageId(this.tileId, this.type, lower);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tileId, this.type, this.resolution});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TerrainImageId other = (TerrainImageId)o;
        if (other.resolution != this.resolution) {
            return false;
        }
        if (other.type != this.type) {
            return false;
        }
        return this.tileId.getId() == other.tileId.getId();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("tileId", (Object)this.tileId).add("type", (Object)this.type).add("resolution", (Object)this.resolution).toString();
    }
}

