/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.pc;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.OffsetCellData;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.ProgressTracker;
import com.simsilica.mworld.ProgressTrackers;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.db.ColumnNeighborhood;
import com.simsilica.mworld.db.ObservableColumnDb;
import com.simsilica.mworld.tile.ColumnStates;
import com.simsilica.mworld.tile.ColumnStatesDb;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImageManager;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.TileManager;
import com.simsilica.mworld.tile.pc.Point;
import com.simsilica.mworld.tile.pc.PointCloudData;
import com.simsilica.mworld.tile.pc.PointCloudDb;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.pc.PointIndex;
import com.simsilica.mworld.tile.pc.PointIndexFunction;
import com.simsilica.mworld.tile.pc.PointType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointCloudManager {
    static Logger log = LoggerFactory.getLogger(PointCloudManager.class);
    private File root;
    private PointCloudDb pointCloudDb;
    private ObservableColumnDb columnDb;
    private TileManager tiles;
    private TerrainImageManager terrainMgr;
    private PointIndexFunction pointIndexFunction;
    private ColumnStatesDb colStates;
    private CopyOnWriteArrayList<TileListener> listeners = new CopyOnWriteArrayList();

    public PointCloudManager(File root, ObservableColumnDb columnDb, TileManager tiles, TerrainImageManager terrainMgr) {
        this.root = root;
        this.pointCloudDb = new PointCloudDb(root);
        this.colStates = new ColumnStatesDb(root, "pc.state");
        this.pointIndexFunction = new PointIndexFunction(){
            private PointType defaultType = new PointType(0);

            @Override
            public PointIndex getPointIndex(int rawType, int type, PointIndex target) {
                if (target == null) {
                    target = new PointIndex();
                }
                return null;
            }
        };
        this.columnDb = columnDb;
        this.tiles = tiles;
        this.terrainMgr = terrainMgr;
        columnDb.addColumnChangeListener(event -> this.markDirty(event.getColumnId()));
    }

    public TileManager getTileManager() {
        return this.tiles;
    }

    public void addTileListener(TileListener l) {
        this.listeners.add(l);
    }

    public void removeTileListener(TileListener l) {
        this.listeners.remove(l);
    }

    public void setPointIndexFunction(PointIndexFunction pointIndexFunction) {
        this.pointIndexFunction = pointIndexFunction;
    }

    public PointIndexFunction getPointIndexFunction() {
        return this.pointIndexFunction;
    }

    public void initialize() {
        this.colStates.initialize();
        this.pointCloudDb.initialize();
    }

    public void terminate() {
        this.pointCloudDb.terminate();
        this.colStates.terminate();
    }

    protected boolean initializeStates(TileId id, ColumnStates states) {
        boolean changed = false;
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateColumns(PointCloudLayer result, ColumnStates states) {
        if (states.isValid()) {
            return false;
        }
        Vec3i origin = result.getTileId().getWorld(null);
        String name = String.format("Low LOD: %d, %d update", origin.x, origin.z);
        ProgressTracker progress = ProgressTrackers.openTracker(name);
        try {
            boolean changed = false;
            progress.setMax(states.size());
            Iterator<ColumnId> it = states.getDirtyColumns().iterator();
            while (it.hasNext()) {
                ColumnId colId = it.next();
                it.remove();
                if (log.isTraceEnabled()) {
                    log.trace("  update column:" + colId);
                }
                long start = System.nanoTime();
                ColumnData col = this.columnDb.getColumn(colId);
                if (log.isTraceEnabled()) {
                    log.trace("  loaded:" + col);
                }
                long end = System.nanoTime();
                log.info(String.format("Loaded column %s in %.2f ms", String.valueOf(colId), (double)(end - start) / 1000000.0));
                start = System.nanoTime();
                Map<PointType, List<Point>> points = this.extractPoints(col);
                end = System.nanoTime();
                if (log.isTraceEnabled()) {
                    log.trace(String.format("Extracted points in %.2f ms", (double)(end - start) / 1000000.0));
                }
                if (!points.isEmpty()) {
                    Vec3i local = colId.getWorld(null).subtract(origin);
                    PointCloudData pc = new PointCloudData(local.x, local.z);
                    for (Map.Entry<PointType, List<Point>> e : points.entrySet()) {
                        List<Point> list = e.getValue();
                        if (list.isEmpty()) continue;
                        pc.setPoints(e.getKey(), list.toArray(new Point[0]));
                    }
                    result.updatePointCloud(pc);
                    changed = true;
                }
                progress.increment();
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            progress.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointCloudLayer getPointCloud(TileId id, Resolution res) {
        if (res != Resolution.High) {
            throw new UnsupportedOperationException("Only high resolution is supported");
        }
        Vec3i origin = id.getWorld(null);
        String name = String.format("Low LOD: %d, %d", origin.x, origin.z);
        ProgressTracker progress = ProgressTrackers.openTracker(name);
        try {
            progress.setMax(4.0);
            PointCloudLayer result = (PointCloudLayer)this.pointCloudDb.get(id);
            progress.increment();
            ColumnStates states = (ColumnStates)this.colStates.get(id);
            Object object = states;
            synchronized (object) {
                progress.increment();
                if (result.getVersion().getLoadVersion() < 0L) {
                    this.initializeStates(id, states);
                }
                progress.increment();
                if (this.updateColumns(result, states)) {
                    this.colStates.update(id, states);
                    result.getVersion().markChanged();
                    this.pointCloudDb.update(id, result);
                }
                progress.increment();
            }
            object = result;
            return object;
        }
        finally {
            progress.close(true);
        }
    }

    protected void markDirty(ColumnId colId) {
        TileId tileId = colId.getTileId();
        if (log.isTraceEnabled()) {
            log.trace("markDirty(" + colId + ") in tile:" + tileId);
        }
        this.colStates.markDirty(colId);
        TileChangeEvent event = new TileChangeEvent(PointCloudLayer.class, tileId, Integer.MAX_VALUE, Resolution.High);
        for (TileListener l : this.listeners) {
            l.tileChanged(event);
        }
    }

    protected Map<PointType, List<Point>> extractPoints(ColumnData col) {
        HashMap<PointType, List<Point>> result = new HashMap<PointType, List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        result.put(new PointType(0), points);
        boolean[][] ground = new boolean[32][32];
        int groundLeft = 1024;
        LeafData[] leafs = col.getLeafs();
        CellData lighting = new ColumnNeighborhood(this.columnDb, col).getLightingCellData();
        PointIndex pointIndex = new PointIndex();
        for (int i = leafs.length - 1; i >= 0; --i) {
            LeafData leaf = leafs[i];
            int yBase = i * 32;
            if (leaf.isEmpty()) continue;
            OffsetCellData leafLight = new OffsetCellData(lighting, 0, yBase, 0);
            for (int x = 0; x < 32; ++x) {
                block2: for (int z = 0; z < 32; ++z) {
                    if (ground[x][z]) continue;
                    for (int y = 31; y >= 0; --y) {
                        int sideMask;
                        int val = leaf.getCell(x, y, z);
                        int type = MaskUtils.getType((int)val);
                        if (type == 0 || (sideMask = MaskUtils.getSideMask((int)val)) == 0) continue;
                        PointIndex index = this.pointIndexFunction.getPointIndex(val, type, pointIndex);
                        if (index == null) {
                            ground[x][z] = true;
                            --groundLeft;
                            continue block2;
                        }
                        if (index.type == null) continue;
                        int light = 0;
                        int mostSun = 0;
                        for (Direction dir : Direction.values()) {
                            int sun;
                            int local;
                            if ((sideMask & dir.getBitMask()) == 0 || (local = leafLight.getCell(x, y, z, dir, -1)) == -1 || (sun = LightUtils.sun((int)local)) <= mostSun) continue;
                            light = local;
                            mostSun = sun;
                        }
                        points.add(new Point(x, yBase + y, z, index.index, (short)light, sideMask));
                    }
                }
            }
            if (groundLeft <= 0) break;
        }
        return result;
    }
}

