/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.tree.AbstractTreeType;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.TileColumnCells;
import com.simsilica.mworld.tile.tree.Tree;
import java.io.Serializable;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticTreeType
extends AbstractTreeType
implements Serializable {
    static Logger log = LoggerFactory.getLogger(StaticTreeType.class);
    static final long serialVersionUID = 42L;
    private int[] types;
    private int[][][] shape;
    private int shapeHeight;
    private int shapeRadius;
    private int xSize;
    private int zSize;
    private byte[][] splat;
    private int xSplatSize;
    private int zSplatSize;
    boolean paranoid = true;

    public StaticTreeType(String name, AtlasCell atlasCell, int[] types, int[][][] shape) {
        this(name, atlasCell, types, shape, null);
    }

    public StaticTreeType(String name, AtlasCell atlasCell, int[] types, int[][][] shape, byte[][] splat) {
        super(name, atlasCell);
        this.types = types;
        this.shape = shape;
        this.shapeHeight = shape.length;
        this.zSize = shape[0].length;
        this.xSize = shape[0][0].length;
        this.shapeRadius = this.xSize >= this.zSize ? this.xSize / 2 : this.zSize / 2;
        this.splat = splat;
        if (splat != null) {
            this.zSplatSize = splat.length;
            if (this.zSplatSize > 0) {
                this.xSplatSize = splat[0].length;
            }
        }
    }

    @Override
    public Tree createTree(short x, short y, short z, TerrainImage terrain, Random random) {
        return new Tree(x, y, z, (byte)this.shapeHeight, (byte)this.shapeRadius, this);
    }

    @Override
    public boolean markTree(Tree tree, boolean[][] used) {
        int xMin = Math.max(0, tree.x - 1);
        int zMin = Math.max(0, tree.z - 1);
        int xMax = Math.min(1023, tree.x + 1);
        int zMax = Math.min(1023, tree.z + 1);
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                used[x][z] = true;
            }
        }
        return true;
    }

    @Override
    public boolean insertTree(Tree tree, TileColumnCells cells, Random random) {
        int xMin = tree.x - tree.radius;
        int zMin = tree.z - tree.radius;
        int xMax = tree.x - tree.radius;
        int zMax = tree.z - tree.radius;
        if (this.paranoid) {
            Vec3i tileLocal = cells.getColumnData().getColumnId().getTileLocal(null);
            if (xMax < tileLocal.x || zMax < tileLocal.z) {
                throw new RuntimeException("tree lower than column, max:" + xMax + ", " + zMax + "  tileLocal:" + tileLocal);
            }
            if (xMin >= tileLocal.x + 32 || zMin >= tileLocal.z + 32) {
                throw new RuntimeException("tree higher than column, min:" + xMin + ", " + zMin + "  tileLocal + 32:" + tileLocal.add(32, 0, 32));
            }
        }
        short yMin = tree.y;
        int yMax = tree.y + tree.height;
        boolean changed = false;
        for (int y = 0; y < this.shapeHeight; ++y) {
            int yLocal = y + yMin;
            int[][] layer = this.shape[y];
            for (int x = 0; x < this.xSize; ++x) {
                for (int z = 0; z < this.zSize; ++z) {
                    int insert = layer[x][z];
                    if (insert == 0) continue;
                    int xLocal = xMin + x;
                    int zLocal = zMin + z;
                    insert = this.types[insert - 1];
                    cells.setCell(xLocal, yLocal, zLocal, insert | TREE_BITS);
                    changed = true;
                }
            }
        }
        return changed;
    }

    @Override
    public boolean insertTree(Tree tree, TerrainImage terrain) {
        if (this.splat == null) {
            return false;
        }
        int xCorner = tree.x - this.xSplatSize / 2;
        int zCorner = tree.z - this.zSplatSize / 2;
        for (int x = 0; x < this.xSplatSize; ++x) {
            for (int z = 0; z < this.zSplatSize; ++z) {
                byte b;
                int tx = xCorner + x;
                int tz = zCorner + z;
                if (tx < 0 || tz < 0 || tx >= 1024 || tz >= 1024 || (b = this.splat[x][z]) == 0) continue;
                terrain.setType(tx, tz, b);
                terrain.setLight(tx, tz, (byte)-7);
            }
        }
        return false;
    }

    @Override
    public boolean isBlock(Tree tree, int x, int y, int z, int type) {
        if (x < -tree.radius || z < -tree.radius) {
            return false;
        }
        if (x > tree.radius || z > tree.radius) {
            return false;
        }
        if (y < 0 || y >= this.shape.length) {
            return false;
        }
        byte xCorner = -tree.radius;
        byte zCorner = -tree.radius;
        int[][] layer = this.shape[y];
        return layer[x][z] == type;
    }
}

