/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.AaBBox;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.BodyMass;

public abstract class AbstractShape {
    private Vec3d boundsCenter;
    private double boundsRadius;
    private BodyMass mass;
    private AaBBox cogBounds = new AaBBox();

    protected AbstractShape() {
    }

    protected AbstractShape(Vec3d boundsCenter, double boundsRadius, BodyMass mass) {
        if (boundsCenter == null) {
            throw new IllegalArgumentException("boundsCenter cannot be null");
        }
        if (mass == null) {
            throw new IllegalArgumentException("BodyMass cannot be null");
        }
        if (mass.getCog() == null) {
            throw new IllegalArgumentException("BodyMass has no CoG");
        }
        this.boundsCenter = boundsCenter;
        this.boundsRadius = boundsRadius;
        this.mass = mass;
        this.calculateCogBounds();
    }

    private void calculateCogBounds() {
        this.cogBounds.setForRadius(this.boundsCenter.subtract(this.mass.getCog()), this.boundsRadius);
    }

    protected void setBoundsInfo(Vec3d boundsCenter, double boundsRadius, BodyMass mass) {
        if (boundsCenter == null) {
            throw new IllegalArgumentException("boundsCenter cannot be null");
        }
        if (mass == null) {
            throw new IllegalArgumentException("BodyMass cannot be null");
        }
        if (mass.getCog() == null) {
            throw new IllegalArgumentException("BodyMass has no CoG");
        }
        this.boundsCenter = boundsCenter;
        this.boundsRadius = boundsRadius;
        this.mass = mass;
        this.calculateCogBounds();
    }

    public long getVersion() {
        return 0L;
    }

    public final Vec3d getBoundsCenter() {
        return this.boundsCenter;
    }

    public final double getBoundsRadius() {
        return this.boundsRadius;
    }

    public BodyMass getMass() {
        return this.mass;
    }

    public AaBBox getCogBounds() {
        return this.cogBounds;
    }

    public Vec3d getWorldShapeOrigin(AbstractBody body) {
        Vec3d offset = body.orientation.mult(this.boundsCenter);
        offset.multLocal(-1.0).addLocal(body.position);
        return offset;
    }

    public Vec3d getWorldShapeOrigin(Vec3d bodyPos, Quatd bodyOrientation) {
        Vec3d offset = bodyOrientation.mult(this.boundsCenter);
        offset.multLocal(-1.0).addLocal(bodyPos);
        return offset;
    }

    public void setWorldShapeOrigin(AbstractBody body, Vec3d world, Quatd orientation) {
        body.orientation.set(orientation);
        Vec3d offset = body.orientation.mult(this.boundsCenter);
        body.position.set(world).addLocal(offset);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("center", (Object)this.getBoundsCenter()).add("radius", this.getBoundsRadius()).add("bodyMass", (Object)this.getMass()).toString();
    }
}

