/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.AaBBox;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Matrix4d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.AnnealingFunction;
import com.simsilica.mphys.ControlDriver;
import com.simsilica.mphys.DefaultAnnealingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigidBody<K, S extends AbstractShape>
extends AbstractBody<K, S> {
    public static final double DEFAULT_LINEAR_DAMPING = 0.9;
    public static final double DEFAULT_ANGULAR_DAMPING = 0.8;
    static Logger log = LoggerFactory.getLogger(RigidBody.class);
    public long lastUpdateFrame;
    private AaBBox bounds = new AaBBox();
    private Vec3d linAccel = new Vec3d();
    private Vec3d rotAccel = new Vec3d();
    private Vec3d linVelocity = new Vec3d();
    private Vec3d rotVelocity = new Vec3d();
    private Vec3d forces = new Vec3d();
    private Vec3d torques = new Vec3d();
    private Vec3d lastFrameAccel = new Vec3d();
    private Vec3d lastFrameLinVel = new Vec3d();
    private Vec3d lastFrameRotVel = new Vec3d();
    private Matrix4d transform = new Matrix4d();
    private Matrix3d inverseInertiaTensorWorld = new Matrix3d();
    private double linearDamping = 0.9;
    private double angularDamping = 0.8;
    private AnnealingFunction annealing = DefaultAnnealingFunction.GLOBAL_ANNEALING;
    private static final double SLEEP_EPSILON = 0.01;
    private double temperature = 1.0;
    private int contactCount;
    public double inverseMass;
    private ControlDriver<K, S> driver;

    public RigidBody() {
    }

    public RigidBody(K id, S shape) {
        super(id, shape);
        this.inverseMass = ((AbstractShape)shape).getMass().getInverseMass();
    }

    public RigidBody(K id, S shape, Vec3d position, Quatd orientation) {
        super(id, shape, position, orientation);
        this.inverseMass = ((AbstractShape)shape).getMass().getInverseMass();
    }

    public final AaBBox getWorldBounds() {
        return this.bounds;
    }

    public boolean isSleepy() {
        return this.annealing.isCold(this.temperature);
    }

    public static boolean isCold(double temperature) {
        return temperature < 0.01;
    }

    public double getTemperature() {
        if (this.contactCount > 50 && this.temperature > 0.25) {
            return this.temperature * 0.5;
        }
        return this.temperature;
    }

    protected void setTemperature(double t) {
        this.temperature = t;
    }

    public Vec3d getLastFrameAcceleration() {
        return this.lastFrameAccel;
    }

    public final void calculateDerivedData() {
        this.orientation.normalizeLocal();
        this.transform.setTransform(this.position, this.orientation.toRotationMatrix());
        RigidBody.transformInertiaTensor(this.inverseInertiaTensorWorld, this.shape.getMass().getInverseMassTensor(), this.transform);
        AaBBox cb = this.shape.getCogBounds();
        Vec3d min = cb.getMin();
        Vec3d max = cb.getMax();
        this.bounds.getMin().set(this.position.x + min.x, this.position.y + min.y, this.position.z + min.z);
        this.bounds.getMax().set(this.position.x + max.x, this.position.y + max.y, this.position.z + max.z);
    }

    public Matrix3d getInverseInertiaTensorWorld() {
        return this.inverseInertiaTensorWorld;
    }

    public double getInverseMass() {
        return this.inverseMass;
    }

    public final void incrementContactCount() {
        ++this.contactCount;
    }

    public final void decrementContactCount() {
        --this.contactCount;
    }

    public final void clearAccumulators() {
        this.forces.set(0.0, 0.0, 0.0);
        this.torques.set(0.0, 0.0, 0.0);
        this.contactCount = 0;
    }

    public void teleport(Vec3d loc, Quatd orient) {
        if (loc != null) {
            this.position.set(loc);
        }
        if (orient != null) {
            this.orientation.set(orient);
        }
        this.calculateDerivedData();
    }

    public void morph(S shape) {
        this.setShape(shape);
        this.inverseMass = ((AbstractShape)shape).getMass().getInverseMass();
        this.calculateDerivedData();
    }

    public void updateDriver(long frameTime, double tpf) {
        if (this.driver != null) {
            this.driver.update(frameTime, tpf);
        }
    }

    public void setControlDriver(ControlDriver<K, S> driver) {
        if (this.driver != null) {
            this.driver.terminate(this);
        }
        this.driver = driver;
        if (this.driver != null) {
            this.driver.initialize(this);
        }
    }

    public final ControlDriver<K, S> getControlDriver() {
        return this.driver;
    }

    public final void integrate(double t) {
        if (this.inverseMass == 0.0) {
            return;
        }
        boolean debug = false;
        if (debug) {
            log.debug("pos before:" + this.position);
        }
        t *= this.getTemperature();
        this.lastFrameAccel.set(this.linAccel);
        Vec3d tempLinAccel = this.lastFrameAccel;
        tempLinAccel.addScaledVectorLocal(this.forces, this.inverseMass);
        Vec3d tempRotAccel = this.inverseInertiaTensorWorld.mult(this.torques);
        tempRotAccel.addLocal(this.rotAccel);
        boolean check = this.linVelocity.isNaN();
        this.linVelocity.addScaledVectorLocal(tempLinAccel, t);
        this.rotVelocity.addScaledVectorLocal(tempRotAccel, t);
        if (!check && this.linVelocity.isNaN()) {
            System.out.println("Velocity went NaN for body:" + this.id + " accel:" + this.linAccel + " local t:" + t);
        }
        this.linVelocity.multLocal(Math.pow(this.linearDamping, t));
        this.rotVelocity.multLocal(Math.pow(this.angularDamping, t));
        check = this.position.isNaN();
        this.position.addScaledVectorLocal(this.linVelocity, t);
        this.orientation.addScaledVectorLocal(this.rotVelocity, t);
        if (!check && this.position.isNaN()) {
            System.out.println("Position went NaN for body:" + this.id + " velocity:" + this.linVelocity + " local t:" + t);
        }
        this.calculateDerivedData();
        this.temperature = this.annealing.calculateTemperature(this.getTemperature(), this.linVelocity, this.rotVelocity, this.lastFrameAccel, this.lastFrameLinVel, this.lastFrameRotVel, t);
        this.lastFrameLinVel.set(this.linVelocity);
        this.lastFrameRotVel.set(this.rotVelocity);
        this.clearAccumulators();
        if (debug) {
            log.debug("pos after" + this.position);
        }
    }

    public void setDamping(double linear, double angular) {
        this.linearDamping = linear;
        this.angularDamping = angular;
    }

    public void setLinearDamping(double linear) {
        this.linearDamping = linear;
    }

    public double getLinearDamping() {
        return this.linearDamping;
    }

    public void setAngularDamping(double angular) {
        this.angularDamping = angular;
    }

    public double getAngularDamping() {
        return this.angularDamping;
    }

    public void setRotationalAcceleration(double x, double y, double z) {
        this.rotAccel.set(x, y, z);
    }

    public void setLinearAcceleration(Vec3d a) {
        this.linAccel.set(a);
    }

    public void setLinearAcceleration(double x, double y, double z) {
        this.linAccel.set(x, y, z);
    }

    public Vec3d getLinearAcceleration() {
        return this.linAccel;
    }

    public void setLinearVelocity(Vec3d v) {
        this.linVelocity.set(v);
    }

    public void setVelocity(double x, double y, double z) {
        this.linVelocity.set(x, y, z);
    }

    public Vec3d getLinearVelocity() {
        return this.linVelocity;
    }

    public void addLinearVelocity(Vec3d v) {
        if (v.isNaN()) {
            throw new IllegalArgumentException("Cannot add a NaN velocity:" + v + "  body:" + this.id);
        }
        this.linVelocity.addLocal(v);
    }

    public void addLinearVelocity(double x, double y, double z) {
        this.linVelocity.addLocal(x, y, z);
    }

    public void setRotationalVelocity(Vec3d rotation) {
        this.rotVelocity.set(rotation);
    }

    public void setRotationalVelocity(double x, double y, double z) {
        this.rotVelocity.set(x, y, z);
    }

    public Vec3d getRotationalVelocity() {
        return this.rotVelocity;
    }

    public void addRotationalVelocity(Vec3d delta) {
        this.rotVelocity.addLocal(delta);
    }

    public final Vec3d localToWorld(Vec3d point) {
        return this.transform.mult(point);
    }

    public void wakeUp() {
        if (this.isSleepy()) {
            this.temperature = this.annealing.getWakingTemperature();
        }
    }

    public void wakeUp(boolean fully) {
        this.temperature = 1.0;
    }

    public void makeSleepy() {
        this.temperature = 0.0;
    }

    public void addForce(Vec3d f) {
        this.forces.addLocal(f);
        this.wakeUp();
    }

    public void addForceAtBodyPoint(Vec3d f, Vec3d p) {
        Vec3d pt = this.localToWorld(p);
        this.addForceAtPoint(f, pt);
    }

    public void addForceAtPoint(Vec3d f, Vec3d p) {
        this.forces.addLocal(f);
        Vec3d pt = p.subtract(this.position);
        this.torques.addLocal(pt.cross(f));
        this.wakeUp();
    }

    public void addForceAtBodyPoint(Vec3d f, double rotDamping, Vec3d p) {
        Vec3d pt = this.localToWorld(p);
        this.addForceAtPoint(f, rotDamping, pt);
    }

    public void addForceAtPoint(Vec3d f, double rotDamping, Vec3d p) {
        this.forces.addLocal(f);
        Vec3d pt = p.subtract(this.position);
        this.torques.addLocal(pt.cross(f.mult(rotDamping)));
        this.wakeUp();
    }

    public Vec3d getForces() {
        return this.forces;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"RigidBody").add("id", this.id).add("position", (Object)this.position).add("orientation", (Object)this.orientation).add("linearVelocity", (Object)this.linVelocity).add("rotationalVelocity", (Object)this.rotVelocity).add("rawTemperature", this.temperature).add("temperature", this.getTemperature()).add("shape", (Object)this.shape).toString();
    }

    private static void transformInertiaTensor(Matrix3d iitWorld, Matrix3d iitBody, Matrix4d rotmat) {
        double t4 = rotmat.m00 * iitBody.m00 + rotmat.m01 * iitBody.m10 + rotmat.m02 * iitBody.m20;
        double t9 = rotmat.m00 * iitBody.m01 + rotmat.m01 * iitBody.m11 + rotmat.m02 * iitBody.m21;
        double t14 = rotmat.m00 * iitBody.m02 + rotmat.m01 * iitBody.m12 + rotmat.m02 * iitBody.m22;
        double t28 = rotmat.m10 * iitBody.m00 + rotmat.m11 * iitBody.m10 + rotmat.m12 * iitBody.m20;
        double t33 = rotmat.m10 * iitBody.m01 + rotmat.m11 * iitBody.m11 + rotmat.m12 * iitBody.m21;
        double t38 = rotmat.m10 * iitBody.m02 + rotmat.m11 * iitBody.m12 + rotmat.m12 * iitBody.m22;
        double t52 = rotmat.m20 * iitBody.m00 + rotmat.m21 * iitBody.m10 + rotmat.m22 * iitBody.m20;
        double t57 = rotmat.m20 * iitBody.m01 + rotmat.m21 * iitBody.m11 + rotmat.m22 * iitBody.m21;
        double t62 = rotmat.m20 * iitBody.m02 + rotmat.m21 * iitBody.m12 + rotmat.m22 * iitBody.m22;
        iitWorld.m00 = t4 * rotmat.m00 + t9 * rotmat.m01 + t14 * rotmat.m02;
        iitWorld.m01 = t4 * rotmat.m10 + t9 * rotmat.m11 + t14 * rotmat.m12;
        iitWorld.m02 = t4 * rotmat.m20 + t9 * rotmat.m21 + t14 * rotmat.m22;
        iitWorld.m10 = t28 * rotmat.m00 + t33 * rotmat.m01 + t38 * rotmat.m02;
        iitWorld.m11 = t28 * rotmat.m10 + t33 * rotmat.m11 + t38 * rotmat.m12;
        iitWorld.m12 = t28 * rotmat.m20 + t33 * rotmat.m21 + t38 * rotmat.m22;
        iitWorld.m20 = t52 * rotmat.m00 + t57 * rotmat.m01 + t62 * rotmat.m02;
        iitWorld.m21 = t52 * rotmat.m10 + t57 * rotmat.m11 + t62 * rotmat.m12;
        iitWorld.m22 = t52 * rotmat.m20 + t57 * rotmat.m21 + t62 * rotmat.m22;
    }
}

