/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillboardBlockFactory
implements BlockFactory {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(BillboardBlockFactory.class);
    private static final double[][][] COORDS = new double[][][]{new double[][]{{0.5, 0.5}}, new double[][]{{0.25, 0.25}, {0.75, 0.75}}, new double[][]{{0.25, 0.25}, {0.75, 0.25}, {0.5, 0.75}}, new double[][]{{0.25, 0.25}, {0.75, 0.25}, {0.25, 0.75}, {0.75, 0.75}}, new double[][]{{0.25, 0.25}, {0.75, 0.25}, {0.5, 0.5}, {0.25, 0.75}, {0.75, 0.75}}};
    private MaterialType mt1;
    private double width;
    private double height;
    private double maxV;
    private int cellIndex;
    private int count;
    private Vec3d min;
    private Vec3d max;
    private double[][] baseCoords;

    public BillboardBlockFactory(MaterialType mt1, double width, double height, double maxV, int cellIndex, int count) {
        if (count == 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        this.mt1 = mt1;
        this.width = width;
        this.height = height;
        this.maxV = maxV;
        this.cellIndex = cellIndex;
        this.setCount(count);
    }

    public void setCount(int count) {
        log.info("setCount(" + count + ")");
        log.info("COORDS.length:" + COORDS.length + "  cellIndex:" + this.cellIndex);
        this.count = count;
        if (count == 1) {
            double half = this.width * 0.5;
            this.min = new Vec3d(0.5 - half, 0.0, 0.5 - half);
            this.max = new Vec3d(0.5 + half, this.height, 0.5 + half);
            this.baseCoords = COORDS[0];
        } else if (count > 1) {
            double half = 0.49;
            this.min = new Vec3d(0.5 - half, 0.0, 0.5 - half);
            this.max = new Vec3d(0.5 + half, this.height, 0.5 + half);
            this.baseCoords = (double[][])(count - 1 < COORDS.length ? COORDS[count - 1] : null);
        }
    }

    public int getCount() {
        return this.count;
    }

    private double lerp(double s, double min, double max) {
        return (1.0 - s) * min + s * max;
    }

    public int addGeometryToBuffer(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, int sideMask, CellData cells, BlockType type) {
        double yOffset = 0.0;
        if (this.count <= 1) {
            GeomPart part = this.createBillboard(this.mt1, 0.5, yOffset, 0.5, 1.0);
            buffer.addPart(i, j, k, part);
            return 2;
        }
        for (int f = 0; f < this.count; ++f) {
            double zOffset;
            double xOffset;
            double localScale = 1.0;
            if (this.baseCoords == null) {
                double xMin = 0.0;
                double zMin = 0.0;
                double xMax = 1.0;
                double zMax = 1.0;
                if (!DirectionMasks.hasNorth((int)sideMask)) {
                    zMin += localScale * 0.35;
                }
                if (!DirectionMasks.hasSouth((int)sideMask)) {
                    zMax -= localScale * 0.35;
                }
                if (!DirectionMasks.hasEast((int)sideMask)) {
                    xMax -= localScale * 0.35;
                }
                if (!DirectionMasks.hasWest((int)sideMask)) {
                    xMin += localScale * 0.35;
                }
                xOffset = this.lerp(buffer.nextRandom(), xMin, xMax);
                zOffset = this.lerp(buffer.nextRandom(), zMin, zMax);
            } else {
                xOffset = this.baseCoords[f][0];
                zOffset = this.baseCoords[f][1];
            }
            GeomPart part = this.createBillboard(this.mt1, xOffset, yOffset, zOffset, localScale);
            buffer.addPart(i, j, k, part);
        }
        return this.count * 2;
    }

    protected GeomPart createBillboard(MaterialType mt, double x, double y, double z, double size) {
        float halfScale = (float)(size * 0.5);
        GeomPart part = new GeomPart(mt, -1, true);
        float xHalf = (float)(this.width * 0.5);
        double xTest = 0.0;
        double yTest = 0.0;
        float v1 = 0.0f;
        float v2 = (float)((double)v1 + this.maxV);
        part.setCoords(new float[]{(float)(x - xTest), (float)y, (float)z, (float)(x + xTest), (float)y, (float)z, (float)(x + xTest), (float)(y + this.height), (float)z, (float)(x - xTest), (float)(y + this.height), (float)z});
        part.setTexCoords(new float[]{-xHalf, v1, xHalf, v1, xHalf, v2, -xHalf, v2});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        part.setSizes(new float[]{this.cellIndex, this.cellIndex, this.cellIndex, this.cellIndex});
        return part;
    }

    public BoundaryShape getShape(Direction dir) {
        return BoundaryShapes.NULL_SHAPE;
    }

    public boolean isSolid(Direction dir) {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public double getTransparency(Direction dir) {
        return 1.0;
    }

    public boolean isTransparent() {
        return true;
    }

    public double getVolume() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }

    public Vec3d getMin() {
        return this.min;
    }

    public Vec3d getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BillboardBlockFactory other = (BillboardBlockFactory)o;
        if (!Objects.equals(other.mt1, this.mt1)) {
            return false;
        }
        if (other.count != this.count) {
            return false;
        }
        if (other.width != this.width) {
            return false;
        }
        if (other.height != this.height) {
            return false;
        }
        return other.maxV == this.maxV;
    }

    public int hashCode() {
        return Objects.hash(this.mt1, this.count, this.width, this.height, this.maxV);
    }

    public BlockFactory rotate(int dirDelta) {
        return this;
    }
}

