/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.net.ComponentChangeMessage;
import com.simsilica.es.net.EntityDataMessage;
import com.simsilica.es.net.EntityIdsMessage;
import com.simsilica.es.net.FindEntitiesMessage;
import com.simsilica.es.net.FindEntityMessage;
import com.simsilica.es.net.GetComponentsMessage;
import com.simsilica.es.net.GetEntitySetMessage;
import com.simsilica.es.net.ReleaseEntitySetMessage;
import com.simsilica.es.net.ReleaseWatchedEntityMessage;
import com.simsilica.es.net.ResetEntitySetFilterMessage;
import com.simsilica.es.net.ResultComponentsMessage;
import com.simsilica.es.net.StringIdMessage;
import com.simsilica.es.net.WatchEntityMessage;
import com.simsilica.es.server.ComponentUsageTracker;
import com.simsilica.es.server.ComponentVisibility;
import com.simsilica.es.server.EntityDataWrapper;
import com.simsilica.es.server.EntityHostSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostedEntityData {
    public static final String ATTRIBUTE_NAME = "hostedEntityData";
    static Logger log = LoggerFactory.getLogger(HostedEntityData.class);
    private final EntityHostSettings settings;
    private final HostedConnection conn;
    private final EntityDataWrapper ed;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final Map<Integer, EntitySet> activeSets = new ConcurrentHashMap<Integer, EntitySet>();
    private final Map<Integer, EntityInfo> activeEntities = new ConcurrentHashMap<Integer, EntityInfo>();
    private final Lock updateLock = new ReentrantLock();
    private final ComponentUsageTracker tracker = new ComponentUsageTracker();
    private long sendFrameCounter = 0L;
    private final List<EntityChange> frameChanges = new ArrayList<EntityChange>();
    private final AtomicBoolean filtersReset = new AtomicBoolean();
    private final List<EntityDataMessage.ComponentData> entityBuffer = new ArrayList<EntityDataMessage.ComponentData>();
    private final List<EntityChange> changeList = new ArrayList<EntityChange>();

    public HostedEntityData(EntityHostSettings settings, HostedConnection conn, ObservableEntityData ed) {
        this.settings = settings;
        this.ed = new EntityDataWrapper(ed);
        this.conn = conn;
        log.trace("Created HostedEntityData:" + this);
    }

    public void registerComponentVisibility(ComponentVisibility visibility) {
        this.ed.registerComponentVisibility(visibility);
    }

    public void close() {
        if (!this.closing.compareAndSet(false, true)) {
            return;
        }
        log.trace("Closing HostedEntityData:" + this);
        for (EntitySet set : this.activeSets.values()) {
            log.trace("Releasing: EntitySet@" + System.identityHashCode(set));
            set.release();
        }
        this.activeSets.clear();
        this.activeEntities.clear();
        this.ed.close();
    }

    public void getComponents(HostedConnection source, GetComponentsMessage msg) {
        if (log.isTraceEnabled()) {
            log.trace("getComponents:" + (Object)((Object)msg));
        }
        Entity e = this.ed.getEntity(msg.getEntityId(), msg.getComponentTypes());
        if (log.isTraceEnabled()) {
            log.trace("Sending back entity data:" + e);
        }
        source.send(this.settings.getChannel(), (Message)new ResultComponentsMessage(msg.getRequestId(), e));
    }

    public void findEntities(HostedConnection source, FindEntitiesMessage msg) {
        if (log.isTraceEnabled()) {
            log.trace("findEntities:" + (Object)((Object)msg));
        }
        Set<EntityId> result = this.ed.findEntities(msg.getFilter(), msg.getComponentTypes());
        if (log.isTraceEnabled()) {
            log.trace("Sending back entity ID data:" + result);
        }
        source.send(this.settings.getChannel(), (Message)new EntityIdsMessage(msg.getRequestId(), result));
    }

    public void findEntity(HostedConnection source, FindEntityMessage msg) {
        if (log.isTraceEnabled()) {
            log.trace("findEntity:" + (Object)((Object)msg));
        }
        EntityId result = this.ed.findEntity(msg.getFilter(), msg.getComponentTypes());
        if (log.isTraceEnabled()) {
            log.trace("Sending back entity ID data:" + result);
        }
        source.send(this.settings.getChannel(), (Message)new EntityIdsMessage(msg.getRequestId(), result));
    }

    public void watchEntity(HostedConnection source, WatchEntityMessage msg) {
        int watchId;
        EntityInfo existing;
        if (log.isTraceEnabled()) {
            log.trace("watchEntity:" + (Object)((Object)msg));
        }
        if ((existing = this.activeEntities.get(watchId = msg.getWatchId())) != null) {
            throw new RuntimeException("WatchedEntity already exists for watch ID:" + watchId);
        }
        Entity result = this.ed.getEntity(msg.getEntityId(), msg.getComponentTypes());
        this.activeEntities.put(watchId, new EntityInfo(msg.getEntityId(), msg.getComponentTypes()));
        if (log.isTraceEnabled()) {
            log.trace("Sending back entity data:" + result);
        }
        source.send(this.settings.getChannel(), (Message)new ResultComponentsMessage(msg.getRequestId(), result));
    }

    public void releaseEntity(HostedConnection source, ReleaseWatchedEntityMessage msg) {
        if (log.isTraceEnabled()) {
            log.trace("releaseEntity:" + (Object)((Object)msg));
        }
        int watchId = msg.getWatchId();
        this.activeEntities.remove(watchId);
    }

    public void getEntitySet(HostedConnection source, GetEntitySetMessage msg) {
        int setId;
        EntitySet set;
        if (log.isTraceEnabled()) {
            log.trace("getEntitySet:" + (Object)((Object)msg));
        }
        if ((set = this.activeSets.get(setId = msg.getSetId())) != null) {
            throw new RuntimeException("Set already exists for ID:" + setId);
        }
        if (log.isTraceEnabled()) {
            log.trace("Creating set for ID:" + msg.getSetId());
        }
        set = this.ed.getEntities(msg.getFilter(), msg.getComponentTypes());
        int batchMax = this.settings.getMaxEntityBatchSize();
        ArrayList<EntityDataMessage.ComponentData> data = new ArrayList<EntityDataMessage.ComponentData>();
        for (Entity e : set) {
            data.add(new EntityDataMessage.ComponentData(e));
            if (data.size() <= batchMax) continue;
            this.sendAndClear(setId, data);
        }
        if (!data.isEmpty()) {
            this.sendAndClear(setId, data);
        }
        this.activeSets.put(setId, set);
        this.filtersReset.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEntitySetFilter(HostedConnection source, ResetEntitySetFilterMessage msg) {
        if (log.isTraceEnabled()) {
            log.trace("resetEntitySetFilter:" + (Object)((Object)msg));
        }
        this.updateLock.lock();
        try {
            EntitySet set = this.activeSets.get(msg.getSetId());
            set.resetFilter(msg.getFilter());
            this.filtersReset.set(true);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public void releaseEntitySet(HostedConnection source, ReleaseEntitySetMessage msg) {
        EntitySet set;
        if (log.isTraceEnabled()) {
            log.trace("releaseEntitySet:" + (Object)((Object)msg));
        }
        if ((set = this.activeSets.remove(msg.getSetId())) == null) {
            log.warn("null set in releaseEntitySet(" + (Object)((Object)msg) + ")");
            return;
        }
        set.release();
    }

    public void getStringInfo(HostedConnection source, StringIdMessage msg) {
        if (msg.getId() != null) {
            source.send((Message)new StringIdMessage(msg.getRequestId(), this.ed.getStrings().getString(msg.getId().intValue())));
        } else if (msg.getString() != null) {
            source.send((Message)new StringIdMessage(msg.getRequestId(), this.ed.getStrings().getStringId(msg.getString(), false)));
        } else {
            throw new RuntimeException("Bad StringIdMessage:" + (Object)((Object)msg));
        }
    }

    protected void sendAndClear(int setId, List<EntityDataMessage.ComponentData> buffer) {
        this.conn.send(this.settings.getChannel(), (Message)new EntityDataMessage(setId, buffer));
        buffer.clear();
    }

    protected void sendAndClear(List<EntityChange> buffer) {
        this.conn.send(this.settings.getChannel(), (Message)new ComponentChangeMessage(buffer));
        buffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdates() {
        if (this.closing.get()) {
            return;
        }
        int entityMax = this.settings.getMaxEntityBatchSize();
        Long frame = this.sendFrameCounter++;
        this.frameChanges.clear();
        this.entityBuffer.clear();
        boolean newFilters = this.filtersReset.getAndSet(false);
        if (!this.ed.applyChanges(this.frameChanges) && !newFilters) {
            return;
        }
        this.updateLock.lock();
        try {
            log.trace("Updating entity sets");
            for (Map.Entry<Integer, EntitySet> entry : this.activeSets.entrySet()) {
                Class<EntityComponent>[] types;
                Class<EntityComponent>[] set = entry.getValue();
                if (log.isTraceEnabled()) {
                    log.trace("Updating set for types:" + Arrays.asList(this.ed.getTypes((EntitySet)set)));
                }
                if (set.applyChanges()) {
                    if (log.isTraceEnabled()) {
                        for (Entity entity : set.getRemovedEntities()) {
                            log.trace("should be removed:" + entity.getId());
                        }
                        for (Entity entity : set.getChangedEntities()) {
                            log.trace("should be updated:" + entity.getId());
                        }
                        for (Entity entity : set.getAddedEntities()) {
                            log.trace("should be added:" + entity.getId());
                        }
                    }
                    for (Entity entity : set.getAddedEntities()) {
                        if (log.isTraceEnabled()) {
                            log.trace("Sending new entity:" + entity.getId() + " to set:" + entry.getKey());
                        }
                        this.entityBuffer.add(new EntityDataMessage.ComponentData(entity));
                        if (this.entityBuffer.size() <= entityMax) continue;
                        this.sendAndClear(entry.getKey(), this.entityBuffer);
                    }
                    if (!this.entityBuffer.isEmpty()) {
                        this.sendAndClear(entry.getKey(), this.entityBuffer);
                    }
                }
                set.clearChangeSets();
                if (set.isEmpty()) continue;
                for (Class<EntityComponent> type : types = this.ed.getTypes((EntitySet)set)) {
                    this.tracker.set(set.getEntityIds(), type, frame);
                }
            }
        }
        finally {
            log.trace("Done updating entity sets");
            this.updateLock.unlock();
        }
        for (EntityInfo entityInfo : this.activeEntities.values()) {
            for (Class<EntityComponent> type : entityInfo.types) {
                this.tracker.set(entityInfo.id, type, frame);
            }
        }
        int changeMax = this.settings.getMaxChangeBatchSize();
        for (EntityChange change : this.frameChanges) {
            Long last = this.tracker.getAndExpire(change.getEntityId(), change.getComponentType(), frame);
            if (last == null) continue;
            this.changeList.add(change);
            if (this.changeList.size() <= changeMax) continue;
            this.sendAndClear(this.changeList);
        }
        if (!this.changeList.isEmpty()) {
            this.sendAndClear(this.changeList);
        }
    }

    private static class EntityInfo {
        EntityId id;
        Class<EntityComponent>[] types;

        public EntityInfo(EntityId id, Class<EntityComponent>[] types) {
            this.id = id;
            this.types = types;
        }
    }
}

