/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.bits.QuatBits;
import com.simsilica.mathd.bits.Vec3Bits;
import java.net.URL;
import java.nio.charset.Charset;
import mythruna.world.WorldDbVersions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameConstants {
    static Logger log = LoggerFactory.getLogger(GameConstants.class);
    public static final String VENDOR_ID = "Simsilica, LLC";
    public static final String NAME = "Mythruna";
    public static final int PROTOCOL_VERSION = 20230907;
    public static final int DEFAULT_PORT = 4234;
    public static final WorldDbVersions WORLD_DB_VERSIONS = new WorldDbVersions(1, 1, 1);
    public static float DEFAULT_FOV = 70.0f;
    public static final int CH_CHAT = 0;
    public static final int CH_ENTITIES = 1;
    public static final int CH_TERRAIN = 2;
    public static final int GRID_CELL_SIZE = 32;
    public static final int SEA_LEVEL = 128;
    public static final int MAX_LAND_HEIGHT = 512;
    public static final int MAX_MAP_HEIGHT = 640;
    public static final int MAX_BUILD_HEIGHT = 672;
    public static final Grid LEAF_GRID = new Grid(32);
    public static final Grid PHYSICS_GRID = new Grid(32, 1024, 32);
    public static final Grid LARGE_OBJECT_GRID = new Grid(1024, 1024, 1024);
    public static final Vec3d DEFAULT_GRAVITY = new Vec3d(0.0, -20.0, 0.0);
    public static final Vec3d WATER_GRAVITY = new Vec3d(0.0, -1.0, 0.0);
    private static int zoneGridSize = 32;
    public static final ZoneGrid ZONE_GRID = new ZoneGrid(zoneGridSize, zoneGridSize, zoneGridSize);
    public static final float MAX_OBJECT_RADIUS = 32.0f;
    public static final int POSITION_BIT_COUNT = 18;
    public static final Vec3Bits POSITION_BITS = new Vec3Bits(-32.0f, (float)zoneGridSize + 32.0f, 18);
    public static final QuatBits ROTATION_BITS = new QuatBits(12);
    public static final ObjectStateProtocol OBJECT_PROTOCOL = new ObjectStateProtocol(8, 64, POSITION_BITS, ROTATION_BITS);
    public static final Vec3i ZONE_RADIUS = new Vec3i(1, 3, 1);
    private static String version;

    public static String buildVersion() {
        if (version != null) {
            return version;
        }
        URL u = Resources.getResource((String)"/mythruna.build.date");
        if (u == null) {
            log.warn("No mythruna.build.date resource found.");
            version = "Unknown";
            return version;
        }
        try {
            version = Resources.toString((URL)u, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            log.error("Error reading mythruna.build.date", (Throwable)e);
            version = "Unknown";
        }
        return version;
    }
}

