/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ImageRaster;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricTexture
implements Serializable {
    static Logger log = LoggerFactory.getLogger(FabricTexture.class);
    private static final long serialVersionUID = 42L;
    private String textureName;
    private ColorRGBA color;
    private transient Texture texture;
    private transient ImageRaster raster;
    private transient int imageWidth;
    private transient int imageHeight;

    public FabricTexture(String textureName) {
        this(textureName, null);
    }

    public FabricTexture(ColorRGBA color) {
        this(null, color);
    }

    public FabricTexture(String textureName, ColorRGBA color) {
        this.textureName = textureName;
        this.color = color;
    }

    public void initialize(AssetManager assetManager) {
        if (this.textureName != null) {
            this.texture = assetManager.loadTexture(new TextureKey(this.textureName, false));
            this.raster = ImageRaster.create((Image)this.texture.getImage());
            this.imageWidth = this.raster.getWidth();
            this.imageHeight = this.raster.getHeight();
        }
    }

    public ColorRGBA getPixel(int x, int y) {
        return this.getPixel(x, y, new ColorRGBA());
    }

    public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
        if (this.raster == null) {
            return store.set(this.color);
        }
        x %= this.imageWidth;
        y %= this.imageHeight;
        try {
            this.raster.getPixel(x, y, store);
        }
        catch (IllegalArgumentException e) {
            log.info("error getting pixel from:" + this.texture + " for:" + x + ", " + y, (Throwable)e);
        }
        if (this.color != null) {
            store.r *= this.color.r;
            store.g *= this.color.g;
            store.b *= this.color.b;
            store.a *= this.color.a;
        }
        return store;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[texture:" + this.textureName + ", color:" + this.color + "]";
    }
}

