/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.jme3.asset.AssetManager;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ImageRaster;
import com.simsilica.mblock.Direction;
import java.util.ArrayList;
import java.util.List;
import mythruna.fabric.SwatchShape;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.SwatchShapeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeConfig {
    static Logger log = LoggerFactory.getLogger(ShapeConfig.class);
    private static List<SwatchShape> shapes = new ArrayList<SwatchShape>();

    public static SwatchShapeData initialize() {
        shapes.add(null);
        ShapeConfig.addShape("square", "full", Direction.North, Direction.South, Direction.East, Direction.West);
        ShapeConfig.addShape("edge", "top", Direction.North, Direction.East, Direction.West);
        ShapeConfig.addShape("edge", "left", Direction.North, Direction.South, Direction.West);
        ShapeConfig.addShape("edge", "bottom", Direction.South, Direction.East, Direction.West);
        ShapeConfig.addShape("edge", "right", Direction.North, Direction.East, Direction.South);
        ShapeConfig.addShape("bar", "top-bottom", Direction.North, Direction.South);
        ShapeConfig.addShape("bar", "right-left", Direction.East, Direction.West);
        ShapeConfig.addShape("square", "half-centered", new Direction[0]);
        ShapeConfig.addShape("frayed-edge", "top", Direction.North, Direction.East, Direction.West);
        ShapeConfig.addShape("frayed-edge", "left", Direction.North, Direction.South, Direction.West);
        ShapeConfig.addShape("frayed-edge", "bottom", Direction.South, Direction.East, Direction.West);
        ShapeConfig.addShape("frayed-edge", "right", Direction.North, Direction.East, Direction.South);
        ShapeConfig.addShape("angle", "top-left", Direction.North, Direction.West);
        ShapeConfig.addShape("angle", "top-right", Direction.North, Direction.East);
        ShapeConfig.addShape("angle", "bottom-left", Direction.South, Direction.West);
        ShapeConfig.addShape("angle", "bottom-right", Direction.South, Direction.East);
        ShapeConfig.addShape("angle", "top", Direction.North);
        ShapeConfig.addShape("angle", "left", Direction.West);
        ShapeConfig.addShape("angle", "bottom", Direction.South);
        ShapeConfig.addShape("angle", "right", Direction.East);
        ShapeConfig.addShape("small-angle", "top-left", Direction.North, Direction.West);
        ShapeConfig.addShape("small-angle", "top-right", Direction.North, Direction.East);
        ShapeConfig.addShape("small-angle", "bottom-left", Direction.South, Direction.West);
        ShapeConfig.addShape("small-angle", "bottom-right", Direction.South, Direction.East);
        ShapeConfig.addShape("button", "top", new Direction[0]);
        ShapeConfig.addShape("button", "left", new Direction[0]);
        ShapeConfig.addShape("button", "bottom", new Direction[0]);
        ShapeConfig.addShape("button", "right", new Direction[0]);
        ShapeConfig.addShape("button", "center", new Direction[0]);
        ShapeConfig.addShape("buckle", "center", Direction.North, Direction.South, Direction.East, Direction.West);
        ShapeConfig.addShape("buckle", "top", Direction.North, Direction.East, Direction.West);
        ShapeConfig.addShape("buckle", "left", Direction.West, Direction.North, Direction.South);
        ShapeConfig.addShape("buckle", "bottom", Direction.South, Direction.East, Direction.West);
        ShapeConfig.addShape("buckle", "right", Direction.East, Direction.North, Direction.South);
        ShapeConfig.addShape("horizontal-laces", "center", new Direction[0]);
        ShapeConfig.addShape("horizontal-laces", "right", Direction.East);
        ShapeConfig.addShape("horizontal-laces", "right-left", Direction.East, Direction.West);
        ShapeConfig.addShape("horizontal-laces", "left", Direction.West);
        ShapeConfig.addShape("vertical-laces", "top", Direction.North);
        ShapeConfig.addShape("vertical-laces", "bottom", Direction.South);
        ShapeConfig.addShape("diagonal-laces", "fall-center", new Direction[0]);
        ShapeConfig.addShape("diagonal-laces", "fall-right", Direction.East);
        ShapeConfig.addShape("diagonal-laces", "fall-left", Direction.West);
        ShapeConfig.addShape("diagonal-laces", "fall-bottom", Direction.South);
        ShapeConfig.addShape("diagonal-laces", "fall-top", Direction.North);
        ShapeConfig.addShape("diagonal-laces", "rise-center", new Direction[0]);
        ShapeConfig.addShape("diagonal-laces", "rise-right", Direction.East);
        ShapeConfig.addShape("diagonal-laces", "rise-left", Direction.West);
        ShapeConfig.addShape("diagonal-laces", "rise-bottom", Direction.South);
        ShapeConfig.addShape("diagonal-laces", "rise-top", Direction.North);
        SwatchShape[] array = shapes.toArray(new SwatchShape[0]);
        return new SwatchShapeData(array, 1);
    }

    public static void loadAssets(AssetManager assets) {
        Texture texture = assets.loadTexture("fabric/shapes.png");
        ImageRaster shapes = ImageRaster.create((Image)texture.getImage());
        ShapeConfig.setAtlasCell("square", "full", shapes, 0, 7);
        ShapeConfig.setAtlasCell("edge", "top", shapes, 1, 7);
        ShapeConfig.setAtlasCell("edge", "left", shapes, 2, 7);
        ShapeConfig.setAtlasCell("edge", "bottom", shapes, 3, 7);
        ShapeConfig.setAtlasCell("edge", "right", shapes, 4, 7);
        ShapeConfig.setAtlasCell("bar", "top-bottom", shapes, 5, 7);
        ShapeConfig.setAtlasCell("bar", "right-left", shapes, 6, 7);
        ShapeConfig.setAtlasCell("square", "half-centered", shapes, 7, 7);
        ShapeConfig.setAtlasCell("frayed-edge", "top", shapes, 2, 2);
        ShapeConfig.setAtlasCell("frayed-edge", "left", shapes, 3, 2);
        ShapeConfig.setAtlasCell("frayed-edge", "bottom", shapes, 4, 2);
        ShapeConfig.setAtlasCell("frayed-edge", "right", shapes, 5, 2);
        ShapeConfig.setAtlasCell("angle", "top-left", shapes, 0, 6);
        ShapeConfig.setAtlasCell("angle", "top-right", shapes, 1, 6);
        ShapeConfig.setAtlasCell("angle", "bottom-left", shapes, 0, 5);
        ShapeConfig.setAtlasCell("angle", "bottom-right", shapes, 1, 5);
        ShapeConfig.setAtlasCell("angle", "top", shapes, 2, 6);
        ShapeConfig.setAtlasCell("angle", "left", shapes, 3, 6);
        ShapeConfig.setAtlasCell("angle", "bottom", shapes, 4, 6);
        ShapeConfig.setAtlasCell("angle", "right", shapes, 5, 6);
        ShapeConfig.setAtlasCell("small-angle", "top-left", shapes, 0, 2);
        ShapeConfig.setAtlasCell("small-angle", "top-right", shapes, 1, 2);
        ShapeConfig.setAtlasCell("small-angle", "bottom-left", shapes, 0, 1);
        ShapeConfig.setAtlasCell("small-angle", "bottom-right", shapes, 1, 1);
        ShapeConfig.setAtlasCell("button", "top", shapes, 2, 5);
        ShapeConfig.setAtlasCell("button", "left", shapes, 3, 5);
        ShapeConfig.setAtlasCell("button", "bottom", shapes, 4, 5);
        ShapeConfig.setAtlasCell("button", "right", shapes, 5, 5);
        ShapeConfig.setAtlasCell("button", "center", shapes, 6, 5);
        ShapeConfig.setAtlasCell("buckle", "center", shapes, 0, 4);
        ShapeConfig.setAtlasCell("buckle", "top", shapes, 1, 4);
        ShapeConfig.setAtlasCell("buckle", "left", shapes, 2, 4);
        ShapeConfig.setAtlasCell("buckle", "bottom", shapes, 3, 4);
        ShapeConfig.setAtlasCell("buckle", "right", shapes, 4, 4);
        ShapeConfig.setAtlasCell("horizontal-laces", "center", shapes, 7, 5);
        ShapeConfig.setAtlasCell("horizontal-laces", "right", shapes, 5, 4);
        ShapeConfig.setAtlasCell("horizontal-laces", "right-left", shapes, 6, 4);
        ShapeConfig.setAtlasCell("horizontal-laces", "left", shapes, 7, 4);
        ShapeConfig.setAtlasCell("vertical-laces", "top", shapes, 6, 6);
        ShapeConfig.setAtlasCell("vertical-laces", "bottom", shapes, 7, 6);
        ShapeConfig.setAtlasCell("diagonal-laces", "fall-center", shapes, 0, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "fall-right", shapes, 2, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "fall-left", shapes, 3, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "fall-bottom", shapes, 6, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "fall-top", shapes, 6, 2);
        ShapeConfig.setAtlasCell("diagonal-laces", "rise-center", shapes, 1, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "rise-right", shapes, 4, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "rise-left", shapes, 5, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "rise-bottom", shapes, 7, 3);
        ShapeConfig.setAtlasCell("diagonal-laces", "rise-top", shapes, 7, 2);
    }

    private static void addShape(String type, String variation, Direction ... dirs) {
        boolean debug = "angle".equals(type);
        int dirMask = SwatchShape.dirsToMask(dirs);
        if (debug) {
            log.info("addShape(" + type + ", " + variation + ") dirMask:" + Integer.toBinaryString(dirMask));
        }
        for (int i = 0; i < 16; ++i) {
            if ((i & dirMask) != i) continue;
            if (debug) {
                log.info("   edgeMask variant:" + Integer.toBinaryString(i));
            }
            shapes.add(new SwatchShape(type, variation, i));
        }
    }

    private static void setAtlasCell(String type, String variation, ImageRaster atlas, int xCell, int yCell) {
        int index = SwatchShapeIndex.findBaseShape(type, variation, -1);
        if (index < 0) {
            throw new IllegalArgumentException("Unknown shape type:" + type + ", " + variation);
        }
        int xBase = xCell * 32;
        int yBase = yCell * 32;
        for (SwatchShape shape : SwatchShapeIndex.getEdgeMasks(type, variation)) {
            Vector4f[][] normals = ShapeConfig.calculatePackedNormals(atlas, xBase, yBase, shape.getEdgeMask());
            byte[] data = ShapeConfig.toBytes(normals);
            shape.updateData(data);
        }
    }

    private static byte[] toBytes(Vector4f[][] normals) {
        byte[] data = new byte[4096];
        int bPos = 0;
        for (int j = 0; j < 32; ++j) {
            for (int i = 0; i < 32; ++i) {
                Vector4f normal = normals[i][31 - j];
                float x = 0.5f + normal.x * 0.5f;
                float y = 0.5f + normal.y * 0.5f;
                float z = 0.5f + normal.z * 0.5f;
                data[bPos++] = (byte)(x * 255.0f);
                data[bPos++] = (byte)(y * 255.0f);
                data[bPos++] = (byte)(z * 255.0f);
                data[bPos++] = (byte)(normal.w * 255.0f);
            }
        }
        return data;
    }

    protected static Vector4f[][] calculatePackedNormals(ImageRaster raster, int xBase, int yBase, int dirMask) {
        Vector3f[][] normals = new Vector3f[32][32];
        int[][] counts = new int[raster.getWidth()][raster.getHeight()];
        float intensity = 2.0f;
        for (int j = 0; j < 32; ++j) {
            Vector3f normal;
            float delta;
            float alpha;
            int i;
            int y = j;
            float last = (dirMask & 8) != 0 ? 0.0f : raster.getPixel((int)(xBase + 0), (int)(yBase + y)).a;
            Vector3f lastNormal = null;
            for (i = 0; i < 32; ++i) {
                alpha = raster.getPixel((int)(xBase + i), (int)(yBase + y)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(-delta * intensity, 0.0f, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i][j] == null) {
                        normals[i][j] = normal.clone();
                    } else {
                        normals[i][j].addLocal(normal);
                    }
                    int[] nArray = counts[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
            last = (dirMask & 4) != 0 ? 0.0f : raster.getPixel((int)(xBase + 31), (int)(yBase + y)).a;
            lastNormal = null;
            for (i = 31; i >= 0; --i) {
                alpha = raster.getPixel((int)(xBase + i), (int)(yBase + y)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(delta * intensity, 0.0f, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i][j] == null) {
                        normals[i][j] = normal.clone();
                    } else {
                        normals[i][j].addLocal(normal);
                    }
                    int[] nArray = counts[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
        }
        for (int i = 0; i < 32; ++i) {
            Vector3f normal;
            float delta;
            int j;
            float last = (dirMask & 2) != 0 ? 0.0f : raster.getPixel((int)(xBase + i), (int)(yBase + 0)).a;
            Vector3f lastNormal = null;
            for (j = 0; j < 32; ++j) {
                float alpha = raster.getPixel((int)(xBase + i), (int)(yBase + j)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(0.0f, -delta * intensity, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i][j] == null) {
                        normals[i][j] = normal.clone();
                    } else {
                        normals[i][j].addLocal(normal);
                    }
                    int[] nArray = counts[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
            last = (dirMask & 1) != 0 ? 0.0f : raster.getPixel((int)(xBase + i), (int)(yBase + 31)).a;
            lastNormal = null;
            for (j = 31; j >= 0; --j) {
                float alpha = raster.getPixel((int)(xBase + i), (int)(yBase + j)).a;
                if (alpha > 0.0f) {
                    delta = alpha - last;
                    if ((double)Math.abs(delta) < 0.001 && lastNormal != null) {
                        normal = lastNormal;
                        lastNormal = null;
                    } else {
                        lastNormal = normal = new Vector3f(0.0f, delta * intensity, 1.0f - Math.abs(delta)).normalizeLocal();
                    }
                    if (normals[i][j] == null) {
                        normals[i][j] = normal.clone();
                    } else {
                        normals[i][j].addLocal(normal);
                    }
                    int[] nArray = counts[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
                last = alpha;
            }
        }
        Vector4f[][] result = new Vector4f[32][32];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                Vector3f normal = normals[i][j];
                if (normal == null) {
                    normal = new Vector3f(0.0f, 0.0f, 1.0f);
                } else {
                    normal.divideLocal((float)counts[i][j]);
                }
                float alpha = raster.getPixel((int)(xBase + i), (int)(yBase + j)).a;
                result[i][j] = new Vector4f(normal.x, normal.y, normal.z, alpha);
            }
        }
        return result;
    }
}

