/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.google.common.base.MoreObjects;
import com.jme3.math.ColorRGBA;
import com.simsilica.mblock.Direction;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchShape
implements Serializable {
    static Logger log = LoggerFactory.getLogger(SwatchShape.class);
    private static final long serialVersionUID = 42L;
    private String type;
    private String variation;
    private int edgeMask;
    private byte[] data;

    private SwatchShape() {
    }

    public SwatchShape(String type, String variation, int edgeMask) {
        this.type = type;
        this.variation = variation;
        this.edgeMask = edgeMask;
    }

    public String getType() {
        return this.type;
    }

    public String getVariation() {
        return this.variation;
    }

    public int getEdgeMask() {
        return this.edgeMask;
    }

    public String getFullName() {
        return this.type + "-" + this.variation + "-" + Integer.toHexString(this.edgeMask);
    }

    public void updateData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public static int dirsToMask(Direction ... dirs) {
        int result = 0;
        for (Direction d : dirs) {
            result |= d.getBitMask();
        }
        return result;
    }

    public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
        int index = (y * 32 + x) * 4;
        store.r = (float)(this.data[index++] & 0xFF) / 255.0f;
        store.g = (float)(this.data[index++] & 0xFF) / 255.0f;
        store.b = (float)(this.data[index++] & 0xFF) / 255.0f;
        store.a = (float)(this.data[index++] & 0xFF) / 255.0f;
        return store;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("type", (Object)this.type).add("variation", (Object)this.variation).add("edgeMask", (Object)("0b" + Integer.toBinaryString(this.edgeMask))).toString();
    }
}

