/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.CellArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.FabricUtils;
import mythruna.fabric.SwatchShape;
import mythruna.fabric.SwatchShapeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingFileFormat {
    static Logger log = LoggerFactory.getLogger(ClothingFileFormat.class);
    private static Pattern TRIPLE = Pattern.compile("%\\w+:\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
    private static Pattern VALUE = Pattern.compile("%\\w+:\\s*(\\w+)\\s*=\\s*(.+)");
    private static Pattern NUM_PAIR = Pattern.compile("(\\d+):(\\d+)");
    private FabricType[] fabricTypes;
    private SwatchShape[] swatchShapes;

    public ClothingFileFormat(FabricType[] fabricTypes, SwatchShape[] swatchShapes) {
        this.fabricTypes = fabricTypes;
        this.swatchShapes = swatchShapes;
    }

    public CellArray readCells(String resource) throws IOException {
        InputStream in = ClothingFileFormat.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("Resource not found:" + resource);
        }
        return this.readCells(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellArray readCells(InputStream rawIn) throws IOException {
        InputStreamReader rIn = new InputStreamReader(rawIn, Charsets.UTF_8);
        try (BufferedReader in = new BufferedReader(rIn);){
            String line = null;
            CellArray cells = null;
            CellArray target = null;
            HashMap<Integer, String> fabricIndex = new HashMap<Integer, String>();
            HashMap<Integer, Integer> fabricRemap = new HashMap<Integer, Integer>();
            HashMap<Integer, String> shapeIndex = new HashMap<Integer, String>();
            HashMap<Integer, Integer> shapeRemap = new HashMap<Integer, Integer>();
            int sizeX = 0;
            int sizeY = 0;
            int sizeZ = 0;
            int minX = 0;
            int minY = 0;
            int minZ = 0;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            int y = 0;
            int z = 0;
            while ((line = in.readLine()) != null) {
                int[] sizes;
                int index;
                String[] words;
                if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                if (line.startsWith("%Clothing version")) {
                    if (line.equals("%Clothing version 1")) continue;
                    throw new IOException("Unsupported version:" + line);
                }
                if (line.startsWith("%order")) {
                    if (line.equals("%order: z, y, x")) continue;
                    throw new IOException("Unsupported order:" + line);
                }
                if (line.startsWith("%compression")) {
                    if (line.equals("%compression: none")) continue;
                    throw new IOException("Unsupported compression:" + line);
                }
                if (line.startsWith("%fabric:")) {
                    words = ClothingFileFormat.parseValue(line);
                    int fabric = Integer.parseInt(words[0]);
                    fabricIndex.put(fabric, words[1]);
                    index = FabricTypeIndex.findType(words[1]);
                    log.debug("fabric index:" + index);
                    if (fabric == index) continue;
                    fabricRemap.put(fabric, index);
                    continue;
                }
                if (line.startsWith("%swatch:")) {
                    words = ClothingFileFormat.parseValue(line);
                    int shape = Integer.parseInt(words[0]);
                    shapeIndex.put(shape, words[1]);
                    index = SwatchShapeIndex.findShape(words[1]);
                    if (index == -1) {
                        words[1] = words[1].replace(':', '-');
                        index = SwatchShapeIndex.findShape(words[1]);
                    }
                    log.debug("shape index:" + index);
                    if (index == -1) {
                        log.error("Shape not found for:" + words[1]);
                        continue;
                    }
                    if (shape == index) continue;
                    shapeRemap.put(shape, index);
                    continue;
                }
                if (line.startsWith("%size")) {
                    sizes = ClothingFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in size directive:" + line);
                    }
                    sizeX = sizes[0];
                    sizeY = sizes[1];
                    sizeZ = sizes[2];
                    target = cells = new CellArray(sizeX, sizeY, sizeZ);
                    continue;
                }
                if (line.startsWith("%min:")) {
                    sizes = ClothingFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in min directive:" + line);
                    }
                    minX = sizes[0];
                    minY = sizes[1];
                    minZ = sizes[2];
                    y = minY;
                    z = minZ;
                    continue;
                }
                if (line.startsWith("%max:")) {
                    sizes = ClothingFileFormat.parseTriple(line);
                    if (sizes == null) {
                        throw new IOException("Bad format in max directive:" + line);
                    }
                    maxX = sizes[0];
                    maxY = sizes[1];
                    maxZ = sizes[2];
                    continue;
                }
                if (line.startsWith("%z:")) {
                    z = Integer.parseInt(line.substring("%z:".length()));
                    y = minY;
                    continue;
                }
                if (line.startsWith("%")) {
                    throw new IOException("Unhandled directive:" + line);
                }
                String[] tokens = line.split(",\\s*");
                for (int i = 0; i < tokens.length; ++i) {
                    int[] values = ClothingFileFormat.parsePair(tokens[i]);
                    Integer override = (Integer)fabricRemap.get(values[0]);
                    if (override != null) {
                        values[0] = override;
                    }
                    if ((override = (Integer)shapeRemap.get(values[1])) != null) {
                        values[1] = override;
                    }
                    int value = FabricUtils.toCell(values[1], values[0]);
                    target.setCell(minX + i, y, z, value);
                }
                ++y;
            }
            CellArray cellArray = cells;
            return cellArray;
        }
    }

    public void writeCells(String file, CellArray cells) throws IOException {
        try (FileOutputStream fOut = new FileOutputStream(new File(file));){
            this.writeCells(fOut, cells);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCells(OutputStream rawOut, CellArray cells) throws IOException {
        HashMap<Integer, String> fabricNames = new HashMap<Integer, String>();
        HashMap<Integer, String> swatches = new HashMap<Integer, String>();
        OutputStreamWriter sOut = new OutputStreamWriter(rawOut, Charsets.UTF_8);
        try (PrintWriter out = new PrintWriter(sOut);){
            int val;
            int sizeX = cells.getSizeX();
            int sizeY = cells.getSizeY();
            int sizeZ = cells.getSizeZ();
            int minX = sizeX;
            int minY = sizeY;
            int minZ = sizeZ;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            for (int x = 0; x < sizeX; ++x) {
                for (int y = 0; y < sizeY; ++y) {
                    for (int z = 0; z < sizeZ; ++z) {
                        val = cells.getCell(x, y, z);
                        if (val == 0) continue;
                        minX = Math.min(minX, x);
                        maxX = Math.max(maxX, x);
                        minY = Math.min(minY, y);
                        maxY = Math.max(maxY, y);
                        minZ = Math.min(minZ, z);
                        maxZ = Math.max(maxZ, z);
                        int shapeIndex = FabricUtils.toShape(val);
                        int fabricIndex = FabricUtils.toFabric(val);
                        FabricType type = this.fabricTypes[fabricIndex];
                        SwatchShape shape = this.swatchShapes[shapeIndex];
                        fabricNames.put(fabricIndex, type.getFullName());
                        swatches.put(shapeIndex, shape.getFullName());
                    }
                }
            }
            if (minX == sizeX) {
                minX = 0;
            }
            if (minY == sizeY) {
                minY = 0;
            }
            if (minZ == sizeZ) {
                minZ = 0;
            }
            out.println("%Clothing version 1");
            out.println("%size: " + sizeX + ", " + sizeY + ", " + sizeZ);
            out.println("%order: z, y, x");
            out.println("%compression: none");
            for (Map.Entry e : fabricNames.entrySet()) {
                out.println("%fabric:" + e.getKey() + "=" + (String)e.getValue());
            }
            for (Map.Entry e : swatches.entrySet()) {
                out.println("%swatch:" + e.getKey() + "=" + (String)e.getValue());
            }
            out.println("%min: " + minX + ", " + minY + ", " + minZ);
            out.println("%max: " + maxX + ", " + maxY + ", " + maxZ);
            for (int z = minZ; z <= maxZ; ++z) {
                out.println("%z:" + z);
                for (int y = minY; y <= maxY; ++y) {
                    for (int x = minX; x <= maxX; ++x) {
                        val = cells.getCell(x, y, z);
                        int shape = FabricUtils.toShape(val);
                        int fabric = FabricUtils.toFabric(val);
                        out.print(fabric + ":" + shape);
                        if (x >= maxX) continue;
                        out.print(", ");
                    }
                    out.println();
                }
            }
        }
    }

    private static int[] parseTriple(String s) {
        Matcher m = TRIPLE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] result = new int[3];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(m.group(i + 1));
        }
        return result;
    }

    private static String[] parseValue(String s) {
        Matcher m = VALUE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String[] result = new String[2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = m.group(i + 1);
        }
        return result;
    }

    private static int[] parsePair(String s) {
        Matcher m = NUM_PAIR.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] result = new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
        return result;
    }
}

