/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.io.UpdateableData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import mythruna.fabric.FabricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricTypeData
implements UpdateableData<FabricTypeData> {
    public static final long formatVersion = 42L;
    static Logger log = LoggerFactory.getLogger(FabricTypeData.class);
    public int badTypeIndex;
    public FabricType[] types;

    public FabricTypeData() {
    }

    public FabricTypeData(FabricType[] types, int badTypeIndex) {
        this.types = types;
        this.badTypeIndex = badTypeIndex;
    }

    public boolean update(FabricTypeData update) {
        if (Arrays.asList(this.types).equals(Arrays.asList(update.types))) {
            return false;
        }
        String updateBadType = null;
        if (update.badTypeIndex >= 0 && update.badTypeIndex < update.types.length) {
            FabricType bt = update.types[update.badTypeIndex];
            updateBadType = bt != null ? bt.getFullName() : null;
        }
        String badType = null;
        if (this.badTypeIndex >= 0 && this.badTypeIndex < this.types.length) {
            FabricType bt = this.types[this.badTypeIndex];
            badType = bt != null ? bt.getFullName() : null;
        }
        HashMap<String, FabricType> index = new HashMap<String, FabricType>();
        for (FabricType type : this.types) {
            if (type == null) continue;
            index.put(type.getFullName(), type);
        }
        ArrayList<FabricType> newTypes = new ArrayList<FabricType>(Arrays.asList(this.types));
        for (FabricType type : update.types) {
            if (type == null) continue;
            FabricType existing = (FabricType)index.get(type.getFullName());
            if (existing == null) {
                log.info("New type:" + type.getFullName());
                newTypes.add(type);
                index.put(type.getFullName(), type);
                continue;
            }
            if (Objects.equals(type, existing)) continue;
            log.info("Replacing:" + existing.getFullName());
            int i = newTypes.indexOf(existing);
            if (i < 0) {
                throw new RuntimeException("Data format error: existing type not found in type list, type:" + existing.getFullName());
            }
            newTypes.set(i, type);
            index.put(type.getFullName(), type);
        }
        if (!Objects.equals(badType, updateBadType)) {
            log.info("Updating bad type index, old type:" + badType + " new type:" + updateBadType);
            FabricType bad = updateBadType == null ? null : (FabricType)index.get(updateBadType);
            this.badTypeIndex = newTypes.indexOf(bad);
            log.info("New bad type index:" + this.badTypeIndex);
        }
        this.types = newTypes.toArray(new FabricType[0]);
        return true;
    }

    public static FabricTypeData load(InputStream rawIn) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(rawIn);){
            FabricTypeData result = new FabricTypeData();
            long version = in.readLong();
            try {
                result.types = (FabricType[])in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Error resolving types", e);
            }
            result.badTypeIndex = in.readInt();
            FabricTypeData fabricTypeData = result;
            return fabricTypeData;
        }
    }

    public static FabricTypeData load(String resource) throws IOException {
        URL u = FabricTypeData.class.getResource(resource);
        if (u == null) {
            return null;
        }
        return FabricTypeData.load(u.openStream());
    }

    public static FabricTypeData load(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        return FabricTypeData.load(new FileInputStream(f));
    }

    public static void store(FabricTypeData data, File f) throws IOException {
        FabricTypeData.store(data, new FileOutputStream(f));
    }

    public static void store(FabricTypeData data, OutputStream rawOut) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(rawOut);){
            out.writeLong(42L);
            out.writeObject(data.types);
            out.writeInt(data.badTypeIndex);
        }
    }

    public void writeIndex(File f) throws IOException {
        FileOutputStream fOut = new FileOutputStream(f);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fOut, Charsets.UTF_8));){
            out.println("# Generated:" + String.format("%1$tF %1$tT", new Date()));
            for (int i = 0; i < this.types.length; ++i) {
                FabricType type = this.types[i];
                if (type == null) continue;
                out.println("[" + i + "] " + type.getFullName());
            }
        }
    }
}

