/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.simsilica.es.EntityData;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.phys.MBlockShape;
import java.util.function.Function;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(FabricShapeFactory.class);
    private static final CellArray BOX = new CellArray(1);
    private EntityData ed;
    private Function<CellArrayId, CellArray> storage;

    public FabricShapeFactory(Function<CellArrayId, CellArray> storage, EntityData ed) {
        this.storage = storage;
        this.ed = ed;
    }

    public MBlockShape createShape(ShapeInfo info, Mass mass) {
        String name;
        ShapeName shape;
        if (log.isTraceEnabled()) {
            log.trace("createShape(" + info.toString(this.ed) + ", " + mass + ")");
        }
        if (!"fab".equals((shape = ShapeName.parse(name = info.getShapeName(this.ed))).getType())) {
            return null;
        }
        double m = mass == null ? 0.0 : mass.getMass();
        CellArray cells = BOX;
        return MBlockShape.createShape((String)name, (CellArray)cells, (double)info.getScale(), (double)m);
    }

    static {
        BOX.setCell(0, 0, 0, MaskUtils.setSideMask((int)1, (int)63));
    }
}

