/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.simsilica.es.EntityData;
import com.simsilica.ext.mblock.BlockShapeFactory;
import com.simsilica.ext.mblock.CellArrayFunctions;
import com.simsilica.ext.mblock.SphereFactory;
import com.simsilica.ext.mphys.CompositeShapeFactory;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.phys.MBlockShape;
import java.util.function.Function;
import mythruna.net.GameSession;
import mythruna.shape.FabricShapeFactory;
import mythruna.shape.RigShapeFactory;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeRegistryBuilder {
    static Logger log = LoggerFactory.getLogger(ShapeRegistryBuilder.class);

    public static ShapeFactoryRegistry<MBlockShape> serverRegistry(WorldManager worldManager) {
        return ShapeRegistryBuilder.createRegistry((EntityData)worldManager.getEntityData(), (Function<CellArrayId, CellArray>)worldManager.getCellArrayStorage());
    }

    public static ShapeFactoryRegistry<MBlockShape> clientRegistry(EntityData ed, final GameSession session) {
        return ShapeRegistryBuilder.createRegistry(ed, new Function<CellArrayId, CellArray>(){

            @Override
            public CellArray apply(CellArrayId id) {
                return session.getCellArray(id);
            }
        });
    }

    public static ShapeFactoryRegistry<MBlockShape> createRegistry(EntityData ed, Function<CellArrayId, CellArray> storage) {
        ShapeFactoryRegistry shapeFactory = new ShapeFactoryRegistry();
        shapeFactory.registerFactory(ShapeInfo.create((String)"sphere", (double)1.0, (EntityData)ed), (ShapeFactory)new SphereFactory());
        CompositeShapeFactory chain = new CompositeShapeFactory(new ShapeFactory[0]);
        shapeFactory.setDefaultFactory((ShapeFactory)chain);
        chain.addDelegate((ShapeFactory)new RigShapeFactory(ed));
        chain.addDelegate((ShapeFactory)new FabricShapeFactory(storage, ed));
        BlockShapeFactory blockFactory = new BlockShapeFactory(ed);
        chain.addDelegate((ShapeFactory)blockFactory);
        Function loaders = CellArrayFunctions.chain((Function[])new Function[]{CellArrayFunctions.blocksResource(), CellArrayFunctions.cellArrayStorage(storage)});
        blockFactory.addDelegate(CellArrayFunctions.singletonCache((Function)loaders));
        return shapeFactory;
    }
}

