/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import mythruna.shell.ShellCommand;
import mythruna.shell.ShellWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandShell {
    static Logger log = LoggerFactory.getLogger(CommandShell.class);
    private CommandShell parent;
    private Map<String, ShellCommand> commands = new TreeMap<String, ShellCommand>();
    private Map<String, Object> variables;
    private Consumer<String> output;
    private Writer writer;

    public CommandShell() {
        this(null, null, null);
    }

    public CommandShell(Consumer<String> output) {
        this(null, null, output);
    }

    public CommandShell(CommandShell parent, Map<String, Object> variables, Consumer<String> output) {
        this.parent = parent;
        this.variables = variables == null ? new HashMap() : variables;
        this.setOutput(output);
        if (parent != null) {
            this.variables.putAll(parent.getVariables());
        }
    }

    public Object put(String key, Object value) {
        return this.variables.put(key, value);
    }

    public Object get(String key) {
        Object result = this.variables.get(key);
        if (result == null && this.parent != null) {
            result = this.parent.get(key);
        }
        return result;
    }

    public <T> T get(String key, T defaultValue) {
        Object result = this.get(key);
        return (T)(result == null ? defaultValue : result);
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, ShellCommand> getCommands() {
        if (this.parent != null) {
            TreeMap<String, ShellCommand> results = new TreeMap<String, ShellCommand>(this.parent.getCommands());
            results.putAll(this.commands);
            return Collections.unmodifiableMap(results);
        }
        return Collections.unmodifiableMap(this.commands);
    }

    public void addCommand(String name, ShellCommand command) {
        if (this.commands.containsKey(name)) {
            throw new IllegalArgumentException("Command already exists for:" + name);
        }
        this.commands.put(name, command);
    }

    public void updateCommand(String name, ShellCommand command) {
        this.commands.put(name, command);
    }

    public ShellCommand getCommand(String name) {
        ShellCommand result = this.commands.get(name);
        if (result == null && this.parent != null) {
            result = this.parent.getCommand(name);
        }
        return result;
    }

    public Object execute(String commandAndArgs) {
        int split = commandAndArgs.indexOf(32);
        if (split > 0) {
            String cmd = commandAndArgs.substring(0, split);
            String args = commandAndArgs.substring(split + 1);
            return this.execute(cmd, args);
        }
        return this.execute(commandAndArgs, null);
    }

    public Object execute(String command, String args) {
        ShellCommand cmd = this.getCommand(command);
        if (cmd == null) {
            throw new IllegalArgumentException("Command not found:" + command);
        }
        return cmd.execute(this, args);
    }

    public void echo(String msg) {
        this.output.accept(msg);
    }

    public final void setOutput(Consumer<String> output) {
        this.output = output == null ? new DefaultOutput() : output;
        this.writer = new ShellWriter(output);
    }

    public Consumer<String> getOutput() {
        if (this.output == null && this.parent != null) {
            return this.parent.getOutput();
        }
        return this.output;
    }

    public Writer getWriter() {
        if (this.output == null && this.parent != null) {
            return this.parent.getWriter();
        }
        return this.writer;
    }

    private static class DefaultOutput
    implements Consumer<String> {
        private DefaultOutput() {
        }

        @Override
        public void accept(String line) {
            System.out.println(line);
        }
    }
}

