/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.Objects;
import mythruna.es.AttachedTo;
import mythruna.es.ContainedIn;
import mythruna.es.Holding;
import mythruna.sim.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoldingSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(HoldingSystem.class);
    private EntityData ed;
    private ObjectTypeRegistry<Activator, EntityId> objectTypes;
    private HolderContainer holders;

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.objectTypes = (ObjectTypeRegistry)this.getSystem(ObjectTypeRegistry.class);
        this.holders = new HolderContainer(this.ed);
    }

    protected void terminate() {
    }

    public void start() {
        this.holders.start();
    }

    public void update(SimTime time) {
        this.holders.update();
    }

    public void stop() {
        this.holders.stop();
    }

    private class HolderContainer
    extends EntityContainer<Holder> {
        public HolderContainer(EntityData ed) {
            super(ed, new Class[]{Holding.class});
        }

        protected Holder addObject(Entity entity) {
            log.info("addObject(" + entity + ")");
            Holder holder = new Holder(entity);
            this.updateObject(holder, entity);
            return holder;
        }

        protected void updateObject(Holder holder, Entity entity) {
            log.info("updateObject(" + entity + ")");
            holder.update();
        }

        protected void removeObject(Holder holder, Entity entity) {
            log.info("removeObject(" + entity + ")");
            holder.release();
        }
    }

    private class Holder {
        private Entity entity;
        private Holding holding;

        public Holder(Entity entity) {
            this.entity = entity;
        }

        public void update() {
            Quatd handleRot;
            Vec3d handlePos;
            Holding newValue = (Holding)this.entity.get(Holding.class);
            if (Objects.equals(this.holding, newValue)) {
                return;
            }
            this.cleanup();
            this.holding = newValue;
            if (this.holding == null || this.holding.getTarget() == null) {
                return;
            }
            EntityId actor = this.entity.getId();
            ObjectType type = HoldingSystem.this.objectTypes.getType((Object)this.holding.getTarget());
            if (type == null) {
                handlePos = new Vec3d();
                handleRot = new Quatd();
            } else {
                handlePos = (Vec3d)type.getTypeVar("handleLocation", (Object)new Vec3d());
                handleRot = (Quatd)type.getTypeVar("handleRotation", (Object)new Quatd());
            }
            Quatd rot = new Quatd().fromAngles(0.0, 1.5707963267948966, 0.0);
            ShapeInfo shape = (ShapeInfo)HoldingSystem.this.ed.getComponent(this.holding.getTarget(), ShapeInfo.class);
            double itemScale = 1.0;
            if (shape != null) {
                itemScale = shape.getScale();
            }
            rot = rot.mult(handleRot);
            handlePos = handlePos.mult(-itemScale);
            rot.mult(handlePos, handlePos);
            HoldingSystem.this.ed.setComponents(this.holding.getTarget(), new EntityComponent[]{AttachedTo.create(actor, "hand.right", handlePos, rot, HoldingSystem.this.ed)});
        }

        protected void cleanup() {
            log.info("Cleaning up holder for:" + this.entity.getId() + " holding:" + this.holding);
            if (this.holding == null || this.holding.getTarget() == null) {
                return;
            }
            EntityId target = this.holding.getTarget();
            HoldingSystem.this.ed.removeComponent(target, AttachedTo.class);
            ContainedIn in = (ContainedIn)HoldingSystem.this.ed.getComponent(target, ContainedIn.class);
            if (in == null) {
                log.warn("Detached entity has no container and will disappear:" + target);
            }
        }

        public void release() {
            this.cleanup();
        }
    }
}

