/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.trans.PositionTransition3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.RigidBody;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythruna.sim.MovementSystem;
import mythruna.sim.PathBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathRecorderSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(PathRecorderSystem.class);
    private MovementSystem movementSystem;
    private Map<EntityId, TapeTask> taskIndex = new HashMap<EntityId, TapeTask>();
    private Map<EntityId, PathBuffer> bufferIndex = new HashMap<EntityId, PathBuffer>();
    private DynArray<TapeTask> tasks = new DynArray(TapeTask.class);

    public void record(EntityId id) {
        log.info("record(" + id + ")");
        RigidBody<EntityId, MBlockShape> body = this.movementSystem.getBody(id);
        if (body == null) {
            throw new IllegalArgumentException("No rigid body found for:" + id);
        }
        TapeTask existing = this.taskIndex.remove(id);
        if (existing != null) {
            this.tasks.remove((Object)existing);
        }
        PathBuffer buffer = new PathBuffer();
        RecordTask task = new RecordTask(body, buffer);
        this.taskIndex.put(id, task);
        this.bufferIndex.put(id, buffer);
        this.tasks.add((Object)task);
    }

    public void play(EntityId id) {
        PathBuffer buffer;
        log.info("play(" + id + ")");
        RigidBody<EntityId, MBlockShape> body = this.movementSystem.getBody(id);
        if (body == null) {
            throw new IllegalArgumentException("No rigid body found for:" + id);
        }
        TapeTask existing = this.taskIndex.remove(id);
        if (existing != null) {
            this.tasks.remove((Object)existing);
        }
        if ((buffer = this.bufferIndex.get(id)) == null) {
            throw new IllegalArgumentException("No recorded buffer for:" + id);
        }
        PlayTask task = new PlayTask(body, buffer);
        this.taskIndex.put(id, task);
        this.bufferIndex.put(id, buffer);
        this.tasks.add((Object)task);
    }

    public long stop(EntityId id) {
        log.info("stop(" + id + ")");
        TapeTask task = this.taskIndex.get(id);
        if (task == null) {
            return -1L;
        }
        this.tasks.remove((Object)task);
        return task.getDuration();
    }

    protected void initialize() {
        this.movementSystem = (MovementSystem)((Object)this.getSystem(MovementSystem.class, true));
    }

    protected void terminate() {
    }

    public void update(SimTime time) {
        long frameTime = time.getTime();
        for (TapeTask task : (TapeTask[])this.tasks.getArray()) {
            if (task.update(frameTime)) continue;
            log.info("Finished:" + task);
            this.tasks.remove((Object)task);
        }
    }

    private static interface TapeTask {
        public boolean update(long var1);

        public long getDuration();
    }

    private class RecordTask
    implements TapeTask {
        PathBuffer buffer;
        RigidBody<EntityId, MBlockShape> body;

        public RecordTask(RigidBody<EntityId, MBlockShape> body, PathBuffer buffer) {
            this.body = body;
            this.buffer = buffer;
        }

        @Override
        public long getDuration() {
            return this.buffer.getDuration();
        }

        @Override
        public boolean update(long time) {
            this.buffer.addFrame(time, this.body.position, this.body.orientation);
            return true;
        }
    }

    private class PlayTask
    implements TapeTask {
        PathBuffer buffer;
        RigidBody<EntityId, MBlockShape> body;
        private List<PositionTransition3d> frames = new ArrayList<PositionTransition3d>();
        private PositionTransition3d currentFrame;
        private Long startTime = null;
        private long currentTime;
        private int currentIndex;

        public PlayTask(RigidBody<EntityId, MBlockShape> body, PathBuffer buffer) {
            this.body = body;
            this.buffer = buffer;
            this.frames = buffer.getFrames();
            this.currentTime = 0L;
            this.currentIndex = 0;
            this.currentFrame = this.frames.get(this.currentIndex);
        }

        @Override
        public long getDuration() {
            return this.startTime == null ? -1L : this.currentTime - this.startTime;
        }

        @Override
        public boolean update(long time) {
            if (!this.advance(time)) {
                return false;
            }
            this.body.position.set(this.currentFrame.getPosition(this.currentTime, true));
            this.body.orientation.set(this.currentFrame.getRotation(this.currentTime, true));
            this.body.getForces().set(0.0, 0.0, 0.0);
            this.body.wakeUp(true);
            return true;
        }

        protected boolean advance(long time) {
            if (this.startTime == null) {
                this.startTime = time;
                time = 0L;
            } else {
                time -= this.startTime.longValue();
            }
            if (this.currentFrame.containsTime(time)) {
                this.currentTime = time;
                return true;
            }
            while (this.currentIndex < this.frames.size()) {
                this.currentFrame = this.frames.get(this.currentIndex);
                if (this.currentFrame.containsTime(time)) {
                    this.currentTime = time;
                    return true;
                }
                ++this.currentIndex;
            }
            return false;
        }
    }
}

