/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.PersistentComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeInfo
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ShapeInfo.class);
    private int id;
    private double scale;

    public ShapeInfo() {
    }

    public ShapeInfo(int id, double scale) {
        this.id = id;
        this.scale = scale;
    }

    public int getShapeId() {
        return this.id;
    }

    public double getScale() {
        return this.scale;
    }

    public ShapeInfo changeShapeName(String name, EntityData ed) {
        int id = ed.getStrings().getStringId(name, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(name, true);
        }
        return new ShapeInfo(id, this.scale);
    }

    public String getShapeName(EntityData ed) {
        return ed.getStrings().getString(this.id);
    }

    public static ShapeInfo create(String name, double scale, EntityData ed) {
        int id = ed.getStrings().getStringId(name, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(name, true);
        }
        return new ShapeInfo(id, scale);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.id) : this.getShapeName(ed);
        return this.getClass().getSimpleName() + "[shape=" + s + ", scale=" + this.scale + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ShapeInfo other = (ShapeInfo)o;
        return other.id == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.toString(null);
    }
}

