/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;

public class SpawnPosition
implements EntityComponent,
PersistentComponent {
    private Vec3d location;
    private Quatd orientation;
    private long binId;

    public SpawnPosition() {
    }

    public SpawnPosition(Grid grid, double x, double y, double z) {
        this(grid, new Vec3d(x, y, z), new Quatd());
    }

    public SpawnPosition(Grid grid, double x, double y, double z, Quatd orientation) {
        this(grid, new Vec3d(x, y, z), orientation);
    }

    public SpawnPosition(Grid grid, Vec3d location) {
        this(grid, location, new Quatd());
    }

    public SpawnPosition(Grid grid, Vec3d location, double facing) {
        this(grid, location, new Quatd().fromAngles(0.0, (double)((float)facing), 0.0));
    }

    public SpawnPosition(Grid grid, Vec3d location, Quatd orientation) {
        this.location = location;
        this.orientation = orientation;
        Vec3i cell = grid.worldToCell(location);
        this.binId = grid.cellToId(cell.x, cell.y, cell.z);
    }

    public SpawnPosition(long binId, Vec3d location, Quatd orientation) {
        this.binId = binId;
        this.location = location;
        this.orientation = orientation;
    }

    public Vec3d getLocation() {
        return this.location;
    }

    public Quatd getOrientation() {
        return this.orientation;
    }

    public long getBinId() {
        return this.binId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("location", (Object)this.location).add("orientation", (Object)this.orientation).add("binId", this.binId).toString();
    }
}

