
// Some default clothing designs that we give to all players

findDefaultClothingDesigns = {
    def parent = worldManager.worldEntity;
    def filter = Filters.fieldEquals(ClothingInfo.class, "parent", parent);
    return entityData.findEntities(filter, ClothingInfo.class); 
}

findClothingDesign = { parent, name ->
    def filter1 = Filters.fieldEquals(ClothingInfo.class, "parent", parent);
    def filter2 = Filters.fieldEquals(ClothingInfo.class, "name", name);
    return entityData.findEntity(Filters.and(ClothingInfo.class, filter1, filter2), ClothingInfo.class); 
}

createDefaultClothingDesign = { String designName, String itemName, String cellResource ->
    if( cellResource.charAt(0) != '/' ) {
        // Make an assumption
        cellResource = "/Models/clothes/" + cellResource;
    }
    def parent = worldManager.worldEntity;
    def cellId = importClothingResource(cellResource);

    // See if we already have one
    def entity = findClothingDesign(worldManager.worldEntity, designName);
    if( entity == null ) {
        // Create the entity
        entity = entityData.createEntity();
    }
    
    // We're going to reset the data either way
    def info = new ClothingInfo(parent, designName);
    def shapeName = new ShapeName("fab", cellId.toIdString());
    
    entityData.setComponents(entity,
            info,
            ObjectName.create(itemName),
            ObjectTypeInfo.create("ClothingDesign"),
            ShapeInfo.create(shapeName.toCompositeString(), 1),
            new CreatedBy(parent)
            );            

    return entity;
}

copyClothingDesign = { EntityId design, EntityId target ->
    def info = design[ClothingInfo];
    if( info == null ) {
        throw new IllegalArgumentException("Entity is not a clothing design:" + design);
    }
    // See if it already exists in the target
    def entity = findClothingDesign(target, info.getName());
    if( entity != null ) {
        log.info("Player:" + target + " already has clothing design:" + info);
        // So let's not blow away any changes they might have made
        return;
    } else {
        log.info("Creating:" + info + " on player:" + target);
        entity = entityData.createEntity();
    }
    entityData.setComponents(entity,
        info.changeParent(target),
        design[ObjectName],
        design[ObjectTypeInfo],
        design[ShapeInfo],
        design[CreatedBy]
        );
    return entity;
}
  
if( true ) {
    log.info("Creating default clothing designs...");
    createDefaultClothingDesign("Basic Boots", "Boots", "basic-boots.clothing");
    createDefaultClothingDesign("Basic Pants", "Pants", "basic-pants.clothing");
    createDefaultClothingDesign("Basic Shirt", "Shirt", "basic-shirt.clothing");
    createDefaultClothingDesign("Basic Tunic", "Tunic", "basic-tunic.clothing");
    createDefaultClothingDesign("Underwear - Top", "Bra", "bra.clothing");
    createDefaultClothingDesign("Cuffed Boots", "Boots", "cuffed-boots.clothing");
    createDefaultClothingDesign("Underwear - Bottom", "Panties", "panties.clothing");
    createDefaultClothingDesign("Pants With Belt", "Pants", "pants-with-belt.clothing");
    createDefaultClothingDesign("Right Bracer", "Bracer", "right-bracer.clothing");
    createDefaultClothingDesign("Shirt Vest", "Shirt", "shirt-vest.clothing");
    createDefaultClothingDesign("Silver Necklace", "Necklace", "silver-necklace.clothing");
}    

// When a player entity is created, we want to add some
// standard clothing for them.
on( playerEntityCreated ) { event ->
}

on( playerEntityJoining ) { event ->
    // For now do it on join since it's easier to update existing players
    // that way.
    
    // Copy the standard clothing
    log.info("Adding default clothing designs to:" + event.player);   
    findDefaultClothingDesigns().each {
        log.info("Clothing design:" + it);
        copyClothingDesign(it, event.player);
    }
}
