/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.db.ObservableColumnDb;
import com.simsilica.mworld.tile.ColumnStates;
import com.simsilica.mworld.tile.ColumnStatesDb;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageDb;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TerrainTypeFunction;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.TileManager;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainImageManager {
    static Logger log = LoggerFactory.getLogger(TerrainImageManager.class);
    public static final String TILE_INCOMPLETE_COLUMNS = "incompleteColumns";
    private File root;
    private TerrainImageDb terrainDb;
    private ObservableColumnDb columnDb;
    private TileManager tiles;
    private TerrainTypeFunction typeFunction;
    private ColumnStatesDb colStatesDb;
    private boolean reprocessTrees = true;
    private CopyOnWriteArrayList<TileListener> listeners = new CopyOnWriteArrayList();

    public TerrainImageManager(File root, TerrainImageDb terrainDb, ObservableColumnDb columnDb, TileManager tiles, TerrainTypeFunction typeFunction) {
        this.root = root;
        this.terrainDb = terrainDb;
        this.colStatesDb = new ColumnStatesDb(root, "terrain.state");
        this.columnDb = columnDb;
        this.tiles = tiles;
        this.typeFunction = typeFunction;
        columnDb.addColumnChangeListener(event -> this.markDirty(event.getColumnId(), true));
        columnDb.addColumnGenerationListener(event -> this.markGenerated(event.getColumnData()));
    }

    public void addTileListener(TileListener l) {
        this.listeners.add(l);
    }

    public void removeTileListener(TileListener l) {
        this.listeners.remove(l);
    }

    public void initialize() {
        this.colStatesDb.initialize();
    }

    public void terminate() {
        this.colStatesDb.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        ColumnStates states;
        if (log.isTraceEnabled()) {
            log.trace("getTerrainImage(" + id + ", " + (Object)((Object)type) + ", " + (Object)((Object)res) + ")");
        }
        Tile tile = this.tiles.getTile(id, res);
        TerrainImage result = tile.get((Object)type, TerrainImage.class);
        if (res != Resolution.High) {
            return result;
        }
        if (type == TerrainImageType.Fluid) {
            return result;
        }
        ColumnStates columnStates = states = (ColumnStates)this.colStatesDb.get(id);
        synchronized (columnStates) {
            boolean changed = false;
            ColumnStates incomplete = tile.get(TILE_INCOMPLETE_COLUMNS, ColumnStates.class);
            if (incomplete != null) {
                log.info("markAll(" + incomplete + ")");
                states.markAll(incomplete);
            }
            if (this.updateTerrain(tile, result, states.getDirtyColumns())) {
                log.info("storing:" + states);
                this.colStatesDb.update(id, states);
                result.getVersion().markChanged();
                this.terrainDb.update(result.getId(), result);
            }
        }
        return result;
    }

    protected void markDirty(ColumnId colId, boolean notifyTileListeners) {
        TileId tileId = colId.getTileId();
        log.info("markDirty(" + colId + ", " + notifyTileListeners + ") in tile:" + tileId);
        this.colStatesDb.markDirty(colId);
        if (notifyTileListeners) {
            TileChangeEvent event = new TileChangeEvent(TerrainImage.class, tileId, Integer.MAX_VALUE, Resolution.High);
            for (TileListener l : this.listeners) {
                l.tileChanged(event);
            }
        }
    }

    protected void markGenerated(ColumnData col) {
        log.info("markGenerated(" + col + ")");
    }

    protected boolean updateTerrain(Tile tile, TerrainImage image, Iterable<ColumnId> columns) {
        Vec3i base = image.getId().getTileId().getWorld(null);
        boolean changed = false;
        TreeLayer trees = null;
        if (this.reprocessTrees) {
            trees = tile.get(TreeLayer.class);
        }
        Iterator<ColumnId> it = columns.iterator();
        while (it.hasNext()) {
            ColumnId colId = it.next();
            it.remove();
            ColumnData col = this.columnDb.getColumn(colId);
            log.info("processing dirty column:" + col);
            boolean[][] done = new boolean[32][32];
            int groundLeft = 1024;
            LeafData[] leafs = col.getLeafs();
            LightData[] lighting = col.getLighting();
            for (int i = leafs.length - 1; i >= 0; --i) {
                LeafData leaf = leafs[i];
                LightData lights = lighting[i];
                int yBase = i * 32;
                if (leaf.isEmpty()) continue;
                for (int x = 0; x < 32; ++x) {
                    block3: for (int z = 0; z < 32; ++z) {
                        if (done[x][z]) continue;
                        int tx = leaf.getInfo().location.x + -base.x + x;
                        int tz = leaf.getInfo().location.z + -base.z + z;
                        byte existing = image.getType(tx, tz);
                        int lastLight = LightUtils.DIRECT_SUN;
                        for (int y = 31; y >= 0; --y) {
                            int val = leaf.getCell(x, y, z);
                            int type = MaskUtils.getType((int)val);
                            BlockType bt = BlockTypeIndex.get((int)type);
                            int light = lights.getCell(x, y, z);
                            if (bt != null && !bt.isSolid() && !bt.isTransparent()) {
                                lastLight = light;
                                continue;
                            }
                            int groundType = this.typeFunction.apply(existing, val, type);
                            if (groundType != -1) {
                                done[x][z] = true;
                                --groundLeft;
                                int elevation = leaf.getInfo().location.y + y + 1;
                                if (image.getElevation(tx, tz) != elevation) {
                                    image.setElevation(tx, tz, (short)elevation);
                                    changed = true;
                                }
                                if (existing != groundType) {
                                    image.setType(tx, tz, (byte)groundType);
                                    changed = true;
                                }
                                int sun = LightUtils.sun((int)lastLight);
                                int local = LightUtils.localMax((int)lastLight);
                                int overall = local - (15 - sun);
                                if (image.getLight(tx, tz) == overall) continue block3;
                                image.setLight(tx, tz, (byte)overall);
                                changed = true;
                                continue block3;
                            }
                            lastLight = light;
                        }
                    }
                }
                if (groundLeft <= 0) break;
            }
            if (trees == null) continue;
            for (Tree tree : trees.getTrees(colId)) {
                tree.type.insertTree(tree, image);
            }
        }
        return changed;
    }
}

