/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.net.DataSession;
import mythruna.net.DataSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSessionClientService
extends AbstractClientService
implements DataSession {
    static Logger log = LoggerFactory.getLogger(DataSessionClientService.class);
    private RmiClientService rmiService;
    private byte channel;
    private DataSession delegate;
    private DataSessionCallback sessionCallback = new DataSessionCallback();
    private List<DataSessionListener> listeners = new CopyOnWriteArrayList<DataSessionListener>();

    public DataSessionClientService(int channel) {
        this.channel = (byte)channel;
    }

    private DataSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (DataSession)this.rmiService.getRemoteObject(DataSession.class);
            log.info("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No DataSession found");
            }
        }
        return this.delegate;
    }

    public void addDataSessionListener(DataSessionListener l) {
        this.listeners.add(l);
    }

    public void removeDataSessionListener(DataSessionListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.info("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("RMI service required");
        }
        this.rmiService.share((Object)this.sessionCallback, DataSessionListener.class);
    }

    public void start() {
        log.info("start()");
        super.start();
    }

    @Override
    public FabricTypeData getFabricTypeData() {
        log.info("getFabricTypeData()");
        try {
            byte[] bytes = this.getFabricTypeDataBytes();
            log.info("received " + bytes.length + " bytes");
            FabricTypeData fabricTypeData = FabricTypeData.fromBytes(bytes);
            return fabricTypeData;
        }
        finally {
            log.info("done getFabricTypeData()");
        }
    }

    @Override
    public byte[] getFabricTypeDataBytes() {
        return this.getDelegate().getFabricTypeDataBytes();
    }

    @Override
    public SwatchShapeData getSwatchShapeData() {
        byte[] bytes = this.getSwatchShapeDataBytes();
        return SwatchShapeData.fromBytes(bytes);
    }

    @Override
    public byte[] getSwatchShapeDataBytes() {
        return this.getDelegate().getSwatchShapeDataBytes();
    }

    private class DataSessionCallback
    implements DataSessionListener {
        private DataSessionCallback() {
        }

        @Override
        public void dataAvailable() {
            log.info("dataAvailable()");
            for (DataSessionListener l : DataSessionClientService.this.listeners) {
                l.dataAvailable();
            }
        }
    }
}

