/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.insert.BlockInsert;
import com.simsilica.mworld.tile.insert.InsertLayer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import mythruna.world.WorldFractal;
import mythruna.world.town.Marker;
import mythruna.world.town.TestBlockRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerFileTownFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(MarkerFileTownFunction.class);
    private List<Marker> markers;
    private Multimap<TileId, Marker> markerIndex = MultimapBuilder.hashKeys().arrayListValues().build();
    private TestBlockRegistry blocksRegistry;
    private Vec3i spawnLoc;
    private Vec3i fakeSpawnLoc = new Vec3i(61695, 552, -15518);
    private WorldFractal fractal;
    private BlockDataId cropsBlocks;
    private BlockDataId houseBlocks;
    private BlockDataId canopyBlocks;
    private BlockDataId towerBlocks;
    private Vec3i spawnSize;

    public MarkerFileTownFunction(File file, TestBlockRegistry blocksRegistry, Vec3d spawnLoc, WorldFractal fractal) {
        this.blocksRegistry = blocksRegistry;
        this.spawnLoc = spawnLoc.floor();
        this.fractal = fractal;
        try {
            String json = Files.toString((File)file, (Charset)Charsets.UTF_8);
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            Gson gson = gsonBuilder.create();
            TypeToken<List<Marker>> collectionType = new TypeToken<List<Marker>>(){};
            this.markers = (List)gson.fromJson(json, collectionType.getType());
            log.info("Loaded " + this.markers.size() + " markers");
            this.cropsBlocks = blocksRegistry.getBlockDataId("corn-rows.blocks");
            this.houseBlocks = blocksRegistry.getBlockDataId("lg-farmhouse.blocks");
            this.canopyBlocks = blocksRegistry.getBlockDataId("stone-canopy.blocks");
            this.towerBlocks = blocksRegistry.getBlockDataId("single-tower.blocks");
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file:" + file, e);
        }
    }

    protected boolean intersects(TileId tileId, Vec3i world, int xSize, int zSize) {
        Vec3i origin = tileId.getWorld(null);
        int xMin = world.x - origin.x;
        int zMin = world.z - origin.z;
        int xMax = xMin + xSize;
        int zMax = zMin + zSize;
        if (xMax < 0 || zMax < 0) {
            return false;
        }
        return xMin < 1024 && zMin < 1024;
    }

    protected List<BlockInsert> getFarmInserts(Marker m, Vec3i origin, Tile tile, TerrainImage terrain, UsedSpaces used, boolean debug) {
        ArrayList<BlockInsert> results = new ArrayList<BlockInsert>();
        int carveFlags = 2;
        Vec3i size = this.blocksRegistry.getSize(this.cropsBlocks);
        Vec3i houseSize = this.blocksRegistry.getSize(this.houseBlocks);
        int spread = 1024 / tile.getResolution().getSamples();
        Vec3i farmLoc = m.getLocation().subtract(128, 0, 128);
        log.info("farmLoc:" + farmLoc);
        int xMin = Math.max(origin.x, farmLoc.x);
        int zMin = Math.max(origin.z, farmLoc.z);
        int xMax = Math.min(origin.x + 1024, farmLoc.x + 256);
        int zMax = Math.min(origin.z + 1024, farmLoc.z + 256);
        if (debug) {
            log.info("min:" + xMin + ", " + zMin + "  max:" + xMax + ", " + zMax + "  in tile:" + origin);
        }
        for (int x = xMin; x < xMax; x += 8) {
            for (int z = zMin; z < zMax; z += 8) {
                int i = (x - origin.x) / spread;
                int j = (z - origin.z) / spread;
                int ui = (x - origin.x) / 8;
                int uj = (z - origin.z) / 8;
                if (used.used[ui][uj]) continue;
                ((UsedSpaces)used).used[ui][uj] = true;
                short y = terrain.getElevation(i, j);
                short yn = terrain.getElevation(i + 7, j + 7);
                if (yn < y || yn > y + 1 || (yn = terrain.getElevation(i, j + 7)) < y || yn > y + 1 || (yn = terrain.getElevation(i + 7, j)) < y || yn > y + 1) continue;
                Vec3i loc = origin.add(i * spread, 0, j * spread);
                loc.y = y;
                --loc.y;
                results.add(new BlockInsert(loc, this.cropsBlocks, carveFlags, size.x, size.y, size.z, true, 1, -1L));
            }
        }
        return results;
    }

    public void accept(Tile tile) {
        InsertLayer inserts = (InsertLayer)tile.get(InsertLayer.class);
        if (inserts == null) {
            inserts = new InsertLayer(tile.getTileId(), new DataVersion(0L, -1L));
            tile.put(InsertLayer.class, (Object)inserts);
        } else if (inserts.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        Vec3i origin = tile.getTileId().getWorld(null);
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        UsedSpaces usedSpaces = (UsedSpaces)tile.get(UsedSpaces.class);
        if (usedSpaces == null) {
            log.info("Creating 'UsedSpaces' for tile:" + tile);
            usedSpaces = new UsedSpaces();
            tile.put(UsedSpaces.class, (Object)usedSpaces);
        }
        this.checkSpawn(this.spawnLoc, tile, inserts, terrain);
        this.checkSpawn(this.fakeSpawnLoc, tile, inserts, terrain);
        log.info("accept(" + origin + ")");
        for (Marker m : this.markers) {
            Vec3i size;
            Vec3i loc;
            if (!this.intersects(tile.getTileId(), m.getLocation().subtract(128, 0, 128), 256, 256)) continue;
            boolean debug = m.getLocation().equals((Object)new Vec3i(22400, 134, -3968));
            if (m.getType() >= 99) {
                if (!this.intersects(tile.getTileId(), m.getLocation().subtract(128, 0, 128), 256, 256)) continue;
                loc = m.getLocation().subtract(7, 0, 7);
                if (this.intersects(tile.getTileId(), loc, 14, 14)) {
                    int carveFlags = 2;
                    size = this.blocksRegistry.getSize(this.houseBlocks);
                    --loc.y;
                    inserts.addInsert(new BlockInsert(loc, this.houseBlocks, carveFlags, size.x, size.y, size.z, true, 1, -1L));
                }
                for (BlockInsert insert : this.getFarmInserts(m, origin, tile, terrain, usedSpaces, debug)) {
                    inserts.addInsert(insert);
                }
                continue;
            }
            loc = m.getLocation().subtract(4, 0, 4);
            if (this.intersects(tile.getTileId(), loc, 9, 9)) {
                int carveFlags = 2;
                size = this.blocksRegistry.getSize(this.canopyBlocks);
                inserts.addInsert(new BlockInsert(loc, this.canopyBlocks, carveFlags, size.x, size.y, size.z, true, 1, -1L));
            }
            loc = m.getLocation().add(16, 0, 32);
            loc.y = (int)this.fractal.getElevation(loc.x, loc.z);
            if (this.intersects(tile.getTileId(), loc, 8, 8)) {
                int carveFlags = 2;
                size = this.blocksRegistry.getSize(this.towerBlocks);
                inserts.addInsert(new BlockInsert(loc, this.towerBlocks, carveFlags, size.x, size.y, size.z, true, 1, -2L));
            }
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0) continue;
                    Vec3i base = m.getLocation().add(x * 128, 0, z * 128);
                    Vec3i p = base.clone();
                    int y = (int)this.fractal.getElevation(p.x, p.z);
                    if (debug) {
                        log.info("  p:" + p + "  y:" + y);
                    }
                    if (y >= 124) continue;
                    if (debug) {
                        log.info("    port offset:" + x + ", " + z);
                    }
                    for (int i = 0; i < 16; ++i) {
                        Vec3i local = base.add(-x * i * 8, 0, -z * i * 8);
                        int check = (int)this.fractal.getElevation(local.x, local.z);
                        if (debug) {
                            log.info("      base:" + base + ".add(" + -x * i * 8 + ", 0, " + -z * i * 8 + ")");
                            log.info("      check:" + local + " = " + check);
                        }
                        if (check >= 124) break;
                        p.x = local.x;
                        p.z = local.z;
                    }
                    BlockDataId blockDataId = this.blocksRegistry.getBlockDataId("docks-t.blocks");
                    int carveFlags = 2;
                    Vec3i size2 = this.blocksRegistry.getSize(blockDataId);
                    p.subtractLocal(6, 0, 6);
                    p.y = 126;
                    if (!this.intersects(tile.getTileId(), p, size2.x, size2.z)) continue;
                    inserts.addInsert(new BlockInsert(p, blockDataId, carveFlags, size2.x, size2.y, size2.z, true, 1, -1L));
                }
            }
        }
    }

    protected void checkSpawn(Vec3i spawn, Tile tile, InsertLayer inserts, TerrainImage terrain) {
        Vec3i size = this.getSpawnSize();
        Vec3i loc = spawn.subtract(4, 1, 4);
        if (!this.intersects(tile.getTileId(), loc, size.x, size.z)) {
            return;
        }
        Vec3i origin = tile.getTileId().getWorld(null);
        Vec3i relative = loc.subtract(origin);
        TestBlockRegistry.BuildingFactory factory = this.blocksRegistry.getSpawnTower();
        BlockDataId blockDataId = this.blocksRegistry.findFirst(factory.name);
        int carveFlags = 2;
        BlockInsert spawnInsert = new BlockInsert(loc, blockDataId, carveFlags, size.x, size.y, size.z, factory.aboveGround, factory.groundLevel, -1L);
        inserts.addInsert(spawnInsert);
    }

    protected Vec3i getSpawnSize() {
        if (this.spawnSize != null) {
            return this.spawnSize;
        }
        TestBlockRegistry.BuildingFactory factory = this.blocksRegistry.getSpawnTower();
        BlockDataId blockDataId = this.blocksRegistry.findFirst(factory.name);
        BlockData data = this.blocksRegistry.apply(blockDataId);
        int xSize = data.getCells().getSizeX();
        int ySize = data.getCells().getSizeY();
        int zSize = data.getCells().getSizeZ();
        return new Vec3i(xSize, ySize, zSize);
    }

    private static class UsedSpaces {
        private boolean[][] used = new boolean[128][128];
        private int[][] elevation = new int[128][128];

        private UsedSpaces() {
        }
    }
}

