/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.WatchedEntity;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.Axis;
import com.simsilica.lemur.input.Button;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.TimeState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.BlockTypeSelectionState;
import mythruna.client.view.CreatorManipulator;
import mythruna.client.view.DiggerManipulator;
import mythruna.client.view.HandManipulator;
import mythruna.client.view.ManipulatorType;
import mythruna.client.view.ModelViewState;
import mythruna.client.view.SwingManipulator;
import mythruna.client.view.WorldMarkerState;
import mythruna.es.Holding;
import mythruna.es.ObjectFocus;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationInputState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ActivationInputState.class);
    public static final String GROUP_ACTIVATION = "Activation";
    public static final FunctionId F_PRIMARY = new FunctionId("Activation", "Primary");
    public static final FunctionId F_PRIMARY_ALT = new FunctionId("Activation", "Primary Alt");
    public static final FunctionId F_SECONDARY = new FunctionId("Activation", "Secondary");
    public static final FunctionId F_SECONDARY_ALT = new FunctionId("Activation", "Secondary Alt");
    public static final FunctionId F_PRIMARY_SELECTOR = new FunctionId("Activation", "Primary Sel.");
    public static final FunctionId F_SECONDARY_SELECTOR = new FunctionId("Activation", "Secondary Sel.");
    public static final FunctionId F_PRIMARY_SELECTOR_KEYS = new FunctionId("Activation", "Primary Sel. Keys");
    public static final FunctionId F_SECONDARY_SELECTOR_KEYS = new FunctionId("Activation", "Secondary Sel. Keys");
    private EntityData ed;
    private EntityId avatarId;
    private GameSession session;
    private ActivationHandler activationHandler = new ActivationHandler();
    private SessionObserver sessionObserver = new SessionObserver();
    private TimeState time;
    private Node cursor;
    private Geometry cursorGeom;
    private int size = 24;
    private ColorRGBA cursorColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private VersionedReference<Vec3d> cameraPosRef;
    private VersionedReference<Quatd> cameraFacingRef;
    private WatchedEntity mainHand;
    private Holding mainHolding;
    private ManipulatorType mainManipulator;
    private WatchedEntity mainItem;
    private ObjectFocus mainFocus;
    private FocusView focusView;
    private Label focusLabel;
    private float labelScale = 1.5f;
    private Geometry unitCube;
    private CellArray focusCells = new CellArray(1, 1, 1);
    private CellArray focusLights = new CellArray(1, 1, 1);
    private Map<EntityId, Spatial> spatialCache = new HashMap<EntityId, Spatial>();

    protected Node getGuiNode() {
        return ((SimpleApplication)this.getApplication()).getGuiNode();
    }

    protected void initialize(Application app) {
        int timeIndex = 0;
        long start = System.nanoTime();
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.time = (TimeState)this.getState(TimeState.class, true);
        this.cameraPosRef = ((AvatarState)this.getState(AvatarState.class, true)).createEyePositionReference();
        this.cameraFacingRef = ((AvatarState)this.getState(AvatarState.class, true)).createCameraOrientationReference();
        this.focusView = new FocusView(app.getCamera());
        long end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.focusView.setLocalScale(0.018f);
        this.focusLabel = new Label("(0) Unknown", new ElementId("focus.label"));
        this.focusLabel.setColor(ColorRGBA.White);
        this.focusLabel.setShadowColor(ColorRGBA.Black);
        this.focusLabel.setLocalScale(this.labelScale);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        sessionState.addGameSessionListener((GameSessionListener)this.sessionObserver);
        this.session = sessionState.getGameSession();
        this.avatarId = this.session.getAvatar();
        GuiGlobals globals = GuiGlobals.getInstance();
        InputMapper inputMapper = globals.getInputMapper();
        inputMapper.map(F_PRIMARY, Button.MOUSE_BUTTON1, new Object[0]);
        inputMapper.map(F_PRIMARY_ALT, Button.MOUSE_BUTTON2, new Object[0]);
        inputMapper.map(F_SECONDARY, Button.MOUSE_BUTTON1, new Object[]{29});
        inputMapper.map(F_SECONDARY, Button.MOUSE_BUTTON1, new Object[]{157});
        inputMapper.map(F_SECONDARY_ALT, Button.MOUSE_BUTTON2, new Object[]{29});
        inputMapper.map(F_SECONDARY_ALT, Button.MOUSE_BUTTON2, new Object[]{157});
        inputMapper.map(F_PRIMARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[0]);
        inputMapper.map(F_PRIMARY_SELECTOR_KEYS, 52, new Object[0]);
        inputMapper.map(F_PRIMARY_SELECTOR_KEYS, InputState.Negative, 51, new Object[0]);
        inputMapper.map(F_SECONDARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[]{29});
        inputMapper.map(F_SECONDARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[]{157});
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        float quadSize = (float)this.size * 4.0f / 3.0f;
        Quad quad = new Quad(quadSize, quadSize);
        Texture texture = globals.loadTexture("Interface/glass-orb-dark-48.png", false, false);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.cursorGeom = new Geometry("cursor", (Mesh)quad);
        Material mat = globals.createMaterial(texture, false).getMaterial();
        mat.setColor("Color", this.cursorColor);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.cursorGeom.setMaterial(mat);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.cursor = new Node("cursor");
        this.cursorGeom.center();
        this.cursor.attachChild((Spatial)this.cursorGeom);
        float scale = (float)app.getCamera().getHeight() / 900.0f;
        this.cursor.setLocalScale(scale);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.unitCube = new Geometry("unitCube", (Mesh)new Box(0.5f, 0.5f, 0.5f));
        mat = globals.createMaterial(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f), false).getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Front);
        this.unitCube.setMaterial(mat);
        this.unitCube.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.unitCube.move(0.5f, 0.5f, 0.5f);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        int timeIndex = 0;
        long start = System.nanoTime();
        this.resetCursorPosition();
        this.getGuiNode().attachChild((Spatial)this.cursor);
        this.focusView.updateCamera();
        long end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.focusView);
        ((GuiState)this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.focusLabel);
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        log.info("cursor size:" + this.cursor.getWorldBound() + "  cursor scale:" + this.cursor.getWorldScale());
        this.mainHand = this.ed.watchEntity(this.avatarId, new Class[]{Holding.class});
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.setMainManipulator((Holding)this.mainHand.get(Holding.class));
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.updateFocusLabel();
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup(GROUP_ACTIVATION);
        inputMapper.addDelegate(F_PRIMARY, (Object)this.activationHandler, "setPrimary", true);
        inputMapper.addDelegate(F_PRIMARY_ALT, (Object)this.activationHandler, "setPrimaryAlt", true);
        inputMapper.addDelegate(F_SECONDARY, (Object)this.activationHandler, "setSecondary", true);
        inputMapper.addDelegate(F_SECONDARY_ALT, (Object)this.activationHandler, "setSecondaryAlt", true);
        inputMapper.addDelegate(F_PRIMARY_SELECTOR_KEYS, (Object)this.activationHandler, "changePrimary", true);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.activationHandler, new FunctionId[]{F_PRIMARY_SELECTOR, F_SECONDARY_SELECTOR});
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
    }

    public void update(float tpf) {
        if (this.mainHand.applyChanges()) {
            this.setMainManipulator((Holding)this.mainHand.get(Holding.class));
        }
        if (this.mainItem != null && this.mainItem.applyChanges()) {
            this.setMainFocus((ObjectFocus)this.mainItem.get(ObjectFocus.class));
        }
        boolean viewChanged = false;
        if (this.cameraFacingRef.update()) {
            viewChanged = true;
        }
        if (this.cameraPosRef.update()) {
            viewChanged = true;
        }
        if (viewChanged) {
            if (this.mainManipulator != null) {
                this.mainManipulator.viewChanged((Vec3d)this.cameraPosRef.get(), (Quatd)this.cameraFacingRef.get());
            }
        } else if (this.mainManipulator != null) {
            this.mainManipulator.update(tpf);
        }
    }

    protected void onDisable() {
        this.cursor.removeFromParent();
        this.focusView.removeFromParent();
        this.focusLabel.removeFromParent();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup(GROUP_ACTIVATION);
        inputMapper.removeDelegate(F_PRIMARY, (Object)this.activationHandler, "setPrimary");
        inputMapper.removeDelegate(F_PRIMARY_ALT, (Object)this.activationHandler, "setPrimaryAlt");
        inputMapper.removeDelegate(F_SECONDARY, (Object)this.activationHandler, "setSecondary");
        inputMapper.removeDelegate(F_SECONDARY_ALT, (Object)this.activationHandler, "setSecondaryAlt");
        inputMapper.removeDelegate(F_PRIMARY_SELECTOR_KEYS, (Object)this.activationHandler, "changePrimary");
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.activationHandler, new FunctionId[]{F_PRIMARY_SELECTOR, F_SECONDARY_SELECTOR});
    }

    protected void setMainManipulator(Holding holding) {
        String type;
        EntityId target;
        if (Objects.equals(this.mainHolding, holding)) {
            return;
        }
        if (holding != null) {
            log.info("setMainManipulator(" + holding.toString(this.ed) + ")");
        }
        if (this.mainManipulator != null) {
            this.mainManipulator.setTarget(null);
            this.mainItem.release();
        }
        this.mainHolding = holding;
        EntityId blockTool = null;
        if (this.mainHolding == null) {
            target = this.avatarId;
            type = "Hand";
        } else {
            target = holding.getTarget();
            type = holding.getManipulatorTypeName(this.ed);
        }
        if ("Digger".equals(type)) {
            this.mainManipulator = new DiggerManipulator(((GameSessionState)this.getState(GameSessionState.class)).getWorld(), (WorldMarkerState)this.getState(WorldMarkerState.class), this.session, (AvatarState)this.getState(AvatarState.class)){

                @Override
                public void change(int delta) {
                    ((BlockTypeSelectionState)ActivationInputState.this.getState(BlockTypeSelectionState.class)).adjustRotation(delta);
                    super.change(delta);
                }
            };
            blockTool = target;
        } else if ("Creator".equals(type)) {
            this.mainManipulator = new CreatorManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class));
        } else if ("Hand".equals(type)) {
            this.mainManipulator = new HandManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class));
        } else if ("Swing".equals(type)) {
            HandManipulator hand = new HandManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class));
            this.mainManipulator = new SwingManipulator((AvatarState)this.getState(AvatarState.class), hand);
        } else {
            log.error("Current equipped object has no manipulator type:" + target);
            this.mainManipulator = new HandManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class));
        }
        ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).setTool(blockTool);
        this.mainManipulator.setTarget(target);
        this.mainItem = this.ed.watchEntity(target, new Class[]{ObjectFocus.class});
        this.setMainFocus((ObjectFocus)this.mainItem.get(ObjectFocus.class), true);
    }

    public void setMainFocus(ObjectFocus focus) {
        this.setMainFocus(focus, false);
    }

    protected void setMainFocus(ObjectFocus focus, boolean forceUpdate) {
        if (!forceUpdate && Objects.equals(this.mainFocus, focus)) {
            return;
        }
        log.info("Main focus:" + focus);
        this.mainFocus = focus;
        if (this.mainFocus == null) {
            this.focusView.setFocus(null);
            this.focusLabel.setText("");
            return;
        }
        if (focus.isEntity()) {
            EntityId id = focus.getEntityId();
            Spatial existing = this.spatialCache.get(id);
            if (existing != null) {
                this.setFocusSpatial(existing);
            } else {
                ((ModelViewState)this.getState(ModelViewState.class)).createSpatial(id, spatial -> {
                    this.setFocusSpatial((Spatial)spatial);
                    this.spatialCache.put(id, (Spatial)spatial);
                });
            }
        } else if (focus.isBlockType()) {
            int val = MaskUtils.setSideMask((int)Math.max(0, (int)focus.getId()), (int)63);
            this.focusCells.setCell(0, 0, 0, val);
            this.focusLights.setCell(0, 0, 0, LightUtils.DIRECT_SUN);
            GeometryFactory geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getGeometryFactory();
            Node indicator = new Node("indicator");
            Node blocks = geomFactory.generateBlocks(indicator, this.focusCells, (CellData)this.focusLights, false);
            blocks.attachChild((Spatial)this.unitCube);
            this.focusView.setFocus((Spatial)blocks);
            BlockType bt = BlockTypeIndex.get((int)((int)focus.getId()));
            if (bt != null) {
                this.focusLabel.setText(String.valueOf(bt.getName()));
            } else {
                this.focusLabel.setText("Unknown");
            }
        } else {
            this.focusView.setFocus(null);
            this.focusLabel.setText("");
            throw new UnsupportedOperationException("Uknonwn focus type:" + focus);
        }
        this.updateFocusLabel();
    }

    protected void setFocusSpatial(Spatial spatial) {
        this.focusView.setFocus(spatial);
        String name = (String)spatial.getUserData("objectName");
        if (name != null) {
            this.focusLabel.setText(name);
        } else {
            this.focusLabel.setText("Unknown");
        }
        this.updateFocusLabel();
    }

    protected void updateFocusLabel() {
        Vector3f pref = this.focusLabel.getPreferredSize().mult(this.labelScale);
        Vector2f size = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getGuiSize();
        this.focusLabel.setLocalTranslation(size.x * 0.5f - pref.x * 0.5f, 5.0f + pref.y, 0.0f);
    }

    protected void resetCursorPosition() {
        int width = this.getApplication().getCamera().getWidth();
        int height = this.getApplication().getCamera().getHeight();
        this.cursor.setLocalTranslation((float)width * 0.5f, (float)height * 0.5f, 0.0f);
    }

    public class ActivationHandler
    implements AnalogFunctionListener {
        private InputState previousPrimary;

        public void setPrimary(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.mainManipulator.activate(pressed);
        }

        public void setPrimaryAlt(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.mainManipulator.altActivate(pressed);
        }

        public void setSecondary(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.session.executeCommand("activateSecondary", ActivationInputState.this.avatarId, new Object[]{pressed});
        }

        public void setSecondaryAlt(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.session.executeCommand("activateSecondaryAlt", ActivationInputState.this.avatarId, new Object[]{pressed});
        }

        public void changePrimary(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            log.info("changePrimary(" + state + ")");
            if (state != this.previousPrimary) {
                this.previousPrimary = state;
                ActivationInputState.this.mainManipulator.change(state.asNumber());
            }
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            if (func == F_PRIMARY_SELECTOR) {
                ActivationInputState.this.mainManipulator.change((int)value);
            }
        }
    }

    private class SessionObserver
    extends DefaultGameSessionListener {
        private SessionObserver() {
        }

        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
        }
    }

    private class FocusView
    extends Node {
        private Camera cam;
        private Vector3f offset;
        private float project;
        private float yOffset;
        private float effectiveHeight;
        private Spatial focus;
        private double baseRadius;
        private Geometry test;

        public FocusView(Camera cam) {
            super("focus");
            this.offset = new Vector3f();
            this.project = 0.25f;
            this.yOffset = 0.0f;
            this.effectiveHeight = 60.0f;
            this.baseRadius = Math.sqrt(0.75);
            this.cam = cam;
            this.updateCamera();
        }

        protected double getRadius(BoundingVolume bounds) {
            if (bounds instanceof BoundingSphere) {
                float radius = ((BoundingSphere)bounds).getRadius();
                return Math.sqrt(radius * radius + radius * radius + radius * radius);
            }
            if (bounds instanceof BoundingBox) {
                Vector3f extent = ((BoundingBox)bounds).getExtent(null);
                return Math.sqrt(extent.x * extent.x + extent.y * extent.y + extent.z * extent.z);
            }
            return this.baseRadius;
        }

        public void setFocus(Spatial focus) {
            if (this.focus == focus) {
                return;
            }
            if (this.focus != null) {
                this.focus.removeFromParent();
            }
            this.focus = focus;
            if (this.focus != null) {
                focus.removeFromParent();
                focus.setLocalScale(1.0f);
                BoundingVolume bounds = focus.getWorldBound();
                double radius = this.getRadius(bounds);
                float scale = (float)(this.baseRadius / radius);
                focus.setLocalScale(scale);
                focus.center();
                this.attachChild(focus);
            }
        }

        public void updateCamera() {
            double fov = Math.toRadians(this.cam.getFov());
            double cos = Math.cos(fov * 0.5);
            double h = (double)this.project / cos;
            double y = Math.sin(fov * 0.5) * h;
            double halfScreen = (double)this.cam.getHeight() * 0.5;
            double ratio = (double)this.effectiveHeight / halfScreen;
            if (halfScreen < 450.0) {
                ratio *= halfScreen / 450.0;
            }
            double height = y * ratio;
            this.yOffset = (float)(-y + height);
            float scale = (float)height;
            this.setLocalScale(scale);
        }

        public void updateLogicalState(float tpf) {
            super.updateLogicalState(tpf);
            this.offset.set(this.cam.getLocation());
            this.offset.addLocal(this.cam.getDirection().mult(this.project));
            this.offset.addLocal(this.cam.getUp().mult(this.yOffset));
            this.setLocalTranslation(this.offset);
        }
    }
}

