/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.net.AccountEvent;
import mythruna.net.DataSession;
import mythruna.net.DataSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSessionHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(DataSessionHostedService.class);
    private RmiHostedService rmiService;
    private byte channel;
    private DataSessionImpl session = new DataSessionImpl();

    public DataSessionHostedService(int channel) {
        this.channel = (byte)channel;
        this.setAutoHost(false);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("DataSessionHostedService requires an RMI service.");
        }
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
        EventBus.removeListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
    }

    protected void accountLoggedOn(AccountEvent event) {
        log.info("accountLoggedOn(" + event + ")");
        HostedConnection conn = event.getConnection();
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((Object)new DataSessionImpl(), DataSession.class);
        DataSessionListener listener = (DataSessionListener)rmi.getRemoteObject(DataSessionListener.class);
        if (listener == null) {
            throw new RuntimeException("Unable to locate client callback for DataSessionListener");
        }
        listener.dataAvailable();
    }

    protected void accountLoggedOff(AccountEvent event) {
        log.info("accountLoggedOff(" + event + ")");
    }

    private class DataSessionImpl
    implements DataSession {
        private DataSessionImpl() {
        }

        @Override
        public FabricTypeData getFabricTypeData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getFabricTypeDataBytes() {
            log.info("getFabricTypeDataBytes():" + this);
            try {
                byte[] result = FabricTypeData.toBytes(FabricTypeIndex.toData());
                log.info("returning " + result.length + " bytes");
                byte[] byArray = result;
                return byArray;
            }
            finally {
                log.info("done getFabricTypeDataBytes()");
            }
        }

        @Override
        public SwatchShapeData getSwatchShapeData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getSwatchShapeDataBytes() {
            log.info("getSwatchShapeDataBytes()");
            return SwatchShapeData.toBytes(SwatchShapeIndex.toData());
        }
    }
}

