/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.material;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.TextureKey;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.PlaceholderAssets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FbxImage
extends FbxObject {
    private static final Logger logger = Logger.getLogger(FbxImage.class.getName());
    protected TextureKey key;
    protected String type;
    protected String filePath;
    protected String relativeFilePath;
    protected byte[] content;

    public FbxImage(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        this.type = element.propertiesTypes.length == 3 ? (String)element.properties.get(2) : (String)element.properties.get(1);
        if (this.type.equals("Clip")) {
            for (FbxElement e : element.children) {
                byte[] storedContent;
                if (e.id.equals("Type")) {
                    this.type = (String)e.properties.get(0);
                    continue;
                }
                if (e.id.equals("FileName")) {
                    this.filePath = (String)e.properties.get(0);
                    continue;
                }
                if (e.id.equals("RelativeFilename")) {
                    this.relativeFilePath = (String)e.properties.get(0);
                    continue;
                }
                if (!e.id.equals("Content") || e.properties.size() <= 0 || (storedContent = (byte[])e.properties.get(0)).length <= 0) continue;
                this.content = storedContent;
            }
        }
    }

    private Image loadImageSafe(AssetManager assetManager, TextureKey texKey) {
        try {
            return assetManager.loadTexture(texKey).getImage();
        }
        catch (AssetNotFoundException ex) {
            return null;
        }
        catch (AssetLoadException ex) {
            logger.log(Level.WARNING, "Error when loading image: " + texKey, ex);
            return null;
        }
    }

    private static String getFileName(String filePath) {
        int fwdSlashIdx = filePath.lastIndexOf("\\");
        int bkSlashIdx = filePath.lastIndexOf("/");
        if (fwdSlashIdx != -1) {
            filePath = filePath.substring(fwdSlashIdx + 1);
        } else if (bkSlashIdx != -1) {
            filePath = filePath.substring(bkSlashIdx + 1);
        }
        return filePath;
    }

    public TextureKey getTextureKey() {
        return this.key;
    }

    protected Object toJmeObject() {
        Image image = null;
        String fileName = null;
        if (this.filePath != null) {
            fileName = FbxImage.getFileName(this.filePath);
        } else if (this.relativeFilePath != null) {
            fileName = FbxImage.getFileName(this.relativeFilePath);
        }
        if (fileName != null) {
            try {
                this.key = new TextureKey(this.sceneFolderName + fileName);
                this.key.setGenerateMips(true);
                image = this.loadImageSafe(this.assetManager, this.key);
                if (image == null && this.relativeFilePath != null) {
                    String relativeFilePathJme = this.relativeFilePath.replace('\\', '/');
                    this.key = new TextureKey(this.sceneFolderName + relativeFilePathJme);
                    this.key.setGenerateMips(true);
                    image = this.loadImageSafe(this.assetManager, this.key);
                }
                if (image == null && this.content != null && this.content.length > 0) {
                    this.key = new TextureKey(fileName);
                    this.key.setGenerateMips(true);
                    ByteArrayInputStream is = new ByteArrayInputStream(this.content);
                    image = ((Texture)this.assetManager.loadAssetFromStream((AssetKey)this.key, (InputStream)is)).getImage();
                    this.key = null;
                }
            }
            catch (AssetLoadException ex) {
                logger.log(Level.WARNING, "Error while attempting to load texture {0}:\n{1}", new Object[]{this.name, ex.toString()});
            }
        }
        if (image == null) {
            logger.log(Level.WARNING, "Cannot locate {0} for texture {1}", new Object[]{fileName, this.name});
            image = PlaceholderAssets.getPlaceholderImage((AssetManager)this.assetManager);
        }
        return image;
    }

    @Override
    public void connectObject(FbxObject object) {
        this.unsupportedConnectObject(object);
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        this.unsupportedConnectObjectProperty(object, property);
    }
}

