/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.base;

import com.simsilica.mworld.LeafChangeEvent;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafId;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafChangeListenerSupport {
    static Logger log = LoggerFactory.getLogger(LeafChangeListenerSupport.class);
    private List<LeafChangeListener> leafListeners = new ArrayList<LeafChangeListener>();
    private LeafChangeListener[] leafListenerArray;
    private static LeafChangeListener[] emptyLeafListenerArray = new LeafChangeListener[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LeafChangeListener l) {
        List<LeafChangeListener> list = this.leafListeners;
        synchronized (list) {
            this.leafListeners.add(l);
            this.leafListenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(LeafChangeListener l) {
        List<LeafChangeListener> list = this.leafListeners;
        synchronized (list) {
            this.leafListeners.remove(l);
            this.leafListenerArray = null;
        }
    }

    protected LeafChangeListener[] getArray() {
        if (this.leafListenerArray == null) {
            this.leafListenerArray = this.leafListeners.toArray(emptyLeafListenerArray);
        }
        return this.leafListenerArray;
    }

    public void fireLeafChanged(LeafId leafId, long version) {
        if (this.leafListeners.isEmpty()) {
            return;
        }
        LeafChangeEvent event = new LeafChangeEvent(leafId, version);
        this.fireLeafChanged(event);
    }

    public void fireLeafChanged(LeafChangeEvent event) {
        for (LeafChangeListener l : this.getArray()) {
            l.leafChanged(event);
        }
    }
}

