/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.encounter;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.LeafData;
import mythruna.sim.encounter.CellStats;
import mythruna.sim.encounter.CellStatsInitializer;
import mythruna.sim.encounter.RandomLocation;
import mythruna.sim.encounter.Zone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomLocations {
    static Logger log = LoggerFactory.getLogger(RandomLocations.class);

    public static RandomLocation grass() {
        return new GrassLocations();
    }

    public static RandomLocation leaves() {
        return new LeafLocations();
    }

    public static class GrassLocations
    implements RandomLocation {
        @Override
        public boolean hasLocations(Zone zone) {
            return zone.get(CellStats.class).grassBlocks > 0;
        }

        @Override
        public Vec3i findLocation(Zone zone) {
            CellStats stats = zone.get(CellStats.class);
            int skip = (int)(Math.random() * (double)stats.grassBlocks);
            LeafData blocks = zone.get(LeafData.class);
            for (int i = 0; i < 32; ++i) {
                for (int k = 0; k < 32; ++k) {
                    for (int j = 0; j < 32; ++j) {
                        int type;
                        int val = blocks.getCell(i, j, k);
                        if (val == 0 || !CellStatsInitializer.isGrassBlock(type = MaskUtils.getType((int)val)) || --skip > 0) continue;
                        return zone.getZoneId().getWorld(null).add(i, j, k);
                    }
                }
            }
            return null;
        }
    }

    public static class LeafLocations
    implements RandomLocation {
        @Override
        public boolean hasLocations(Zone zone) {
            return zone.get(CellStats.class).leafBlocks > 0;
        }

        @Override
        public Vec3i findLocation(Zone zone) {
            CellStats stats = zone.get(CellStats.class);
            int skip = (int)(Math.random() * (double)stats.leafBlocks);
            LeafData blocks = zone.get(LeafData.class);
            for (int i = 0; i < 32; ++i) {
                for (int k = 0; k < 32; ++k) {
                    for (int j = 0; j < 32; ++j) {
                        int type;
                        int val = blocks.getCell(i, j, k);
                        if (val == 0 || !CellStatsInitializer.isLeafBlock(type = MaskUtils.getType((int)val)) || --skip > 0) continue;
                        return zone.getZoneId().getWorld(null).add(i, j, k);
                    }
                }
            }
            return null;
        }
    }
}

