/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tree;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.tree.AbstractTreeType;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.TileColumnCells;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.io.Serializable;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PineTreeType
extends AbstractTreeType
implements Serializable {
    static Logger log = LoggerFactory.getLogger(PineTreeType.class);
    static final long serialVersionUID = 42L;
    private static final int RADIUS = 3;
    private static final int WIDTH = 7;
    private static final int[][][] layers = new int[][][]{new int[][]{{0, 0, 0, 5, 0, 0, 0}, {0, 4, 4, 5, 6, 6, 0}, {0, 4, 4, 5, 6, 6, 0}, {3, 3, 3, 9, 7, 7, 7}, {0, 2, 2, 1, 8, 8, 0}, {0, 2, 2, 1, 8, 8, 0}, {0, 0, 0, 1, 0, 0, 0}}, new int[][]{{0, 0, 0, 5, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 4, 4, 5, 6, 6, 0}, {3, 3, 3, 9, 7, 7, 7}, {0, 2, 2, 1, 8, 8, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 1, 0, 0, 0}}, new int[][]{{0, 0, 0, 5, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 4, 4, 5, 6, 6, 0}, {3, 3, 3, 9, 7, 7, 7}, {0, 2, 2, 1, 8, 8, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 1, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 4, 4, 5, 6, 6, 0}, {0, 3, 3, 9, 7, 7, 0}, {0, 2, 2, 1, 8, 8, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 4, 4, 5, 6, 6, 0}, {0, 3, 3, 9, 7, 7, 0}, {0, 2, 2, 1, 8, 8, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 5, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 3, 3, 10, 7, 7, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 5, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 3, 3, 10, 7, 7, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 0, 3, 10, 7, 0, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 4, 5, 6, 0, 0}, {0, 0, 3, 10, 7, 0, 0}, {0, 0, 2, 1, 8, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 5, 0, 0, 0}, {0, 0, 3, 10, 7, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 5, 0, 0, 0}, {0, 0, 3, 10, 7, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}};
    private int[][] footprint = new int[][]{{0, 0, 2, 2, 2, 0, 0}, {0, 2, 4, 4, 4, 2, 0}, {2, 4, 6, 6, 6, 4, 2}, {2, 4, 6, 15, 6, 4, 2}, {2, 4, 6, 6, 6, 4, 2}, {0, 2, 4, 4, 4, 2, 0}, {0, 0, 2, 2, 2, 0, 0}};
    private int footprintSize = 7;
    private int footprintOffset = 3;
    private int baseTrunkHeight = 1;
    private int randomTrunkHeight = 4;
    private int baseCanopyHeight = 3;
    private int randomCanopyHeight = 12;
    private int typeTop;
    private int[] parts;

    public PineTreeType(String name, AtlasCell atlasCell) {
        this(name, atlasCell, 1, 4, 3, 12);
    }

    public PineTreeType(String name, AtlasCell atlasCell, int baseTrunkHeight, int randomTrunkHeight, int baseCanopyHeight, int randomCanopyHeight) {
        super(name, atlasCell);
        this.baseTrunkHeight = baseTrunkHeight;
        this.randomTrunkHeight = randomTrunkHeight;
        this.baseCanopyHeight = baseCanopyHeight;
        this.randomCanopyHeight = randomCanopyHeight;
    }

    public void initialize(TreeTypeIndex treeTypes) {
        this.parts = new int[]{0, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(0))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(1))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(1))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(2))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(2))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(3))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch", Integer.valueOf(3))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("pine", "branch45", Integer.valueOf(0))) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl")) | TREE_BITS, BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl25")) | TREE_BITS, this.typeTop = BlockTypeIndex.findType((BlockName)new BlockName("pine", "top")) | TREE_BITS};
    }

    public Tree createTree(short x, short y, short z, TerrainImage terrain, Random rand) {
        int trunkHeight = rand.nextInt(this.randomTrunkHeight) + this.baseTrunkHeight;
        int canopyHeight = rand.nextInt(this.randomCanopyHeight) + this.baseCanopyHeight;
        int height = trunkHeight + canopyHeight;
        return new Tree(x, y, z, (byte)(height += 2), 3, (byte)trunkHeight, (TreeType)this);
    }

    private void addLayer(int[][] layer, int i, int j, int k, CellData cells, Random rand) {
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                int r = layer[z][x];
                if (r == 0) continue;
                int v = this.parts[r];
                cells.setCell(i + x - 3, j, k + z - 3, v);
            }
        }
    }

    public boolean markTree(Tree tree, boolean[][] used) {
        int i = tree.x - this.footprintOffset;
        int k = tree.z - this.footprintOffset;
        for (int x = 0; x < this.footprintSize; ++x) {
            for (int z = 0; z < this.footprintSize; ++z) {
                if (this.footprint[x][z] <= 0) continue;
                used[i + x][k + z] = true;
            }
        }
        return true;
    }

    public boolean insertTree(Tree tree, TileColumnCells cells, Random rand) {
        int y;
        int treeHeight = tree.height - 2;
        byte trunkHeight = tree.other;
        int canopyHeight = treeHeight - trunkHeight;
        float delta = (float)layers.length / (float)canopyHeight;
        float layer = 0.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
            layer = layers.length - canopyHeight;
        }
        int trunkType = layers[Math.round(layer)][3][3];
        trunkType = this.parts[trunkType];
        short i = tree.x;
        short j = tree.y;
        short k = tree.z;
        int start = tree.y;
        int end = tree.y + trunkHeight;
        for (y = start; y < end; ++y) {
            cells.setCell((int)i, y, (int)k, trunkType);
        }
        start = j + trunkHeight;
        end = j + treeHeight;
        for (y = start; y < end; ++y) {
            int index = Math.min(Math.round(layer), layers.length - 1);
            layer += delta;
            this.addLayer(layers[index], i, y, k, (CellData)cells, rand);
        }
        cells.setCell((int)i, j + treeHeight, (int)k, this.typeTop);
        return true;
    }

    public boolean insertTree(Tree tree, TerrainImage terrain) {
        int i = tree.x - this.footprintOffset;
        int k = tree.z - this.footprintOffset;
        for (int x = 0; x < this.footprintSize; ++x) {
            for (int z = 0; z < this.footprintSize; ++z) {
                if (this.footprint[x][z] == 0) continue;
                terrain.updateLight(i + x, k + z, (byte)(-this.footprint[x][z]));
            }
        }
        return true;
    }

    public boolean isBlock(Tree tree, int x, int y, int z, int type) {
        if (x < -tree.radius || z < -tree.radius) {
            return false;
        }
        if (x > tree.radius || z > tree.radius) {
            return false;
        }
        if (y < 0 || y > tree.height) {
            return false;
        }
        int treeHeight = tree.height - 2;
        byte trunkHeight = tree.other;
        int canopyHeight = treeHeight - trunkHeight;
        float delta = (float)layers.length / (float)canopyHeight;
        float layer = 0.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
            layer = layers.length - canopyHeight;
        }
        int trunkType = layers[Math.round(layer)][3][3];
        trunkType = this.parts[trunkType];
        if (y < trunkHeight) {
            if (x == 0 && z == 0) {
                return type == MaskUtils.getType((int)trunkType);
            }
            return false;
        }
        if (y == treeHeight) {
            if (x == 0 && z == 0) {
                return type == MaskUtils.getType((int)this.typeTop);
            }
            return false;
        }
        int index = Math.min(Math.round(layer += (float)(y - trunkHeight) * delta), layers.length - 1);
        int part = layers[index][z + 3][x + 3];
        if (part == 0) {
            return false;
        }
        return type == MaskUtils.getType((int)(part = this.parts[part]));
    }
}

