/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.state.CompositeAppState;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mythruna.client.GuiState;
import mythruna.client.ui.MapMarkerState;
import mythruna.client.ui.MapViewState;
import mythruna.client.ui.PropertyManagementState;
import mythruna.client.ui.bp.BlueprintEditorState;
import mythruna.client.ui.bp.BlueprintSelectorState;
import mythruna.client.ui.character.CharacterMenuState;
import mythruna.client.ui.clothing.ClothingEditorState;
import mythruna.client.ui.clothing.ClothingSelectorState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerMenuState
extends CompositeAppState {
    static Logger log = LoggerFactory.getLogger(PlayerMenuState.class);
    private Container window;
    private Container menu;
    private ColorRGBA selectedColor = new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f);
    private ColorRGBA unselectedColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    private Map<String, Submenu> submenus = new LinkedHashMap<String, Submenu>();
    private Map<Submenu, ActionButton> buttonIndex = new HashMap<Submenu, ActionButton>();
    private AppState selectedState;
    private MapMarkerState mapMarkers;

    public PlayerMenuState() {
        super(new AppState[0]);
        this.setEnabled(false);
    }

    public Action addSubmenu(String name, AppState state) {
        Submenu menu = new Submenu(name, state);
        this.submenus.put(name, menu);
        this.updateSubmenus();
        return menu;
    }

    protected void updateSubmenus() {
        if (this.menu == null) {
            return;
        }
        this.menu.clearChildren();
        for (Submenu sub : this.submenus.values()) {
            ActionButton button = new ActionButton((Action)sub);
            this.menu.addChild((Node)button, new Object[0]);
            this.buttonIndex.put(sub, button);
        }
    }

    protected void setSelectedState(AppState state) {
        if (this.selectedState == state) {
            return;
        }
        if (this.selectedState != null) {
            this.selectedState.setEnabled(false);
        }
        this.selectedState = state;
        if (this.selectedState != null) {
            this.selectedState.setEnabled(true);
        }
        this.updateSelectedColor();
    }

    protected void updateSelectedColor() {
        for (Map.Entry<Submenu, ActionButton> e : this.buttonIndex.entrySet()) {
            if (e.getKey().state == this.selectedState) {
                e.getValue().setColor(this.selectedColor);
                continue;
            }
            e.getValue().setColor(this.unselectedColor);
        }
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected void initialize(Application app) {
        this.addChild((AppState)new CharacterMenuState(), true);
        this.addChild((AppState)new MapViewState(), true);
        this.addChild((AppState)new BlueprintSelectorState(), true);
        this.addChild((AppState)new BlueprintEditorState(), true);
        this.addChild((AppState)new ClothingSelectorState(), true);
        this.addChild((AppState)new ClothingEditorState(), true);
        this.addChild((AppState)new PropertyManagementState(), true);
        this.mapMarkers = new MapMarkerState();
        this.getStateManager().attach((AppState)this.mapMarkers);
        this.unselectedColor = new Button("Test").getColor();
        this.window = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even), new ElementId("window"));
        this.window.addChild((Node)new Label("Player Menu", new ElementId("window.title")), new Object[0]);
        this.menu = (Container)this.window.addChild((Node)new Container(), new Object[0]);
        this.updateSubmenus();
    }

    protected void cleanup(Application app) {
        this.getStateManager().detach((AppState)this.mapMarkers);
    }

    protected void onEnable() {
        super.onEnable();
        float y = ((GuiState)this.getState(GuiState.class)).getGuiSize().y;
        this.window.setLocalTranslation(50.0f, y - 50.0f, 0.0f);
        ((GuiState)this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.window);
        if (this.selectedState != null) {
            this.selectedState.setEnabled(true);
        }
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
        super.onDisable();
        if (this.selectedState != null) {
            this.selectedState.setEnabled(false);
        }
        this.window.removeFromParent();
    }

    private class Submenu
    extends Action {
        private AppState state;

        public Submenu(String name, AppState state) {
            super(name);
            this.state = state;
        }

        public void execute(Button source) {
            PlayerMenuState.this.setSelectedState(this.state);
        }
    }
}

