/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.collision.CollisionResult;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.focus.FocusChangeEvent;
import com.simsilica.lemur.focus.FocusChangeListener;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.HelpPopup;
import mythruna.client.ui.MeshUtils;
import mythruna.client.ui.clothing.AddCellsEdit;
import mythruna.client.ui.clothing.ClothingBuilder;
import mythruna.client.ui.clothing.ClothingFileSelectorDialog;
import mythruna.client.ui.clothing.ClothingFunctions;
import mythruna.client.ui.clothing.ClothingSelectorState;
import mythruna.client.ui.clothing.DesignArea;
import mythruna.client.ui.clothing.FabricTypeSelector;
import mythruna.client.ui.clothing.SearchReplaceDialog;
import mythruna.client.ui.clothing.SwatchEdit;
import mythruna.client.ui.clothing.SwatchShapeSelector;
import mythruna.client.ui.edit.Edit;
import mythruna.client.ui.edit.EditHistory;
import mythruna.client.ui.edit.TextFieldEdit;
import mythruna.fabric.ClothingPainter;
import mythruna.fabric.FabricTexture;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.FabricUtils;
import mythruna.fabric.SwatchShape;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.ClothingFileFormat;
import mythruna.net.ClothingData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingEditorState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClothingEditorState.class);
    private Node rootNode = new Node("clothingRoot");
    private Geometry background;
    private DesignArea designArea;
    private Node platform;
    private Vector2f center = new Vector2f();
    private float zoom = 0.0f;
    private Container viewSettings;
    private Selector<DesignArea.Mode> mode;
    private VersionedReference<DesignArea.Mode> modeRef;
    private Checkbox showLeft;
    private VersionedReference<Boolean> leftRef;
    private Checkbox showRight;
    private VersionedReference<Boolean> rightRef;
    private Container swatchSettings;
    private SearchReplaceDialog searchReplace;
    private FabricTypeSelector typeSelector;
    private VersionedReference<FabricType> typeRef;
    private SwatchShapeSelector shapeSelector;
    private VersionedReference<SwatchShape> shapeRef;
    private Container objectSettings;
    private TextField clothingName;
    private TextField itemName;
    private Label editCount;
    private Container editButtons;
    private CursorHandler cursorHandler = new CursorHandler();
    private InputHandler inputHandler = new InputHandler();
    private float yaw = 0.7853982f;
    private float pitch = 0.39f;
    private float yOffsetMin = 0.0f;
    private float yOffsetMax = 100.0f;
    private EditHistory history = new EditHistory(50);
    private VersionedReference<EditHistory> historyRef = this.history.createReference();
    private ActionButton undo;
    private ActionButton redo;
    private ClothingBuilder builder = new ClothingBuilder(32, 32, 32);
    private ClothingPainter painter = new ClothingPainter();
    private FabricType clearBase = new FabricType("clear", "clear").diffuse(new FabricTexture("dummies/female/dummy-base.png")).specular(new FabricTexture(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.1f)));
    private ClothingData clothing;
    private HelpPopup help;

    public ClothingEditorState() {
        this(false);
    }

    public ClothingEditorState(boolean enabled) {
        this.setEnabled(enabled);
    }

    public void editClothing(ClothingData clothing) {
        if (!Objects.equals(this.clothing, clothing)) {
            this.clothing = clothing;
            if (clothing.array == null) {
                log.error("Clothing array is null:" + clothing);
                ((GuiState)this.getState(GuiState.class)).showError("Invalid Clothing", "Clothing data is missing.");
                return;
            }
            this.history.clear();
            this.history.invalidate();
            this.builder.clear();
            this.resetHistoryButtons();
            this.builder.setCells(clothing.array);
            this.builder.drainChangedCells();
            this.clothingName.setText(clothing.name);
            this.itemName.setText(clothing.objectName);
        }
        this.setEnabled(true);
    }

    protected void save() {
        this.clothing.name = this.clothingName.getText();
        this.clothing.objectName = this.itemName.getText();
        this.clothing.array = this.builder.getCells().clone();
        ((ClothingSelectorState)this.getState(ClothingSelectorState.class)).saveEdit(this.clothing, true);
        this.history.clear();
        this.resetHistoryButtons();
    }

    protected void back() {
        if (this.history.getEditCount() > 0) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Abandon Changes?", "Really lose changes?  Or Save?", new Action[]{new CallMethodAction("Save Changes", (Object)this, "save"), new CallMethodAction("Discard Changes", (Object)this, "doBack"), new EmptyAction("Cancel")});
        } else {
            this.doBack();
        }
    }

    protected void doBack() {
        ((ClothingSelectorState)this.getState(ClothingSelectorState.class)).cancelEdit();
        this.history.clear();
        this.resetHistoryButtons();
    }

    protected void resetHistoryButtons() {
        this.undo.setEnabled(this.history.canUndo());
        this.redo.setEnabled(this.history.canRedo());
        this.editCount.setText("Total Edits:" + this.history.getEditCount());
    }

    public boolean undo() {
        log.info("undo()");
        return this.history.undo();
    }

    public boolean redo() {
        log.info("redo()");
        return this.history.redo();
    }

    public void searchReplace() {
        log.info("searchReplace()");
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this.searchReplace);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.searchReplace, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
    }

    protected void addEdit(Edit edit, boolean invalidateCells) {
        this.history.addEdit(edit);
    }

    protected void updateRotation() {
        Quaternion rot = new Quaternion().fromAngles(this.pitch, 0.0f, 0.0f);
        rot.multLocal(new Quaternion().fromAngles(0.0f, this.yaw, 0.0f));
        this.platform.setLocalRotation(rot);
        this.platform.setLocalTranslation(this.center.x, this.center.y, this.zoom);
    }

    protected void initialize(Application app) {
        this.clearBase.initialize(app.getAssetManager());
        this.painter.repaint((CellData)this.builder.getCells(), this.clearBase);
        this.center.set(((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize()).multLocal(0.5f);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        ClothingFunctions.initializeDefaultMappings(inputMapper);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{ClothingFunctions.F_PAN, ClothingFunctions.F_CRANE, ClothingFunctions.F_ZOOM});
        inputMapper.addStateListener((StateFunctionListener)this.inputHandler, new FunctionId[]{ClothingFunctions.F_UNDO, ClothingFunctions.F_REDO, ClothingFunctions.F_CHOOSE, ClothingFunctions.F_EXPORT, ClothingFunctions.F_IMPORT});
        this.designArea = new DesignArea(app.getAssetManager(), this.painter);
        this.designArea.center();
        log.info("designArea.bound():" + this.designArea.getWorldBound());
        log.info("designArea.center():" + this.designArea.getLocalTranslation());
        this.platform = new Node("clothingPlatform");
        this.rootNode.attachChild((Spatial)this.platform);
        this.platform.attachChild((Spatial)this.designArea);
        this.platform.setLocalScale(1.0f);
        CursorEventControl.addListenersToSpatial((Spatial)this.designArea, (CursorListener[])new CursorListener[]{this.cursorHandler});
        this.updateRotation();
        this.viewSettings = new Container(new ElementId("window"));
        this.viewSettings.addChild((Node)new Label("View Settings:", this.viewSettings.getElementId().child("window.title")), new Object[0]);
        this.mode = (Selector)this.viewSettings.addChild((Node)new Selector(new VersionedList(Arrays.asList(DesignArea.Mode.values()))), new Object[0]);
        this.showLeft = (Checkbox)this.viewSettings.addChild((Node)new Checkbox("Show left"), new Object[0]);
        this.showLeft.setChecked(this.designArea.getShowLeft());
        this.showRight = (Checkbox)this.viewSettings.addChild((Node)new Checkbox("Show right"), new Object[0]);
        this.showRight.setChecked(this.designArea.getShowRight());
        this.mode.setSelectedItem((Object)this.designArea.getMode());
        this.modeRef = this.mode.createSelectedItemReference();
        this.leftRef = this.showLeft.getModel().createReference();
        this.rightRef = this.showRight.getModel().createReference();
        this.swatchSettings = new Container(new ElementId("window"));
        this.swatchSettings.addChild((Node)new Label("Swatch Palette:", this.viewSettings.getElementId().child("window.title")), new Object[0]);
        this.typeSelector = (FabricTypeSelector)this.swatchSettings.addChild((Node)new FabricTypeSelector(), new Object[0]);
        this.typeRef = this.typeSelector.createSelectedTypeRef();
        this.shapeSelector = (SwatchShapeSelector)this.swatchSettings.addChild((Node)new SwatchShapeSelector(this.typeSelector.createSelectedTypeRef()), new Object[0]);
        this.shapeRef = this.shapeSelector.createSelectedTypeRef();
        this.swatchSettings.addChild((Node)new ActionButton((Action)new CallMethodAction("Find/replace", (Object)this, "searchReplace")), new Object[0]);
        this.objectSettings = new Container(new ElementId("window"));
        this.objectSettings.addChild((Node)new Label("Object Settings:", this.viewSettings.getElementId().child("window.title")), new Object[0]);
        Container properties = (Container)this.objectSettings.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Last)), new Object[0]);
        properties.addChild((Node)new Label("Clothing:"), new Object[0]);
        this.clothingName = (TextField)properties.addChild((Node)new TextField("Unnamed"), new Object[]{1});
        ((GuiControl)this.clothingName.getControl(GuiControl.class)).addFocusChangeListener((FocusChangeListener)new TextFieldListener("Clothing", this.clothingName));
        properties.addChild((Node)new Label("Item Name:"), new Object[0]);
        this.itemName = (TextField)properties.addChild((Node)new TextField("Item"), new Object[]{1});
        ((GuiControl)this.itemName.getControl(GuiControl.class)).addFocusChangeListener((FocusChangeListener)new TextFieldListener("Item Name", this.itemName));
        this.objectSettings.addChild((Node)new Label("Edit History:"), new Object[0]);
        this.editCount = (Label)this.objectSettings.addChild((Node)new Label("Total Edits:0"), new Object[0]);
        this.undo = (ActionButton)this.objectSettings.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "undo")), new Object[0]);
        this.redo = (ActionButton)this.objectSettings.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "redo")), new Object[0]);
        this.editButtons = new Container(new ElementId("popup"));
        this.editButtons.addChild((Node)new ActionButton((Action)new CallMethodAction("Save Clothing", (Object)this, "save")), new Object[0]);
        this.editButtons.addChild((Node)new ActionButton((Action)new CallMethodAction("Back to Selection", (Object)this, "back")), new Object[0]);
        this.searchReplace = new SearchReplaceDialog(this.builder, this.history);
        Texture blur = app.getAssetManager().loadTexture("Interface/radial-blur128.png");
        int backgroundWidth = 3000;
        int backgroundHeight = 2000;
        Quad big = new Quad((float)backgroundWidth, (float)backgroundHeight);
        Geometry geom = new Geometry("background", (Mesh)big);
        Material mat = GuiGlobals.getInstance().createMaterial(blur, false).getMaterial();
        mat.setColor("Color", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.5f));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.background = geom;
        this.rootNode.attachChild((Spatial)this.background);
        Vector2f offset = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getGuiSize().mult(0.5f);
        this.background.setLocalTranslation(offset.x - (float)(backgroundWidth / 2), offset.y - (float)(backgroundHeight / 2), -500.0f);
        this.help = new HelpPopup(null, v -> {
            Vector2f size = ((GuiState)this.getState(GuiState.class)).getGuiSize();
            return new Vector3f(50.0f, size.y * 0.6f, 100.0f);
        }, "Clothing Editing");
        this.help.setText("The 'w','a','s', and 'd' keys rotate the design area.", "The right mouse button places a swatch where", "the flashing marker indicates.", "The left mouse button removes the swatch under", "that location.", "", "The swatch type can be changed in the 'Fabric", "Palette' in the upper right or by pressing 'c'", "over a switch in the design area.", "", "Edit clothing design properties in the 'Item", "Settings' panel.  'Clothing' is the name for", "this design.  'Item Name' is the name of", "the clothing as it appears in the world.", "", "Ctrl-Z will undo the last edit and Ctrl-Y will", "redo the last edit or the 'Undo' and 'Redo'", "buttons do the same thing.");
    }

    protected void cleanup(Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{ClothingFunctions.F_PAN, ClothingFunctions.F_CRANE, ClothingFunctions.F_ZOOM});
        inputMapper.removeStateListener((StateFunctionListener)this.inputHandler, new FunctionId[]{ClothingFunctions.F_UNDO, ClothingFunctions.F_REDO, ClothingFunctions.F_CHOOSE, ClothingFunctions.F_EXPORT, ClothingFunctions.F_IMPORT});
    }

    protected void onEnable() {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup("Clothing");
        Vector2f size = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize();
        float minWidth = 300.0f;
        Vector3f pref = this.swatchSettings.getPreferredSize();
        pref.x = Math.max(pref.x, minWidth);
        this.swatchSettings.setPreferredSize(pref);
        float x = size.x;
        float y = size.y * 0.95f;
        this.swatchSettings.setLocalTranslation(size.x * 0.95f - pref.x, y, 0.0f);
        x = Math.min(x, size.x * 0.95f - pref.x);
        y -= pref.y + 20.0f;
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.swatchSettings);
        pref = this.objectSettings.getPreferredSize();
        pref.x = Math.max(pref.x, minWidth);
        this.objectSettings.setPreferredSize(pref);
        x = Math.min(x, size.x * 0.95f - pref.x);
        this.objectSettings.setLocalTranslation(size.x * 0.95f - pref.x, y, 0.0f);
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.objectSettings);
        this.editButtons.setLocalTranslation(size.x * 0.95f - pref.x, y -= pref.y + 20.0f, 0.0f);
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.editButtons);
        this.resetHistoryButtons();
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.rootNode);
        y = size.y * 0.95f;
        pref = this.viewSettings.getPreferredSize();
        this.viewSettings.setLocalTranslation(x - pref.x - 10.0f, y, 0.0f);
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.viewSettings);
        if (this.getState(GameSessionState.class) != null) {
            this.help.attach();
        }
    }

    public void update(float tpf) {
        if (this.modeRef.update()) {
            this.designArea.setMode((DesignArea.Mode)((Object)this.mode.getSelectedItem()));
        }
        if (this.leftRef.update()) {
            this.designArea.setShowLeft((Boolean)this.leftRef.get());
        }
        if (this.rightRef.update()) {
            this.designArea.setShowRight((Boolean)this.rightRef.get());
        }
        if (this.historyRef.update()) {
            this.resetHistoryButtons();
            this.painter.repaint((CellData)this.builder.getCells(), this.clearBase, this.builder.drainChangedCells());
        }
    }

    protected void onDisable() {
        this.help.detach();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup("Clothing");
        this.rootNode.removeFromParent();
        this.viewSettings.removeFromParent();
        this.swatchSettings.removeFromParent();
        this.objectSettings.removeFromParent();
        this.editButtons.removeFromParent();
    }

    protected void chooseType() {
        Vec3i cell = this.cursorHandler.cell;
        log.info("Choose type:" + cell);
        if (cell == null) {
            return;
        }
        int value = this.builder.getTopValue(cell.x, cell.y);
        log.info("  chosen:" + value);
        if (value == 0) {
            return;
        }
        int fabric = FabricUtils.toFabric((int)value);
        int shape = FabricUtils.toShape((int)value);
        log.info("fabric:" + fabric + "  shape:" + shape);
        this.typeSelector.setSelectedType(fabric);
        this.shapeSelector.setSelectedShapeIndex(shape);
    }

    protected void exportCurrent() {
        String name = this.clothingName.getText() + "-" + this.itemName.getText() + ".clothing";
        log.info("Export current:" + name);
        try {
            File target = new File("clothing", name);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            ClothingFileFormat format = new ClothingFileFormat(FabricTypeIndex.getTypes(), SwatchShapeIndex.getShapes());
            format.writeCells(target, this.builder.getCells());
        }
        catch (Exception e) {
            log.error("Error writing:" + name, (Throwable)e);
        }
    }

    protected void selectImport() {
        ClothingFileSelectorDialog dialog = new ClothingFileSelectorDialog(new File("clothing"), file -> this.importFile((File)file));
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)dialog);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)dialog, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
    }

    protected void importFile(File f) {
        log.info("importFile(" + f + ")");
        try {
            ClothingFileFormat format = new ClothingFileFormat(FabricTypeIndex.getTypes(), SwatchShapeIndex.getShapes());
            CellArray cells = format.readCells(f);
            this.history.accept(new AddCellsEdit(this.builder, f.getName(), cells));
        }
        catch (Exception e) {
            log.error("Error reading:" + f, (Throwable)e);
        }
    }

    private class CursorHandler
    extends DefaultCursorListener {
        private CollisionResult lastResult;
        private Vec3i cell;

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (event.isPressed()) {
                return;
            }
            if (this.cell == null) {
                log.info("end cap");
                return;
            }
            log.info("cursorButtonEvent(" + event + ")");
            if (event.getButtonIndex() == 1) {
                int shapeId = ClothingEditorState.this.shapeSelector.getSelectedShapeIndex();
                int typeId = ClothingEditorState.this.typeSelector.getSelectedType();
                log.info("shapeId:" + shapeId + " typeId:" + typeId);
                int value = FabricUtils.toCell((int)shapeId, (int)typeId);
                if (ClothingEditorState.this.builder.getTopValue(this.cell.x, this.cell.y) == value) {
                    log.info("No change");
                    return;
                }
                ClothingEditorState.this.history.accept(new SwatchEdit(ClothingEditorState.this.builder, this.cell, value));
            } else if (event.getButtonIndex() == 0) {
                if (ClothingEditorState.this.builder.getTopValue(this.cell.x, this.cell.y) == 0) {
                    log.info("No change");
                    return;
                }
                ClothingEditorState.this.history.accept(new SwatchEdit(ClothingEditorState.this.builder, this.cell));
            }
        }

        public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.lastResult = event.getCollision();
            if (this.lastResult == null) {
                this.cell = null;
                return;
            }
            int ti = this.lastResult.getTriangleIndex();
            Mesh mesh = this.lastResult.getGeometry().getMesh();
            Vector3f cp = this.lastResult.getGeometry().worldToLocal(this.lastResult.getContactPoint(), null);
            Vector2f bary = MeshUtils.getBarycentricCoord(mesh, ti, cp);
            Vector2f uv = MeshUtils.getTextureCoordinate(mesh, ti, bary);
            int cellSize = 32;
            int x = (int)Math.floor((float)cellSize * uv.x);
            int y = (int)Math.floor((float)cellSize * uv.y);
            this.cell = x >= 14 && x <= 17 && y >= 3 && y <= 5 ? null : new Vec3i(x, y, 0);
        }
    }

    private class InputHandler
    implements AnalogFunctionListener,
    StateFunctionListener {
        private InputHandler() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
            boolean pressed;
            boolean bl = pressed = value == InputState.Positive;
            if (!pressed) {
                if (func == ClothingFunctions.F_CHOOSE) {
                    ClothingEditorState.this.chooseType();
                } else if (func == ClothingFunctions.F_EXPORT) {
                    ClothingEditorState.this.exportCurrent();
                } else if (func == ClothingFunctions.F_IMPORT) {
                    ClothingEditorState.this.selectImport();
                } else if (func == ClothingFunctions.F_UNDO) {
                    ClothingEditorState.this.undo();
                } else if (func == ClothingFunctions.F_REDO) {
                    ClothingEditorState.this.redo();
                }
            }
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == ClothingFunctions.F_PAN) {
                ClothingEditorState.this.yaw = (float)((double)ClothingEditorState.this.yaw + -value * tpf);
                if (ClothingEditorState.this.yaw < 0.0f) {
                    ClothingEditorState.this.yaw += (float)Math.PI * 2;
                } else if (ClothingEditorState.this.yaw >= (float)Math.PI * 2) {
                    ClothingEditorState.this.yaw -= (float)Math.PI * 2;
                }
                ClothingEditorState.this.updateRotation();
            } else if (func == ClothingFunctions.F_CRANE) {
                ClothingEditorState.this.pitch = (float)((double)ClothingEditorState.this.pitch + value * tpf);
                if (ClothingEditorState.this.pitch < -1.5707964f) {
                    ClothingEditorState.this.pitch = -1.5707964f;
                } else if (ClothingEditorState.this.pitch > 1.5707964f) {
                    ClothingEditorState.this.pitch = 1.5707964f;
                }
                ClothingEditorState.this.updateRotation();
            } else if (func == ClothingFunctions.F_ZOOM) {
                ClothingEditorState.this.zoom = (float)((double)ClothingEditorState.this.zoom + value * tpf * 100.0);
                if (ClothingEditorState.this.zoom < 0.0f) {
                    ClothingEditorState.this.zoom = 0.0f;
                } else if (ClothingEditorState.this.zoom > 1000.0f) {
                    ClothingEditorState.this.zoom = 1000.0f;
                }
                ClothingEditorState.this.updateRotation();
            } else {
                log.info("unhandled id:" + func);
            }
        }
    }

    private class TextFieldListener
    implements FocusChangeListener {
        private String name;
        private TextField textField;
        private String lastValue;

        public TextFieldListener(String name, TextField textField) {
            this.name = name;
            this.textField = textField;
        }

        public void focusGained(FocusChangeEvent event) {
            this.lastValue = this.textField.getText();
        }

        public void focusLost(FocusChangeEvent event) {
            String value = this.textField.getText();
            if (!Objects.equals(value, this.lastValue)) {
                log.info(this.name + " changed:" + value);
                ClothingEditorState.this.addEdit(new TextFieldEdit(this.name, this.textField, value, this.lastValue), false);
            }
        }
    }
}

