/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.WatchedEntity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DefaultWatchedEntity
implements WatchedEntity {
    private final EntityData ed;
    private final EntityId id;
    private final EntityComponent[] components;
    private final Class<EntityComponent>[] types;
    private final Set<Class<EntityComponent>> typeSet;
    private final ChangeProcessor listener;
    private final ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();
    private boolean released;

    public DefaultWatchedEntity(EntityData ed, EntityId id, Class<EntityComponent>[] types) {
        this(ed, id, null, types);
    }

    public DefaultWatchedEntity(EntityData ed, EntityId id, EntityComponent[] data, Class<EntityComponent>[] types) {
        this.ed = ed;
        this.id = id;
        this.components = data == null ? new EntityComponent[types.length] : data;
        this.types = types;
        this.typeSet = new HashSet<Class<EntityComponent>>(Arrays.asList(types));
        this.listener = new ChangeProcessor();
        if (ed instanceof ObservableEntityData) {
            ((ObservableEntityData)ed).addEntityComponentListener(this.listener);
        }
        if (data == null) {
            this.load();
        }
    }

    protected final void load() {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.ed.getComponent(this.id, this.types[i]);
        }
    }

    protected EntityComponentListener getListener() {
        return this.listener;
    }

    @Override
    public EntityId getId() {
        return this.id;
    }

    @Override
    public <T extends EntityComponent> T get(Class<T> type) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != type) continue;
            return (T)((EntityComponent)type.cast(this.components[i]));
        }
        return null;
    }

    @Override
    public void set(EntityComponent c) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isInstance(c)) continue;
            this.ed.setComponent(this.getId(), c);
            this.components[i] = c;
            break;
        }
        this.ed.setComponent(this.getId(), c);
    }

    @Override
    public boolean isComplete() {
        for (EntityComponent component : this.components) {
            if (component != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public EntityComponent[] getComponents() {
        return this.components;
    }

    @Override
    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    @Override
    public boolean applyChanges() {
        return this.applyChanges(null);
    }

    @Override
    public boolean applyChanges(Set<EntityChange> updates) {
        EntityChange change;
        if (this.released) {
            this.changes.clear();
            return false;
        }
        boolean hasChanges = false;
        while ((change = this.changes.poll()) != null) {
            if (!this.applyChange(change)) continue;
            hasChanges = true;
            if (updates == null) continue;
            updates.add(change);
        }
        return hasChanges;
    }

    protected boolean applyChange(EntityChange change) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != change.getComponentType()) continue;
            this.components[i] = change.getComponent();
            return true;
        }
        return false;
    }

    @Override
    public void release() {
        this.released = true;
        if (this.ed instanceof ObservableEntityData) {
            ((ObservableEntityData)this.ed).removeEntityComponentListener(this.listener);
        }
    }

    protected boolean isReleased() {
        return this.released;
    }

    protected void addChange(EntityChange change) {
        if (this.id.getId() != change.getEntityId().getId()) {
            return;
        }
        if (!this.typeSet.contains(change.getComponentType())) {
            return;
        }
        this.changes.add(change);
    }

    public String toString() {
        return "WatchedEntity[" + this.id + ", values=" + Arrays.asList(this.components) + "]";
    }

    private class ChangeProcessor
    implements EntityComponentListener {
        @Override
        public void componentChange(EntityChange change) {
            DefaultWatchedEntity.this.addChange(change);
        }
    }
}

