/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.CompactQuaternionArray;
import com.jme3.animation.CompactVector3Array;
import com.jme3.animation.Track;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

@Deprecated
public class SpatialTrack
implements JmeCloneable,
Track {
    private CompactVector3Array translations;
    private CompactQuaternionArray rotations;
    private CompactVector3Array scales;
    private Spatial trackSpatial;
    private float[] times;

    public SpatialTrack() {
    }

    public SpatialTrack(float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        this.setKeyframes(times, translations, rotations, scales);
    }

    @Override
    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        Spatial spatial = this.trackSpatial;
        if (spatial == null) {
            spatial = control.getSpatial();
        }
        Vector3f tempV = vars.vect1;
        Vector3f tempS = vars.vect2;
        Quaternion tempQ = vars.quat1;
        Vector3f tempV2 = vars.vect3;
        Vector3f tempS2 = vars.vect4;
        Quaternion tempQ2 = vars.quat2;
        int lastFrame = this.times.length - 1;
        if (time < 0.0f || lastFrame == 0) {
            if (this.rotations != null) {
                this.rotations.get(0, tempQ);
            }
            if (this.translations != null) {
                this.translations.get(0, tempV);
            }
            if (this.scales != null) {
                this.scales.get(0, tempS);
            }
        } else if (time >= this.times[lastFrame]) {
            if (this.rotations != null) {
                this.rotations.get(lastFrame, tempQ);
            }
            if (this.translations != null) {
                this.translations.get(lastFrame, tempV);
            }
            if (this.scales != null) {
                this.scales.get(lastFrame, tempS);
            }
        } else {
            int startFrame = 0;
            int endFrame = 1;
            for (int i = 0; i < lastFrame && this.times[i] < time; ++i) {
                startFrame = i;
                endFrame = i + 1;
            }
            float blend = (time - this.times[startFrame]) / (this.times[endFrame] - this.times[startFrame]);
            if (this.rotations != null) {
                this.rotations.get(startFrame, tempQ);
            }
            if (this.translations != null) {
                this.translations.get(startFrame, tempV);
            }
            if (this.scales != null) {
                this.scales.get(startFrame, tempS);
            }
            if (this.rotations != null) {
                this.rotations.get(endFrame, tempQ2);
            }
            if (this.translations != null) {
                this.translations.get(endFrame, tempV2);
            }
            if (this.scales != null) {
                this.scales.get(endFrame, tempS2);
            }
            tempQ.nlerp(tempQ2, blend);
            tempV.interpolateLocal(tempV2, blend);
            tempS.interpolateLocal(tempS2, blend);
        }
        if (this.translations != null) {
            spatial.setLocalTranslation(tempV);
        }
        if (this.rotations != null) {
            spatial.setLocalRotation(tempQ);
        }
        if (this.scales != null) {
            spatial.setLocalScale(tempS);
        }
    }

    public void setKeyframes(float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        if (times.length == 0) {
            throw new RuntimeException("BoneTrack with no keyframes!");
        }
        this.times = times;
        if (translations != null) {
            assert (times.length == translations.length);
            this.translations = new CompactVector3Array();
            this.translations.add(translations);
            this.translations.freeze();
        }
        if (rotations != null) {
            assert (times.length == rotations.length);
            this.rotations = new CompactQuaternionArray();
            this.rotations.add(rotations);
            this.rotations.freeze();
        }
        if (scales != null) {
            assert (times.length == scales.length);
            this.scales = new CompactVector3Array();
            this.scales.add(scales);
            this.scales.freeze();
        }
    }

    public Quaternion[] getRotations() {
        return this.rotations == null ? null : (Quaternion[])this.rotations.toObjectArray();
    }

    public Vector3f[] getScales() {
        return this.scales == null ? null : (Vector3f[])this.scales.toObjectArray();
    }

    public float[] getTimes() {
        return this.times;
    }

    public Vector3f[] getTranslations() {
        return this.translations == null ? null : (Vector3f[])this.translations.toObjectArray();
    }

    @Override
    public float getLength() {
        return this.times == null ? 0.0f : this.times[this.times.length - 1] - this.times[0];
    }

    @Override
    public SpatialTrack clone() {
        Cloner cloner = new Cloner();
        cloner.setClonedValue(this.trackSpatial, this.trackSpatial);
        return cloner.clone(this);
    }

    @Override
    public float[] getKeyFrameTimes() {
        return this.times;
    }

    public void setTrackSpatial(Spatial trackSpatial) {
        this.trackSpatial = trackSpatial;
    }

    public Spatial getTrackSpatial() {
        return this.trackSpatial;
    }

    @Override
    public SpatialTrack jmeClone() {
        try {
            return (SpatialTrack)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException("Can't clone track", exception);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.translations = cloner.clone(this.translations);
        this.rotations = cloner.clone(this.rotations);
        this.scales = cloner.clone(this.scales);
        this.trackSpatial = cloner.clone(this.trackSpatial);
        this.times = cloner.clone(this.times);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.translations, "translations", null);
        oc.write(this.rotations, "rotations", null);
        oc.write(this.times, "times", (float[])null);
        oc.write(this.scales, "scales", null);
        oc.write(this.trackSpatial, "trackSpatial", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.translations = (CompactVector3Array)ic.readSavable("translations", null);
        this.rotations = (CompactQuaternionArray)ic.readSavable("rotations", null);
        this.times = ic.readFloatArray("times", null);
        this.scales = (CompactVector3Array)ic.readSavable("scales", null);
        this.trackSpatial = (Spatial)ic.readSavable("trackSpatial", null);
    }
}

