/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import mythruna.world.WorldFractal;
import mythruna.world.WorldFractalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalTest {
    static Logger log = LoggerFactory.getLogger(FractalTest.class);

    public static void main(String ... args) throws Exception {
        SedectileId tileId = SedectileId.fromWorld((int)57487, (int)0, (int)7959);
        Vec3i origin = tileId.getWorld(null);
        int spread = 8;
        int count = 16384 / spread;
        log.info("Testing with terrain for:" + origin + " with spread:" + spread + "  " + count + "x" + count + " samples");
        WorldFractal fractal = WorldFractalFactory.createDefault((long)123L, (boolean)true);
        double[][] array = new double[count][count];
        while (true) {
            File f = new File("fractal.png");
            log.info("Delete " + f + " to continue...");
            while (f.exists()) {
                Thread.sleep(1000L);
            }
            log.info("Running map test...");
            long start = System.nanoTime();
            for (int x = 0; x < count; ++x) {
                for (int z = 0; z < count; ++z) {
                    double y;
                    array[x][z] = y = fractal.getElevation((double)(origin.x + x * spread), (double)(origin.z + z * spread));
                }
            }
            long end = System.nanoTime();
            log.info(String.format("Completed in %.02f ms", (double)(end - start) / 1000000.0));
            log.info("Generating image...");
            BufferedImage img = new BufferedImage(count, count, 2);
            log.info("raster buffer:" + img.getRaster().getDataBuffer());
            DataBufferInt dBuff = (DataBufferInt)img.getRaster().getDataBuffer();
            int[] data = dBuff.getData();
            int pos = 0;
            for (int z = 0; z < count; ++z) {
                for (int x = 0; x < count; ++x) {
                    double y = array[x][z];
                    int e = (int)Math.min(255.0, y / 640.0 * 255.0);
                    data[pos++] = 0xFF000000 | e << 16 | e << 8 | e;
                }
            }
            ImageIO.write((RenderedImage)img, "PNG", f);
            log.info("Wrote:" + f);
        }
    }
}

