/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import mythruna.fabric.FabricTexture;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.io.FabricTypeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricConfig {
    static Logger log = LoggerFactory.getLogger(FabricConfig.class);
    private static final ColorRGBA NO_SPECULAR = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private static final ColorRGBA MIN_SPECULAR = new ColorRGBA(0.003921569f, 0.003921569f, 0.003921569f, 0.003921569f);
    static FabricType[] types = new FabricType[]{null, new FabricType("linen", "natural").diffuse(FabricConfig.color("#bdaf93")).normal(FabricConfig.texture("fabric/burlap-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("linen", "bleached").diffuse(FabricConfig.color("#c8c5bb")).normal(FabricConfig.texture("fabric/burlap-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "natural").diffuse(FabricConfig.color("#bdaf93")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "red").diffuse(FabricConfig.color("#af3636")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "dark-red").diffuse(FabricConfig.color("#6a0404")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "green").diffuse(FabricConfig.color("#3d752f")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "dark-green").diffuse(FabricConfig.color("#063e06")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "blue").diffuse(FabricConfig.color("#4d6995")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "dark-blue").diffuse(FabricConfig.color("#040e17")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "yellow").diffuse(FabricConfig.color("#cfc86d")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "dark-yellow").diffuse(FabricConfig.color("#5c5716")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "pink").diffuse(FabricConfig.color("#b66992")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "dark-pink").diffuse(FabricConfig.color("#850c5f")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "orange").diffuse(FabricConfig.color("#c77932")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "dark-orange").diffuse(FabricConfig.color("#9f3c0c")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "purple").diffuse(FabricConfig.color("#8045a7")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("wool", "dark-purple").diffuse(FabricConfig.color("#310e48")).normal(FabricConfig.texture("fabric/weave4-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("burlap", "natural").diffuse(FabricConfig.color("#bdaf93")).normal(FabricConfig.texture("fabric/cloth1-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("plaid", "green").diffuse(FabricConfig.texture("fabric/green-plaid.png")).normal(FabricConfig.texture("fabric/heavy-weave-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("plaid", "red").diffuse(FabricConfig.texture("fabric/red-plaid.png")).normal(FabricConfig.texture("fabric/heavy-weave-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("plaid", "blue").diffuse(FabricConfig.texture("fabric/blue-plaid.png")).normal(FabricConfig.texture("fabric/heavy-weave-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("leather", "natural").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg")).normal(FabricConfig.texture("fabric/leather-normals.png")).specular(FabricConfig.color(new ColorRGBA(0.1f, 0.1f, 0.1f, 0.25f))), new FabricType("leather", "dark").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg", new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f))).normal(FabricConfig.texture("fabric/leather-normals.png")).specular(FabricConfig.color(new ColorRGBA(0.1f, 0.1f, 0.1f, 0.25f))), new FabricType("leather", "black").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg", new ColorRGBA(0.05f, 0.05f, 0.05f, 1.0f))).normal(FabricConfig.texture("fabric/leather-normals.png")).specular(FabricConfig.color(new ColorRGBA(0.1f, 0.1f, 0.1f, 0.25f))), new FabricType("leather", "red-stain").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg", new ColorRGBA(0.7f, 0.15f, 0.15f, 1.0f))).normal(FabricConfig.texture("fabric/leather-normals.png")).specular(FabricConfig.color(new ColorRGBA(0.1f, 0.1f, 0.1f, 0.25f))), new FabricType("leather", "green-stain").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg", new ColorRGBA(0.15f, 0.7f, 0.15f, 1.0f))).normal(FabricConfig.texture("fabric/leather-normals.png")).specular(FabricConfig.color(new ColorRGBA(0.1f, 0.1f, 0.1f, 0.25f))), new FabricType("leather", "rough").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg")).normal(FabricConfig.texture("fabric/ROCK6-norm.jpg")).specular(FabricConfig.color(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f))), new FabricType("leather", "aged").diffuse(FabricConfig.texture("fabric/aged-leather.png")).normal(FabricConfig.texture("fabric/aged-leather-normals.png")).specular(FabricConfig.texture("fabric/aged-leather-specular.png", new ColorRGBA(0.5f, 0.5f, 0.5f, 0.25f))), new FabricType("leather", "dark-aged").diffuse(FabricConfig.texture("fabric/dark-aged-leather.png")).normal(FabricConfig.texture("fabric/aged-leather-normals.png")).specular(FabricConfig.texture("fabric/aged-leather-specular.png", new ColorRGBA(0.5f, 0.5f, 0.5f, 0.25f))), new FabricType("suede", "natural").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg")).specular(FabricConfig.color(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f))), new FabricType("suede", "dark").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg", new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f))).specular(FabricConfig.color(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f))), new FabricType("suede", "black").diffuse(FabricConfig.texture("fabric/leather-gradient.jpg", new ColorRGBA(0.05f, 0.05f, 0.05f, 1.0f))).specular(FabricConfig.color(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f))), new FabricType("metal", "brushed").diffuse(FabricConfig.texture("fabric/metal-base.png", new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f))).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.8f, 0.9f, 1.2f, 1.0f))), new FabricType("metal", "steel").diffuse(FabricConfig.texture("fabric/metal-gradient.png", new ColorRGBA(0.75f, 0.75f, 0.75f, 1.0f))).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.8f, 0.9f, 1.2f, 1.0f))), new FabricType("metal", "black-steel").diffuse(FabricConfig.texture("fabric/metal-gradient.png", new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f))).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.8f, 0.9f, 1.2f, 1.0f))), new FabricType("metal", "wrought-iron").diffuse(FabricConfig.texture("fabric/metal-base.png", new ColorRGBA(0.115f, 0.1f, 0.1f, 1.0f))).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.125f, 0.1f, 0.1f, 0.05f))), new FabricType("metal", "rusted").diffuse(FabricConfig.texture("fabric/rust-base.png")).normal(FabricConfig.texture("fabric/rust-normals.png")).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.8f, 0.9f, 1.2f, 1.0f))), new FabricType("metal", "brass").diffuse(FabricConfig.texture("fabric/metal-gradient.png", new ColorRGBA(0.8f, 0.75f, 0.55f, 1.0f))).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.75f, 1.4f, 0.75f, 1.0f))), new FabricType("metal", "gold").diffuse(FabricConfig.texture("fabric/metal-gradient.png", new ColorRGBA(0.85f, 0.85f, 0.55f, 1.0f))).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(1.4f, 1.2f, 0.75f, 1.0f))), new FabricType("metal", "silver").diffuse(FabricConfig.texture("fabric/metal-gradient.png", new ColorRGBA(0.75f, 0.75f, 0.76f, 1.0f))).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.75f, 0.75f, 1.4f, 1.0f))), new FabricType("chainmail", "bright").diffuse(FabricConfig.texture("fabric/metal-base.png")).normal(FabricConfig.texture("fabric/chainmail1024-normals.png")).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.8f, 0.9f, 1.2f, 1.0f))), new FabricType("chainmail", "dark").diffuse(FabricConfig.texture("fabric/metal-base.png", new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f))).normal(FabricConfig.texture("fabric/chainmail1024-normals.png")).specular(FabricConfig.texture("fabric/metal-specular2.png", new ColorRGBA(0.8f, 0.9f, 1.2f, 1.0f))), new FabricType("fur", "light-brown").diffuse(FabricConfig.texture("fabric/fur1.png", new ColorRGBA(0.75f, 0.75f, 0.75f, 1.0f))).normal(FabricConfig.texture("fabric/fur-normals3.png")).specular(FabricConfig.texture("fabric/fur-specular.png", new ColorRGBA(0.1f, 0.1f, 0.1f, 0.1f))), new FabricType("fur", "grey").diffuse(FabricConfig.texture("fabric/fur-bw.png")).normal(FabricConfig.texture("fabric/fur-normals3.png")).specular(FabricConfig.texture("fabric/fur-specular.png", new ColorRGBA(0.1f, 0.1f, 0.1f, 0.1f))), new FabricType("fur", "dark-grey").diffuse(FabricConfig.texture("fabric/fur-bw.png", FabricConfig.parseColor("#202020"))).normal(FabricConfig.texture("fabric/fur-normals3.png")).specular(FabricConfig.texture("fabric/fur-specular.png", new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f))), new FabricType("fur", "brown").diffuse(FabricConfig.texture("fabric/fur1.png", FabricConfig.parseColor("#695247"))).normal(FabricConfig.texture("fabric/fur-normals3.png")).specular(FabricConfig.texture("fabric/fur-specular.png", new ColorRGBA(0.1f, 0.05f, 0.05f, 0.05f))), new FabricType("fur", "dark-brown").diffuse(FabricConfig.texture("fabric/fur1.png", FabricConfig.parseColor("#221610"))).normal(FabricConfig.texture("fabric/fur-normals3.png")).specular(FabricConfig.texture("fabric/fur-specular.png", new ColorRGBA(0.1f, 0.05f, 0.05f, 0.05f))), new FabricType("twill", "grey").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#b0afaf"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "dark-grey").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#b0afaf"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "red").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#af3636"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "dark-red").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#af3636"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "green").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#3d752f"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "dark-green").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#3d752f"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "blue").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#4d6995"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "dark-blue").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#4d6995"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "yellow").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#cfc86d"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "dark-yellow").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#cfc86d"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "pink").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#b66992"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "dark-pink").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#b66992"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "orange").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#c77932"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "brown").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#c77932"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "purple").diffuse(FabricConfig.texture("fabric/wear-and-tear-light.png", FabricConfig.parseColor("#8045a7"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR)), new FabricType("twill", "dark-purple").diffuse(FabricConfig.texture("fabric/wear-and-tear-dark.png", FabricConfig.parseColor("#8045a7"))).normal(FabricConfig.texture("fabric/twill-normals.png")).specular(FabricConfig.color(MIN_SPECULAR))};

    public static FabricTexture texture(String name) {
        return new FabricTexture(name);
    }

    public static FabricTexture texture(String name, ColorRGBA color) {
        return new FabricTexture(name, color);
    }

    public static FabricTexture color(String color) {
        return FabricConfig.color(FabricConfig.parseColor(color));
    }

    public static FabricTexture color(ColorRGBA color) {
        return new FabricTexture(null, color);
    }

    public static ColorRGBA parseColor(String s) {
        int r = Integer.parseInt(s.substring(1, 3), 16);
        int g = Integer.parseInt(s.substring(3, 5), 16);
        int b = Integer.parseInt(s.substring(5, 7), 16);
        return new ColorRGBA((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public static FabricTypeData initialize() {
        return new FabricTypeData(types, 1);
    }

    public static void loadAssets(AssetManager assets) {
        for (FabricType type : FabricTypeIndex.getTypes()) {
            if (type == null) continue;
            type.initialize(assets);
        }
    }
}

