/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.core.AbstractNodeControl;
import com.simsilica.lemur.core.ComponentStack;
import com.simsilica.lemur.core.FocusTraversalAdapter;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControlListener;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.GuiUpdateListener;
import com.simsilica.lemur.focus.FocusChangeEvent;
import com.simsilica.lemur.focus.FocusChangeListener;
import com.simsilica.lemur.focus.FocusTarget;
import com.simsilica.lemur.focus.FocusTraversal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiControl
extends AbstractNodeControl<GuiControl>
implements FocusTarget,
FocusTraversal {
    static Logger log = LoggerFactory.getLogger(GuiControl.class);
    private ComponentStack componentStack;
    private GuiLayout layout;
    private FocusTraversal focusTraversal;
    private SafeArrayList<GuiControlListener> listeners;
    private SafeArrayList<FocusChangeListener> focusListeners;
    private SafeArrayList<GuiUpdateListener> updateListeners;
    private volatile boolean invalid = false;
    private Vector3f preferredSizeOverride = null;
    private Vector3f lastSize = new Vector3f();
    private boolean focused = false;
    private boolean focusable = false;

    public GuiControl(GuiComponent ... components) {
        this.componentStack = new ComponentStack(new String[0]);
        for (GuiComponent c : components) {
            this.componentStack.addComponent(c);
        }
    }

    public GuiControl(String ... layerOrder) {
        this.componentStack = new ComponentStack(layerOrder);
    }

    @Override
    public Node getNode() {
        return super.getNode();
    }

    public void addListener(GuiControlListener l) {
        if (this.listeners == null) {
            this.listeners = new SafeArrayList(GuiControlListener.class);
        }
        this.listeners.add((Object)l);
    }

    public void removeListener(GuiControlListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)l);
    }

    public void addFocusChangeListener(FocusChangeListener l) {
        if (this.focusListeners == null) {
            this.focusListeners = new SafeArrayList(FocusChangeListener.class);
        }
        this.focusListeners.add((Object)l);
    }

    public void removeFocusChangeListener(FocusChangeListener l) {
        if (this.focusListeners == null) {
            return;
        }
        this.focusListeners.remove((Object)l);
    }

    public void addUpdateListener(GuiUpdateListener l) {
        if (this.updateListeners == null) {
            this.updateListeners = new SafeArrayList(GuiUpdateListener.class);
        }
        this.updateListeners.add((Object)l);
    }

    public void removeUpdateListener(GuiUpdateListener l) {
        if (this.updateListeners == null) {
            return;
        }
        this.updateListeners.remove((Object)l);
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    public void setFocusable(boolean b) {
        this.focusable = b;
    }

    @Override
    public boolean isFocusable() {
        if (this.focusable) {
            return true;
        }
        if (this.layout instanceof FocusTarget && ((FocusTarget)((Object)this.layout)).isFocusable()) {
            return true;
        }
        for (GuiComponent c : this.componentStack.getArray()) {
            if (!(c instanceof FocusTarget) || !((FocusTarget)((Object)c)).isFocusable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void focusGained() {
        if (log.isTraceEnabled()) {
            log.trace(this.getSpatial() + " focusGained() isFocused:" + this.focused);
        }
        if (this.focused) {
            return;
        }
        this.focused = true;
        for (GuiComponent c : this.componentStack.getArray()) {
            if (!(c instanceof FocusTarget)) continue;
            ((FocusTarget)((Object)c)).focusGained();
        }
        if (this.layout instanceof FocusTarget) {
            ((FocusTarget)((Object)this.layout)).focusGained();
        }
        if (this.listeners != null) {
            for (GuiControlListener l : (GuiControlListener[])this.listeners.getArray()) {
                l.focusGained(this);
            }
        }
        if (this.focusListeners != null) {
            FocusChangeEvent fce = new FocusChangeEvent(this);
            for (FocusChangeListener l : (FocusChangeListener[])this.focusListeners.getArray()) {
                l.focusGained(fce);
            }
        }
    }

    @Override
    public void focusLost() {
        if (log.isTraceEnabled()) {
            log.trace(this.getSpatial() + " focusLost() isFocused:" + this.focused);
        }
        if (!this.focused) {
            return;
        }
        this.focused = false;
        for (GuiComponent c : this.componentStack.getArray()) {
            if (!(c instanceof FocusTarget)) continue;
            ((FocusTarget)((Object)c)).focusLost();
        }
        if (this.layout instanceof FocusTarget) {
            ((FocusTarget)((Object)this.layout)).focusLost();
        }
        if (this.listeners != null) {
            for (GuiControlListener l : (GuiControlListener[])this.listeners.getArray()) {
                l.focusLost(this);
            }
        }
        if (this.focusListeners != null) {
            FocusChangeEvent fce = new FocusChangeEvent(this);
            for (FocusChangeListener l : (FocusChangeListener[])this.focusListeners.getArray()) {
                l.focusLost(fce);
            }
        }
    }

    @Override
    public Spatial getDefaultFocus() {
        return this.focusTraversal == null ? null : this.focusTraversal.getDefaultFocus();
    }

    @Override
    public Spatial getRelativeFocus(Spatial from, FocusTraversal.TraversalDirection direction) {
        return this.focusTraversal == null ? null : this.focusTraversal.getRelativeFocus(from, direction);
    }

    @Override
    public boolean isFocusRoot() {
        return this.focusTraversal == null ? false : this.focusTraversal.isFocusRoot();
    }

    public void setLayerOrder(String ... layers) {
        this.componentStack.setLayerOrder(layers);
    }

    public void setLayout(GuiLayout l) {
        if (this.layout == l) {
            return;
        }
        if (this.layout != null && this.getNode() != null) {
            this.layout.detach(this);
        }
        this.layout = l;
        if (this.layout != null && this.getNode() != null) {
            this.layout.attach(this);
        }
        if (this.layout instanceof FocusTraversal) {
            this.focusTraversal = (FocusTraversal)((Object)this.layout);
        } else if (this.layout != null) {
            this.focusTraversal = new FocusTraversalAdapter(this.layout);
        }
        this.invalidate();
    }

    public <T extends GuiLayout> T getLayout() {
        return (T)this.layout;
    }

    public void setPreferredSize(Vector3f pref) {
        if (pref != null && (pref.x < 0.0f || pref.y < 0.0f || pref.z < 0.0f)) {
            throw new IllegalArgumentException("Preferred size cannot be negative:" + pref);
        }
        this.preferredSizeOverride = pref;
        this.invalidate();
    }

    public Vector3f getPreferredSize() {
        if (this.preferredSizeOverride != null) {
            return this.preferredSizeOverride.clone();
        }
        Vector3f size = new Vector3f();
        if (this.layout != null) {
            this.layout.calculatePreferredSize(size);
        }
        Vector3f lastSize = new Vector3f(size);
        for (int i = this.componentStack.size() - 1; i >= 0; --i) {
            this.componentStack.get(i).calculatePreferredSize(size);
            if (!(size.x < lastSize.x) && !(size.y < lastSize.y) && !(size.z < lastSize.z)) continue;
            throw new RuntimeException("Component:" + this.componentStack.get(i) + " shrunk the preferred size. Before:" + lastSize + " after:" + size);
        }
        return size;
    }

    public void setSize(Vector3f size) {
        if (size.x < 0.0f || size.y < 0.0f || size.z < 0.0f) {
            throw new IllegalArgumentException("Size cannot be negative:" + size);
        }
        this.lastSize.set(size);
        Vector3f stackSize = size.clone();
        Vector3f offset = new Vector3f();
        for (GuiComponent c : this.componentStack.getArray()) {
            c.reshape(offset, stackSize);
            stackSize.x = Math.max(0.0f, stackSize.x);
            stackSize.y = Math.max(0.0f, stackSize.y);
            stackSize.z = Math.max(0.0f, stackSize.z);
        }
        if (this.layout != null) {
            this.layout.reshape(offset, stackSize);
        }
        if (this.listeners != null) {
            for (GuiControlListener l : (GuiControlListener[])this.listeners.getArray()) {
                l.reshape(this, offset, size);
            }
        }
    }

    public Vector3f getSize() {
        return this.lastSize;
    }

    public List<GuiComponent> getComponents() {
        return this.componentStack;
    }

    public <T extends GuiComponent> T addComponent(T c) {
        return this.componentStack.addComponent(c);
    }

    public int getComponentIndex(GuiComponent c) {
        return this.componentStack.indexOf(c);
    }

    public <T extends GuiComponent> T setComponent(String key, T component) {
        return this.componentStack.setComponent(key, component);
    }

    public <T extends GuiComponent> T getComponent(String key) {
        return this.componentStack.getComponent(key);
    }

    public <T extends GuiComponent> T removeComponent(String key) {
        return this.componentStack.removeComponent(key);
    }

    public boolean removeComponent(GuiComponent c) {
        return this.componentStack.removeComponent(c);
    }

    @Override
    protected void attach() {
        this.componentStack.attach(this);
        if (this.layout != null) {
            this.layout.attach(this);
        }
        this.revalidate();
    }

    @Override
    protected void controlUpdate(float tpf) {
        if (this.updateListeners != null) {
            for (GuiUpdateListener l : (GuiUpdateListener[])this.updateListeners.getArray()) {
                l.guiUpdate(this, tpf);
            }
        }
        if (this.invalid) {
            this.revalidate();
        }
    }

    protected boolean hasParent() {
        if (this.getNode() == null) {
            return false;
        }
        return this.getNode().getParent() != null;
    }

    protected boolean isChild() {
        return this.getNode().getParent() != null && this.getNode().getParent().getControl(GuiControl.class) != null;
    }

    protected void revalidate() {
        this.invalid = false;
        if (this.isChild()) {
            return;
        }
        Vector3f size = this.getPreferredSize().clone();
        this.setSize(size);
    }

    public void invalidate() {
        if (this.getNode() == null) {
            return;
        }
        if (this.isChild()) {
            ((GuiControl)this.getNode().getParent().getControl(GuiControl.class)).invalidate();
            this.invalid = false;
        } else {
            this.invalid = true;
        }
    }

    @Override
    protected void detach() {
        if (this.layout != null) {
            this.layout.detach(this);
        }
        this.componentStack.detach(this);
    }
}

