/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.opencl.OpenCLObject;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenCLObjectManager {
    private static final Logger LOG = Logger.getLogger(OpenCLObjectManager.class.getName());
    private static final Level LOG_LEVEL1 = Level.FINEST;
    private static final Level LOG_LEVEL2 = Level.FINER;
    private static final OpenCLObjectManager INSTANCE = new OpenCLObjectManager();
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final HashSet<OpenCLObjectRef> activeObjects = new HashSet();

    private OpenCLObjectManager() {
    }

    public static OpenCLObjectManager getInstance() {
        return INSTANCE;
    }

    public void registerObject(OpenCLObject obj) {
        OpenCLObjectRef ref = new OpenCLObjectRef(this.refQueue, obj);
        this.activeObjects.add(ref);
        LOG.log(LOG_LEVEL1, "registered OpenCL object: {0}", obj);
    }

    private void deleteObject(OpenCLObjectRef ref) {
        LOG.log(LOG_LEVEL1, "deleting OpenCL object by: {0}", ref.releaser);
        ref.releaser.release();
        ref.clear();
        this.activeObjects.remove(ref);
    }

    public void deleteUnusedObjects() {
        OpenCLObjectRef ref;
        if (this.activeObjects.isEmpty()) {
            LOG.log(LOG_LEVEL2, "no active natives");
            return;
        }
        int removed = 0;
        while ((ref = (OpenCLObjectRef)this.refQueue.poll()) != null) {
            this.deleteObject(ref);
            ++removed;
        }
        if (removed >= 1) {
            LOG.log(LOG_LEVEL2, "{0} native objects were removed from native", removed);
        }
    }

    public void deleteAllObjects() {
        for (OpenCLObjectRef ref : this.activeObjects) {
            LOG.log(LOG_LEVEL1, "deleting OpenCL object by: {0}", ref.releaser);
            ref.releaser.release();
            ref.clear();
        }
        this.activeObjects.clear();
    }

    private static class OpenCLObjectRef
    extends PhantomReference<Object> {
        private final OpenCLObject.ObjectReleaser releaser;

        public OpenCLObjectRef(ReferenceQueue<Object> refQueue, OpenCLObject obj) {
            super(obj, refQueue);
            this.releaser = obj.getReleaser();
        }
    }
}

