/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mythruna.fabric.ClothingAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingBuilder
extends ClothingAccumulator
implements VersionedObject<ClothingBuilder> {
    static Logger log = LoggerFactory.getLogger(ClothingBuilder.class);
    private long version;
    private Map<Vec3i, Integer> changes = new HashMap<Vec3i, Integer>();

    public ClothingBuilder(int width, int height, int layers) {
        super(width, height, layers);
    }

    public void clear() {
        super.clear();
        this.changes.clear();
        ++this.version;
    }

    public void setCells(CellArray source) {
        this.changes.clear();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int layer = this.getLayer(i, j);
                if (layer <= 0) continue;
                this.markChanged(i, j, 0);
            }
        }
        super.clear();
        super.addCells(source);
    }

    public long getVersion() {
        return this.version;
    }

    public ClothingBuilder getObject() {
        return this;
    }

    public VersionedReference<ClothingBuilder> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    public void invalidate() {
        ++this.version;
    }

    public int addValue(int x, int y, int value) {
        int result = super.addValue(x, y, value);
        if (result == value) {
            ++this.version;
            this.markChanged(x, y, value);
        }
        return result;
    }

    public int removeSwatch(int x, int y) {
        int result = super.removeSwatch(x, y);
        if (result != 0) {
            ++this.version;
            this.markChanged(x, y, 0);
        }
        return result;
    }

    protected void markChanged(int x, int y, int value) {
        Vec3i key = new Vec3i(x, y, 0);
        this.changes.put(key, value);
    }

    public boolean[][] drainChangedCells() {
        if (this.changes.isEmpty()) {
            return null;
        }
        boolean[][] results = new boolean[this.getSizeX()][this.getSizeY()];
        for (Vec3i v : this.changes.keySet()) {
            results[v.x][v.y] = true;
        }
        this.changes.clear();
        return results;
    }

    public Set<Vec3i> drainChanges() {
        if (this.changes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Vec3i> results = new HashSet<Vec3i>(this.changes.keySet());
        this.changes.clear();
        return results;
    }
}

