/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.StringIndex;
import com.simsilica.es.WatchedEntity;
import com.simsilica.es.base.ComponentHandler;
import com.simsilica.es.base.DefaultEntity;
import com.simsilica.es.base.DefaultEntityIdGenerator;
import com.simsilica.es.base.DefaultEntitySet;
import com.simsilica.es.base.DefaultWatchedEntity;
import com.simsilica.es.base.EntityIdGenerator;
import com.simsilica.es.base.MapComponentHandler;
import com.simsilica.es.base.MemStringIndex;
import com.simsilica.util.ReportSystem;
import com.simsilica.util.Reporter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntityData
implements ObservableEntityData {
    static Logger log = LoggerFactory.getLogger(DefaultEntityData.class);
    private final Map<Class<? extends EntityComponent>, ComponentHandler> handlers = new ConcurrentHashMap<Class<? extends EntityComponent>, ComponentHandler>();
    private EntityIdGenerator idGenerator;
    private StringIndex stringIndex;
    private final List<DefaultEntitySet> entitySets = new CopyOnWriteArrayList<DefaultEntitySet>();
    private final List<EntityComponentListener> entityListeners = new CopyOnWriteArrayList<EntityComponentListener>();

    public DefaultEntityData() {
        this(new DefaultEntityIdGenerator());
    }

    public DefaultEntityData(EntityIdGenerator idGenerator) {
        ReportSystem.registerCacheReporter(new EntitySetsReporter());
        this.idGenerator = idGenerator;
        if (this.getClass() == DefaultEntityData.class) {
            this.stringIndex = new MemStringIndex();
        }
    }

    protected void setIdGenerator(EntityIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    protected void setStringIndex(StringIndex stringIndex) {
        this.stringIndex = stringIndex;
    }

    protected <T extends EntityComponent> void registerComponentHandler(Class<T> type, ComponentHandler<T> handler) {
        this.handlers.put(type, handler);
    }

    @Override
    public void addEntityComponentListener(EntityComponentListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.entityListeners.add(l);
    }

    @Override
    public void removeEntityComponentListener(EntityComponentListener l) {
        this.entityListeners.remove(l);
    }

    @Override
    public void close() {
    }

    @Override
    public EntityId createEntity() {
        return new EntityId(this.idGenerator.nextEntityId());
    }

    @Override
    public void removeEntity(EntityId entityId) {
        if (log.isTraceEnabled()) {
            log.trace("removeEntity(" + entityId + ")");
        }
        for (Class<? extends EntityComponent> c : this.handlers.keySet()) {
            this.removeComponent(entityId, c);
        }
    }

    @Override
    public StringIndex getStrings() {
        return this.stringIndex;
    }

    protected <T extends EntityComponent> ComponentHandler<T> lookupDefaultHandler(Class<T> type) {
        return new MapComponentHandler();
    }

    protected <T extends EntityComponent> boolean hasHandler(Class<T> type) {
        return this.handlers.containsKey(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends EntityComponent> ComponentHandler<T> getHandler(Class type) {
        ComponentHandler<T> result = this.handlers.get(type);
        if (result == null) {
            DefaultEntityData defaultEntityData = this;
            synchronized (defaultEntityData) {
                result = this.handlers.get(type);
                if (result == null) {
                    result = this.lookupDefaultHandler(type);
                    this.handlers.put(type, result);
                }
            }
        }
        return result;
    }

    @Override
    public <T extends EntityComponent> T getComponent(EntityId entityId, Class<T> type) {
        if (entityId == null) {
            throw new IllegalArgumentException("EntityId cannot be null.");
        }
        ComponentHandler<T> handler = this.getHandler(type);
        return handler.getComponent(entityId);
    }

    @Override
    public <T extends EntityComponent> void setComponent(EntityId entityId, T component) {
        if (entityId == null) {
            throw new IllegalArgumentException("EntityId cannot be null.");
        }
        ComponentHandler<T> handler = this.getHandler(component.getClass());
        handler.setComponent(entityId, component);
        this.entityChange(new EntityChange(entityId, component));
    }

    @Override
    public <T extends EntityComponent> boolean removeComponent(EntityId entityId, Class<T> type) {
        ComponentHandler<T> handler;
        boolean result;
        if (entityId == null) {
            throw new IllegalArgumentException("EntityId cannot be null.");
        }
        if (log.isTraceEnabled()) {
            log.trace("removeComponent(" + entityId + ", " + type + ")");
        }
        if (result = (handler = this.getHandler(type)).removeComponent(entityId)) {
            this.entityChange(new EntityChange(entityId, type));
        }
        return result;
    }

    protected EntityId findSingleEntity(ComponentFilter filter) {
        return this.getHandler(filter.getComponentType()).findEntity(filter);
    }

    protected Set<EntityId> getEntityIds(Class type) {
        return this.getHandler(type).getEntities();
    }

    protected Set<EntityId> getEntityIds(Class type, ComponentFilter filter) {
        return this.getHandler(type).getEntities(filter);
    }

    protected DefaultEntitySet createSet(ComponentFilter filter, Class ... types) {
        DefaultEntitySet set = new DefaultEntitySet(this, filter, types);
        this.entitySets.add(set);
        return set;
    }

    protected void replace(Entity e, EntityComponent oldValue, EntityComponent newValue) {
        this.setComponent(e.getId(), newValue);
    }

    @Override
    public void setComponents(EntityId entityId, EntityComponent ... components) {
        for (EntityComponent c : components) {
            this.setComponent(entityId, c);
        }
    }

    @Override
    public Entity getEntity(EntityId entityId, Class ... types) {
        EntityComponent[] values = new EntityComponent[types.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getComponent(entityId, types[i]);
        }
        return new DefaultEntity(this, entityId, values, types);
    }

    @Override
    public EntitySet getEntities(Class ... types) {
        DefaultEntitySet results = this.createSet(null, types);
        results.loadEntities(false);
        return results;
    }

    protected ComponentFilter forType(ComponentFilter filter, Class type) {
        if (filter == null || filter.getComponentType() != type) {
            return null;
        }
        return filter;
    }

    @Override
    public EntityId findEntity(ComponentFilter filter, Class ... types) {
        if (types == null || types.length == 0) {
            return this.findSingleEntity(filter);
        }
        Set<EntityId> first = this.getEntityIds(types[0], this.forType(filter, types[0]));
        if (first.isEmpty()) {
            return null;
        }
        HashSet<EntityId> and = new HashSet<EntityId>();
        and.addAll(first);
        for (int i = 1; i < types.length; ++i) {
            Set<EntityId> sub = this.getEntityIds(types[i], this.forType(filter, types[i]));
            if (sub.isEmpty()) {
                return null;
            }
            and.retainAll(sub);
        }
        if (and.isEmpty()) {
            return null;
        }
        return (EntityId)and.iterator().next();
    }

    @Override
    public Set<EntityId> findEntities(ComponentFilter filter, Class ... types) {
        Set<EntityId> first;
        if (types == null || types.length == 0) {
            types = new Class[]{filter.getComponentType()};
        }
        if ((first = this.getEntityIds(types[0], this.forType(filter, types[0]))).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EntityId> and = new HashSet<EntityId>();
        and.addAll(first);
        for (int i = 1; i < types.length; ++i) {
            Set<EntityId> sub = this.getEntityIds(types[i], this.forType(filter, types[i]));
            if (sub.isEmpty()) {
                return Collections.emptySet();
            }
            and.retainAll(sub);
        }
        return and;
    }

    @Override
    public EntitySet getEntities(ComponentFilter filter, Class ... types) {
        DefaultEntitySet results = this.createSet(filter, types);
        results.loadEntities(false);
        return results;
    }

    @Override
    public WatchedEntity watchEntity(EntityId id, Class ... types) {
        return new DefaultWatchedEntity(this, id, types);
    }

    protected void releaseEntitySet(EntitySet entities) {
        this.entitySets.remove((DefaultEntitySet)entities);
    }

    protected void entityChange(EntityChange change) {
        for (EntityComponentListener l : this.entityListeners) {
            l.componentChange(change);
        }
        for (DefaultEntitySet set : this.entitySets) {
            set.entityChange(change);
        }
    }

    private class EntitySetsReporter
    implements Reporter {
        private EntitySetsReporter() {
        }

        @Override
        public void printReport(String type, PrintWriter out) {
            out.println("EntityData->EntitySets:" + DefaultEntityData.this.entitySets.size());
        }
    }
}

