/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnLightData;
import com.simsilica.mworld.db.ColumnNeighborhood;
import com.simsilica.mworld.db.ColumnPostProcessor;
import com.simsilica.mworld.db.PostProcColumnDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalLightingProcessor
implements ColumnPostProcessor {
    static Logger log = LoggerFactory.getLogger(InternalLightingProcessor.class);
    private PostProcColumnDb parent;
    private ColumnDb delegate;

    @Override
    public void initialize(PostProcColumnDb parent) {
        this.parent = parent;
        this.delegate = parent.getDelegate();
    }

    @Override
    public void terminate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postProcess(ColumnData col) {
        int top;
        if (col.hasGenerationFlag(4)) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("postProcess(" + col + ")  flags:" + Long.toBinaryString(col.getGenerationFlags()));
        }
        LeafData[] leafs = col.getLeafs();
        for (top = leafs.length - 1; top >= 0 && leafs[top].isEmpty(); --top) {
        }
        int yTop = top * 32 + 32;
        if (log.isTraceEnabled()) {
            log.trace("Highest y value:" + yTop);
        }
        ColumnNeighborhood cellData = new ColumnNeighborhood(this.delegate, col);
        ColumnLightData lightData = ColumnLightData.loadNeighborhood(this.delegate, col, true);
        ColumnData columnData = col;
        synchronized (columnData) {
            LightUtils.recalculateLighting((CellData)cellData, (CellData)lightData, (int)0, (int)0, (int)0, (int)32, (int)yTop, (int)32);
            col.setGenerationFlag(4);
        }
        if (log.isTraceEnabled()) {
            log.trace("end postProcess(" + col + ")  flags:" + Long.toBinaryString(col.getGenerationFlags()));
        }
        return true;
    }
}

