/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TerrainImageType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainImageProtocol
implements ObjectProtocol<TerrainImage> {
    static Logger log = LoggerFactory.getLogger(TerrainImageProtocol.class);
    private static final int ELEVATION_BITS = 10;
    private static final int TYPE_BITS = 8;
    private static final int LIGHT_BITS = 8;
    private int version = 43;

    @Override
    public int getProtocolVersion() {
        return this.version;
    }

    @Override
    public void write(TerrainImage terrain, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 16);
        TerrainImageId imageId = terrain.getId();
        long id = imageId.getTileId().getId();
        out.writeLongBits(id, 64);
        int scale = 1024 / imageId.getResolution().getSamples();
        out.writeBits(scale, 8);
        out.writeBits((int)imageId.getType().getId(), 4);
        out.writeLongBits(terrain.getVersion().getVersion(), 64);
        out.writeBits(terrain.getGenerationLevel(), 8);
        int size = terrain.getSize();
        size *= size;
        short[] elevations = terrain.getElevations();
        for (int i = 0; i < size; ++i) {
            out.writeBits((int)elevations[i], 10);
        }
        byte[] types = terrain.getTypes();
        for (int i = 0; i < size; ++i) {
            out.writeBits((int)types[i], 8);
        }
        byte[] lights = terrain.getLights();
        for (int i = 0; i < size; ++i) {
            out.writeBits((int)lights[i], 8);
        }
    }

    @Override
    public TerrainImage read(BitInputStream in) throws IOException {
        int version = in.readBits(16);
        TileId tileId = new TileId(in.readLongBits(64));
        int scale = in.readBits(8);
        int typeId = in.readBits(4);
        int size = 1024 / scale;
        long dataVersion = in.readLongBits(64);
        DataVersion layerVersion = new DataVersion(dataVersion);
        int generationLevel = 0;
        if (version >= 43) {
            generationLevel = in.readBits(8);
        }
        Resolution resolution = Resolution.fromSamples(size);
        TerrainImageType type = TerrainImageType.forId(typeId);
        TerrainImageId id = new TerrainImageId(tileId, type, resolution);
        TerrainImage layer = new TerrainImage(id, layerVersion, generationLevel);
        size *= size;
        short[] elevations = layer.getElevations();
        for (int i = 0; i < size; ++i) {
            elevations[i] = (short)in.readBits(10);
        }
        byte[] types = layer.getTypes();
        for (int i = 0; i < size; ++i) {
            types[i] = (byte)in.readBits(8);
        }
        byte[] lights = layer.getLights();
        for (int i = 0; i < size; ++i) {
            lights[i] = (byte)in.readBits(8);
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(TerrainImage terrain, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(terrain, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerrainImage read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            TerrainImage terrainImage = this.read(in);
            return terrainImage;
        }
    }
}

