/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.sim.GameSystemManager;
import java.util.Locale;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.net.AccountEvent;
import mythruna.net.DataSession;
import mythruna.net.DataSessionListener;
import mythruna.text.TextDb;
import mythruna.text.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSessionHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(DataSessionHostedService.class);
    private static final String ATTRIBUTE_SESSION = DataSession.class.getName();
    private GameSystemManager gameSystems;
    private RmiHostedService rmiService;
    private byte channel;
    private TextDb textDb;

    public DataSessionHostedService(GameSystemManager gameSystems, TextDb textDb, int channel) {
        this.gameSystems = gameSystems;
        this.textDb = textDb;
        this.channel = (byte)channel;
        this.setAutoHost(false);
    }

    protected DataSessionImpl getSession(HostedConnection conn) {
        return (DataSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("DataSessionHostedService requires an RMI service.");
        }
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
        EventBus.removeListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        DataSessionImpl session = this.getSession(conn);
        if (session != null) {
            session.close();
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    protected void accountLoggedOn(AccountEvent event) {
        log.info("accountLoggedOn(" + event + ")");
        HostedConnection conn = event.getConnection();
        DataSessionImpl session = new DataSessionImpl(conn);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((Object)session, DataSession.class);
        DataSessionListener listener = (DataSessionListener)rmi.getRemoteObject(DataSessionListener.class);
        if (listener == null) {
            throw new RuntimeException("Unable to locate client callback for DataSessionListener");
        }
        listener.dataAvailable();
    }

    protected void accountLoggedOff(AccountEvent event) {
        log.info("accountLoggedOff(" + event + ")");
        this.stopHostingOnConnection(event.getConnection());
    }

    private class DataSessionImpl
    implements DataSession {
        private HostedConnection conn;
        private Locale locale;

        public DataSessionImpl(HostedConnection conn) {
            this.conn = conn;
        }

        public void close() {
            log.info("close():" + this);
        }

        @Override
        public byte[] getCellArrayBytes(long id) {
            CellArray array = ((CellArrayStorage)DataSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(new CellArrayId(id));
            return CellArrayProtocol.toBytes((CellArray)array);
        }

        @Override
        public CellArray getCellArray(CellArrayId id) {
            return ((CellArrayStorage)DataSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(id);
        }

        @Override
        public void setLocale(String countryCode) {
            log.info("setLocale(" + countryCode + "): " + this);
            this.locale = new Locale(countryCode);
        }

        @Override
        public String getText(String id) {
            return DataSessionHostedService.this.textDb.getText(id, this.locale);
        }

        @Override
        public byte[] getTextData(String id) {
            String text = this.getText(id);
            return TextUtils.compress(text);
        }

        @Override
        public FabricTypeData getFabricTypeData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getFabricTypeDataBytes() {
            byte[] result = FabricTypeData.toBytes(FabricTypeIndex.toData());
            return result;
        }

        @Override
        public SwatchShapeData getSwatchShapeData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getSwatchShapeDataBytes() {
            log.info("getSwatchShapeDataBytes()");
            return SwatchShapeData.toBytes(SwatchShapeIndex.toData());
        }
    }
}

