/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mphys.AbstractShape;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeFactoryRegistry<S extends AbstractShape>
implements ShapeFactory<S> {
    static Logger log = LoggerFactory.getLogger(ShapeFactoryRegistry.class);
    private Map<Integer, ShapeFactory<? extends S>> registry = new HashMap<Integer, ShapeFactory<? extends S>>();
    private ShapeFactory<? extends S> defaultFactory;

    public void setDefaultFactory(ShapeFactory<? extends S> factory) {
        this.defaultFactory = factory;
    }

    public ShapeFactory<? extends S> getDefaultFactory() {
        return this.defaultFactory;
    }

    public void registerFactory(ShapeInfo info, ShapeFactory<? extends S> factory) {
        this.registry.put(info.getShapeId(), factory);
    }

    public ShapeFactory<? extends S> getFactory(ShapeInfo info) {
        ShapeFactory<? extends S> result = this.registry.get(info.getShapeId());
        if (result == null && log.isDebugEnabled()) {
            log.debug("Using default.  Missed:" + info.getShapeId() + " in registry keys:" + this.registry.keySet());
        }
        return result == null ? this.defaultFactory : result;
    }

    @Override
    public S createShape(ShapeInfo info, Mass mass) {
        ShapeFactory<S> factory = this.getFactory(info);
        return factory == null ? null : (S)factory.createShape(info, mass);
    }
}

