/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.jme3.util.TangentBinormalGenerator;
import com.simsilica.lemur.GuiGlobals;
import mythruna.fabric.ClothingPainter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesignArea
extends Node {
    static Logger log = LoggerFactory.getLogger(DesignArea.class);
    private String dummyAsset = "dummies/female/tailors-dummy-female.gltf.j3o";
    private Node dummy;
    private Mode mode = Mode.Full;
    private boolean showLeft = true;
    private boolean showRight = true;
    private boolean visibilityInvalid = true;
    private ClothingPainter painter;
    private ColorRGBA localLighting = new ColorRGBA(0.1f, 0.1f, 0.1f, 1.0f);
    private Part body;
    private Part pelvis;
    private Part leftArm;
    private Part rightArm;
    private Part leftLeg;
    private Part rightLeg;
    private Part leftBoot;
    private Part rightBoot;
    private Part[] parts;

    public DesignArea(AssetManager assets, ClothingPainter painter) {
        super("designArea");
        this.painter = painter;
        float size = 4.0f;
        float halfSize = size * 0.5f;
        this.setLocalScale(100.0f);
        Quad quad = new Quad(size, size){

            public int collideWith(Collidable other, Matrix4f worldMatrix, BoundingVolume worldBound, CollisionResults results) {
                return 0;
            }
        };
        Texture texture3 = assets.loadTexture("Interface/old-paper-flattened.png");
        Material mat3 = GuiGlobals.getInstance().createMaterial(texture3, true).getMaterial();
        mat3.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat3.setColor("Diffuse", new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        mat3.setColor("Ambient", new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        mat3.setBoolean("UseMaterialColors", true);
        Geometry geom = new Geometry("platform.paper", (Mesh)quad);
        geom.move(-halfSize, 0.0f, halfSize);
        geom.rotate(-1.5707964f, 0.0f, 0.0f);
        geom.setMaterial(mat3);
        geom.setLocalScale(1.4f);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        geom.move(-0.2f * size, -0.05f, 0.2f * size);
        this.attachChild((Spatial)geom);
        this.dummy = (Node)assets.loadModel(this.dummyAsset);
        TangentBinormalGenerator.generate((Spatial)this.dummy);
        this.dummy.setLocalScale(1.0f);
        this.body = new Part(this.dummy, "Body");
        this.pelvis = new Part(this.dummy, "Pelvis");
        this.leftBoot = new Part(this.dummy, "LeftBoot");
        this.leftArm = new Part(this.dummy, "LeftArm");
        this.leftLeg = new Part(this.dummy, "LeftLeg");
        this.rightBoot = new Part(this.dummy, "RightBoot");
        this.rightArm = new Part(this.dummy, "RightArm");
        this.rightLeg = new Part(this.dummy, "RightLeg");
        this.parts = new Part[]{this.body, this.pelvis, this.leftBoot, this.rightBoot, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg};
        this.fixPartTextures(assets);
        this.attachChild((Spatial)this.dummy);
    }

    protected void fixPartTextures(AssetManager assets) {
        for (Part part : this.parts) {
            Material newMat = new Material(assets, "MatDefs/LocalLighting.j3md");
            newMat.setTexture("DiffuseMap", this.painter.getDiffuseTexture());
            newMat.setTexture("NormalMap", this.painter.getNormalTexture());
            newMat.setTexture("SpecularMap", this.painter.getSpecularTexture());
            newMat.setBoolean("UseMaterialColors", true);
            newMat.setColor("Diffuse", ColorRGBA.White);
            newMat.setColor("Ambient", ColorRGBA.White);
            newMat.setColor("Specular", ColorRGBA.White);
            newMat.setFloat("Shininess", 512.0f);
            newMat.setColor("LocalLighting", this.localLighting);
            part.geom.setMaterial(newMat);
            Material mat = part.geom.getMaterial();
            log.info("mat UseMaterialColors:" + mat.getParam("UseMaterialColors"));
            log.info("mat diffuse:" + mat.getParam("Diffuse") + "  ambient:" + mat.getParam("Ambient"));
            log.info("mat specular:" + mat.getParam("Specular") + "  shininess:" + mat.getParam("Shininess"));
            mat.setTexture("DiffuseMap", this.painter.getDiffuseTexture());
            mat.setTexture("NormalMap", this.painter.getNormalTexture());
            mat.setTexture("SpecularMap", this.painter.getSpecularTexture());
            mat.setColor("Specular", ColorRGBA.White);
            mat.setFloat("Shininess", 512.0f);
        }
    }

    public void setMode(Mode mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.visibilityInvalid = true;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setShowLeft(boolean showLeft) {
        if (this.showLeft == showLeft) {
            return;
        }
        this.showLeft = showLeft;
        this.visibilityInvalid = true;
    }

    public boolean getShowLeft() {
        return this.showLeft;
    }

    public void setShowRight(boolean showRight) {
        if (this.showRight == showRight) {
            return;
        }
        this.showRight = showRight;
        this.visibilityInvalid = true;
    }

    public boolean getShowRight() {
        return this.showRight;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.visibilityInvalid) {
            this.resetVisibility();
        }
    }

    protected float getMinY(Geometry geom) {
        BoundingBox bb = (BoundingBox)geom.getModelBound();
        Vector3f center = bb.getCenter();
        Vector3f pos = geom.getLocalTranslation();
        return pos.y + center.y - bb.getYExtent();
    }

    protected float getMaxY(Geometry geom) {
        BoundingBox bb = (BoundingBox)geom.getModelBound();
        Vector3f center = bb.getCenter();
        Vector3f pos = geom.getLocalTranslation();
        return pos.y + center.y + bb.getYExtent();
    }

    protected void resetVisibility() {
        this.visibilityInvalid = false;
        for (Part part : this.parts) {
            part.setVisible(false);
        }
        float scale = 1.0f;
        float yMin = Float.POSITIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        switch (this.mode) {
            case Boots: {
                if (this.showLeft) {
                    this.leftBoot.setVisible(true);
                    yMin = Math.min(this.leftBoot.yMin, yMin);
                    yMax = Math.max(this.leftBoot.yMax, yMax);
                }
                if (this.showRight) {
                    this.rightBoot.setVisible(true);
                    yMin = Math.min(this.rightBoot.yMin, yMin);
                    yMax = Math.max(this.rightBoot.yMax, yMax);
                }
                scale = 2.5f;
                break;
            }
            case Pants: {
                this.pelvis.setVisible(true);
                yMin = Math.min(this.pelvis.yMin, yMin);
                yMax = Math.max(this.pelvis.yMax, yMax);
                if (this.showLeft) {
                    this.leftLeg.setVisible(true);
                    yMin = Math.min(this.leftLeg.yMin, yMin);
                    yMax = Math.max(this.leftLeg.yMax, yMax);
                }
                if (this.showRight) {
                    this.rightLeg.setVisible(true);
                    yMin = Math.min(this.rightLeg.yMin, yMin);
                    yMax = Math.max(this.rightLeg.yMax, yMax);
                }
                scale = 2.0f;
                break;
            }
            case Full: {
                this.body.setVisible(true);
                this.pelvis.setVisible(true);
                yMin = Math.min(this.pelvis.yMin, yMin);
                yMax = Math.max(this.body.yMax, yMax);
                if (this.showLeft) {
                    this.leftArm.setVisible(true);
                    this.leftLeg.setVisible(true);
                    this.leftBoot.setVisible(true);
                    yMin = Math.min(this.leftBoot.yMin, yMin);
                    yMax = Math.max(this.leftArm.yMax, yMax);
                }
                if (this.showRight) {
                    this.rightArm.setVisible(true);
                    this.rightLeg.setVisible(true);
                    this.rightBoot.setVisible(true);
                    yMin = Math.min(this.rightBoot.yMin, yMin);
                    yMax = Math.max(this.rightArm.yMax, yMax);
                }
                scale = 1.2f;
                break;
            }
            case Torso: {
                this.body.setVisible(true);
                this.pelvis.setVisible(true);
                yMin = Math.min(this.pelvis.yMin, yMin);
                yMax = Math.max(this.body.yMax, yMax);
                if (this.showLeft) {
                    this.leftArm.setVisible(true);
                }
                if (this.showRight) {
                    this.rightArm.setVisible(true);
                }
                scale = 3.0f;
            }
        }
        log.info("yMin:" + yMin + "  yMax:" + yMax);
        this.dummy.setLocalScale(scale);
        float dummyScale = this.dummy.getLocalScale().x;
        this.dummy.setLocalTranslation(0.0f, -yMin * dummyScale, 0.0f);
        float offset = dummyScale * (yMax - yMin) * 0.5f;
        float ourScale = this.getLocalScale().x;
        this.setLocalTranslation(0.0f, -offset * ourScale, 0.0f);
    }

    public static enum Mode {
        Full,
        Torso,
        Pants,
        Boots;

    }

    private class Part {
        private String name;
        private Node model;
        private Geometry geom;
        private boolean visible = true;
        private float yMin;
        private float yMax;

        public Part(Node model, String name) {
            this.model = model;
            this.name = name;
            this.geom = (Geometry)model.getChild(name);
            BoundingBox bb = (BoundingBox)this.geom.getModelBound();
            Vector3f center = bb.getCenter();
            Vector3f pos = this.geom.getLocalTranslation();
            this.yMin = pos.y + center.y - bb.getYExtent();
            this.yMax = pos.y + center.y + bb.getYExtent();
        }

        public boolean setVisible(boolean visible) {
            if (this.visible == visible) {
                return false;
            }
            this.visible = visible;
            if (visible) {
                this.model.attachChild((Spatial)this.geom);
            } else {
                this.geom.removeFromParent();
            }
            return true;
        }
    }
}

